/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreparedStatementInvocationHandler
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(PreparedStatementInvocationHandler.class.getName());
    private final PreparedStatement ps;

    public PreparedStatementInvocationHandler(PreparedStatement ps) {
        this.ps = ps;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.ps, args);
        }
        catch (Throwable ex) {
            if (this.isReadOnlyException(ex)) {
                log.log(Level.FINEST, "Database connection threw read-only exception, marking it as such co reinitialise it: " + this.ps.getConnection());
                this.ps.getConnection().setReadOnly(true);
            }
            if (ex instanceof UndeclaredThrowableException) {
                ex = ((UndeclaredThrowableException)ex).getUndeclaredThrowable();
            }
            if (ex instanceof InvocationTargetException) {
                throw ((InvocationTargetException)ex).getTargetException();
            }
            throw ex;
        }
    }

    private boolean isMySqlReadOnly(SQLException sqlex) {
        return sqlex.getErrorCode() == 1290 && "HY000".equals(sqlex.getSQLState());
    }

    private boolean isPostgresReadOnly(SQLException sqlex) {
        return sqlex.getErrorCode() == 0 && "25006".equals(sqlex.getSQLState());
    }

    private boolean isReadOnlyException(Throwable ex) {
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        if (ex instanceof SQLException) {
            SQLException sqlex = (SQLException)ex;
            return this.isMySqlReadOnly(sqlex) || this.isPostgresReadOnly(sqlex);
        }
        return false;
    }
}

