/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.derby;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.Algorithms;

public class StoredProcedures {
    private static final Logger log = Logger.getLogger(StoredProcedures.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String DEFAULT_USERNAME_SHA1 = StoredProcedures.sha1("default");
    private static final String GET_VERSION = "select version from tig_schema_versions where (component = ?)";

    private static String encodePassword(String encMethod, String userId, String userPw) {
        if (encMethod != null && "MD5-PASSWORD".equals(encMethod)) {
            return StoredProcedures.md5(userPw);
        }
        if (encMethod != null && "MD5-USERID-PASSWORD".equals(encMethod)) {
            return StoredProcedures.md5(userId + userPw);
        }
        if (encMethod != null && "MD5-USERNAME-PASSWORD".equals(encMethod)) {
            return StoredProcedures.md5(userId.substring(0, userId.indexOf("@")) + userPw);
        }
        return userPw;
    }

    private static String md5(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (data != null) {
                md.update(data.getBytes(UTF8));
            }
            byte[] digest = md.digest();
            return Algorithms.bytesToHex((byte[])digest);
        }
        catch (Exception e) {
            throw new RuntimeException("Error on encoding password", e);
        }
    }

    private static String sha1(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            if (data != null) {
                md.update(data.getBytes(UTF8));
            }
            byte[] digest = md.digest();
            return Algorithms.bytesToHex((byte[])digest);
        }
        catch (Exception e) {
            throw new RuntimeException("Error on encoding password", e);
        }
    }

    public static void tigAccountStatus(String user, ResultSet[] data) throws SQLException {
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            conn.setTransactionIsolation(2);
            PreparedStatement ps = conn.prepareStatement("SELECT account_status FROM tig_users WHERE lower(user_id) = ?");
            ps.setString(1, user);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigActiveAccounts(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where account_status > 0");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigAddNode(long parentNid, long uid, String node, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("insert into tig_nodes (parent_nid, uid, node) values (?, ?, ?)", 1);
            ps.setLong(1, parentNid);
            ps.setLong(2, uid);
            ps.setString(3, node);
            ps.executeUpdate();
            data[0] = ps.getGeneratedKeys();
        }
    }

    public static void tigAddUser(String userId, String userPw, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("insert into tig_users (user_id) values (?)", 1);
            ps.setString(1, userId);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            long generatedKey = rs.getLong(1);
            if (userPw != null) {
                StoredProcedures.tigUpdatePasswordPlainPw(userId, userPw);
            }
            PreparedStatement ps3 = conn.prepareStatement("select uid from tig_users where uid=?");
            ps3.setLong(1, generatedKey);
            data[0] = ps3.executeQuery();
            PreparedStatement ps2 = conn.prepareStatement("insert into tig_nodes (parent_nid, uid, node) values (NULL, ?, 'root')");
            ps2.setLong(1, generatedKey);
            ps2.executeUpdate();
            if (null == userPw) {
                PreparedStatement ps4 = conn.prepareStatement("update tig_users set account_status = -1 where uid = ?");
                ps4.setLong(1, generatedKey);
                ps4.executeUpdate();
            }
        }
    }

    public static void tigAddUserPlainPw(String userId, String userPw, ResultSet[] data) throws SQLException {
        String encMethod = StoredProcedures.tigGetDBProperty("password-encoding");
        String encp = StoredProcedures.encodePassword(encMethod, userId, userPw);
        StoredProcedures.tigAddUser(userId, encp, data);
    }

    public static void tigAllUsers(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select user_id, failed_logins, account_status from tig_users");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigAllUsersCount(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select count(*) as res_cnt from tig_users");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigDisableAccount(String userId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_users set account_status = 0 where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
    }

    public static void tigDisabledAccounts(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where account_status = 0");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigEnableAccount(String userId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_users set account_status = 1 where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
    }

    public static void tigGetComponentVersion(String component, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Object result = null;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Getting version of the component: " + component);
            }
            PreparedStatement ps = conn.prepareStatement(GET_VERSION);
            ps.setString(1, component.toLowerCase());
            data[0] = ps.executeQuery();
        }
    }

    public static String tigGetDBProperty(String key) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String result = null;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("function tigGetDBProperty('" + key + "') called");
            }
            PreparedStatement ps = conn.prepareStatement("select pval from tig_pairs, tig_users where (pkey = ?) AND (user_id = 'db-properties') AND (tig_pairs.uid = tig_users.uid)");
            ps.setString(1, key.toLowerCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            String string = result;
            return string;
        }
    }

    public static void tigGetPassword(String userId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select c.value from tig_users u  inner join tig_user_credentials c on c.uid = u.uid  where  u.user_id = ?  and c.mechanism = 'PLAIN'  and c.username = 'default'");
            ps.setString(1, userId.toLowerCase());
            data[0] = ps.executeQuery();
        }
    }

    public static void tigGetUserDBUid(String userId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select uid from tig_users where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            data[0] = ps.executeQuery();
        }
    }

    public static void tigInitdb() throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_users set online_status = 0");
            ps.executeUpdate();
        }
    }

    public static void tigOfflineUsers(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where online_status = 0");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigOnlineUsers(ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where online_status > 0");
            data[0] = ps.executeQuery();
        }
    }

    public static void tigRemoveUser(String userId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps3 = conn.prepareStatement("select uid from tig_users where lower(user_id) = ?");
            ps3.setString(1, userId.toLowerCase());
            ResultSet rs = ps3.executeQuery();
            if (!rs.next()) {
                return;
            }
            long uid = rs.getLong(1);
            PreparedStatement ps1 = conn.prepareStatement("delete from tig_pairs where uid = ?");
            ps1.setLong(1, uid);
            ps1.executeUpdate();
            PreparedStatement ps2 = conn.prepareStatement("delete from tig_nodes where uid = ?");
            ps2.setLong(1, uid);
            ps2.executeUpdate();
            PreparedStatement ps4 = conn.prepareStatement("delete from tig_user_credentials where uid = ?");
            ps4.setLong(1, uid);
            ps4.executeUpdate();
            PreparedStatement ps = conn.prepareStatement("delete from tig_users where uid = ?");
            ps.setLong(1, uid);
            ps.executeUpdate();
        }
    }

    public static void tigSetComponentVersion(String name, String version) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            int result;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Setting component: {0} version to: {1}", new Object[]{name, version});
            }
            PreparedStatement psComp = conn.prepareStatement(GET_VERSION);
            psComp.setString(1, name.toLowerCase());
            ResultSet rs = psComp.executeQuery();
            if (rs.next()) {
                String updateSql = "update tig_schema_versions set version = ? where (component = ?)";
                PreparedStatement ps = conn.prepareStatement("update tig_schema_versions set version = ? where (component = ?)");
                ps.setString(1, version);
                ps.setString(2, name);
                result = ps.executeUpdate();
            } else {
                String insertSql = "insert into tig_schema_versions (component, version, last_update) VALUES (?, ?, current timestamp) ";
                PreparedStatement ps = conn.prepareStatement("insert into tig_schema_versions (component, version, last_update) VALUES (?, ?, current timestamp) ");
                ps.setString(1, name);
                ps.setString(2, version);
                result = ps.executeUpdate();
            }
            if (result != 1) {
                log.severe("Error on Setting version");
            }
        }
    }

    public static void tigUpdateAccountStatus(String user, int status) throws SQLException {
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            conn.setTransactionIsolation(2);
            PreparedStatement ps = conn.prepareStatement("UPDATE tig_users SET account_status = ? WHERE lower(user_id) = ?");
            ps.setInt(1, status);
            ps.setString(2, user);
            ps.executeUpdate();
        }
    }

    public static void tigUpdateLoginTime(String userId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_users set last_used = current timestamp where lower(user_id) =  ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
    }

    public static void tigUpdatePairs(long nid, long uid, String key, Clob value) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pairs where nid = ? and uid = ? and pkey = ?");
            ps.setLong(1, nid);
            ps.setLong(2, uid);
            ps.setString(3, key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PreparedStatement ps1 = conn.prepareStatement("update tig_pairs set pval = ? where nid = ? and uid = ? and pkey = ?");
                ps1.setClob(1, value);
                ps1.setLong(2, nid);
                ps1.setLong(3, uid);
                ps1.setString(4, key);
                ps1.executeUpdate();
            } else {
                PreparedStatement ps1 = conn.prepareStatement("insert into tig_pairs (nid, uid, pkey, pval) values (?, ?, ?, ?)");
                ps1.setLong(1, nid);
                ps1.setLong(2, uid);
                ps1.setString(3, key);
                ps1.setClob(4, value);
                ps1.executeUpdate();
            }
        }
    }

    public static void tigUpdatePasswordPlainPw(String userId, String userPw) throws SQLException {
        String passwordEncoding = Optional.ofNullable(StoredProcedures.tigGetDBProperty("password-encoding")).orElse("PLAIN");
        String encodedPassword = StoredProcedures.encodePassword(passwordEncoding, userId, userPw);
        StoredProcedures.tigUserCredentialUpdate(userId, "default", passwordEncoding, encodedPassword);
    }

    public static void tigUpdatePasswordPlainPwRev(String userPw, String userId) throws SQLException {
        StoredProcedures.tigUpdatePasswordPlainPw(userId, userPw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigUserCredentialRemove(String userId, String username) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select uid from tig_users where lower(user_id) =  ?");
            ps.setString(1, userId.toLowerCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                long uid = rs.getLong(1);
                ps = conn.prepareStatement("delete from tig_user_credentials where uid = ? and username = ?");
                ps.setLong(1, uid);
                ps.setString(2, username);
                ps.execute();
            }
        }
    }

    public static void tigUserCredentialUpdate(String userId, String username, String mechanism, String value) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select uid from tig_users where lower(user_id) =  ?");
            ps.setString(1, userId.toLowerCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                long uid = rs.getLong(1);
                ps = conn.prepareStatement("select 1 from tig_user_credentials where uid = ? and username = ? and mechanism = ?");
                ps.setLong(1, uid);
                ps.setString(2, username);
                ps.setString(3, mechanism);
                rs = ps.executeQuery();
                if (rs.next()) {
                    ps = conn.prepareStatement("update tig_user_credentials set value = ? where uid = ? and username = ? and mechanism = ?");
                    ps.setString(1, value);
                    ps.setLong(2, uid);
                    ps.setString(3, username);
                    ps.setString(4, mechanism);
                    ps.executeUpdate();
                } else {
                    ps = conn.prepareStatement("insert into tig_user_credentials (uid, username, mechanism, value) values (?,?,?,?)");
                    ps.setLong(1, uid);
                    ps.setString(2, username);
                    ps.setString(3, mechanism);
                    ps.setString(4, value);
                    ps.execute();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigUserCredentialsGet(String userId, String username, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select c.mechanism, c.value, u.account_status from tig_users u  inner join tig_user_credentials c on c.uid = u.uid  where lower(u.user_id) = ? and c.username = ?");
            ps.setString(1, userId.toLowerCase());
            ps.setString(2, username);
            data[0] = ps.executeQuery();
        }
    }

    public static void tigUserLoginPlainPw(String userId, String userPw, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String passwordEncoding = Optional.ofNullable(StoredProcedures.tigGetDBProperty("password-encoding")).orElse("PLAIN");
            String encodedPassword = StoredProcedures.encodePassword(passwordEncoding, userId, userPw);
            PreparedStatement ps = conn.prepareStatement("select u.user_id from tig_users u inner join tig_user_credentials c on c.uid = u.uid where (u.account_status > 0) AND ( lower(u.user_id) = ?)  AND c.username = 'default' AND c.mechanism = ? AND c.value = ?");
            ps.setString(1, userId.toLowerCase());
            ps.setString(2, passwordEncoding);
            ps.setString(3, userPw);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PreparedStatement x = conn.prepareStatement("values '" + userId + "'");
                data[0] = x.executeQuery();
                PreparedStatement flps = conn.prepareStatement("update tig_users set online_status = online_status + 1, last_login = current timestamp where lower(user_id) =  ?");
                flps.setString(1, userId.toLowerCase());
                flps.executeUpdate();
            } else {
                PreparedStatement x = conn.prepareStatement("values '-'");
                data[0] = x.executeQuery();
                PreparedStatement flps = conn.prepareStatement("update tig_users set failed_logins = failed_logins + 1 where lower(user_id) = ?");
                flps.setString(1, userId.toLowerCase());
                flps.executeUpdate();
            }
        }
    }

    public static void tigUserLogout(String userId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("update tig_users set online_status = online_status - 1, last_logout = current timestamp where lower(user_id) =  ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tigUserUsernamesGet(String userId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement ps = conn.prepareStatement("select distinct c.username from tig_users u  inner join tig_user_credentials c on c.uid = u.uid  where lower(u.user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            data[0] = ps.executeQuery();
        }
    }
}

