/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import tigase.db.DataSource;
import tigase.xmpp.jid.BareJID;

public interface DataRepository
extends DataSource {
    public static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public boolean checkTable(String var1) throws SQLException;

    public boolean checkTable(String var1, String var2) throws SQLException;

    public void commit() throws SQLException;

    public Statement createStatement(BareJID var1) throws SQLException;

    public void endTransaction() throws SQLException;

    public void initPreparedStatement(String var1, String var2) throws SQLException;

    public void initPreparedStatement(String var1, String var2, int var3) throws SQLException;

    public void release(Statement var1, ResultSet var2);

    public void releaseRepoHandle(DataRepository var1);

    public void rollback() throws SQLException;

    public void startTransaction() throws SQLException;

    public DataRepository takeRepoHandle(BareJID var1);

    public dbTypes getDatabaseType();

    public int getPoolSize();

    public PreparedStatement getPreparedStatement(BareJID var1, String var2) throws SQLException;

    public PreparedStatement getPreparedStatement(int var1, String var2) throws SQLException;

    @Override
    public String getResourceUri();

    default public void setTimestamp(PreparedStatement stmt, int pos, Timestamp timestamp) throws SQLException {
        switch (this.getDatabaseType()) {
            case jtds: 
            case sqlserver: {
                stmt.setTimestamp(pos, timestamp, UTC_CALENDAR);
                break;
            }
            default: {
                stmt.setTimestamp(pos, timestamp);
            }
        }
    }

    default public Timestamp getTimestamp(ResultSet rs, int pos) throws SQLException {
        switch (this.getDatabaseType()) {
            case jtds: 
            case sqlserver: {
                return rs.getTimestamp(pos, UTC_CALENDAR);
            }
        }
        return rs.getTimestamp(pos);
    }

    default public Timestamp getTimestamp(ResultSet rs, String field) throws SQLException {
        switch (this.getDatabaseType()) {
            case jtds: 
            case sqlserver: {
                return rs.getTimestamp(field, UTC_CALENDAR);
            }
        }
        return rs.getTimestamp(field);
    }

    public static enum dbTypes {
        derby,
        mysql,
        postgresql,
        jtds,
        sqlserver,
        other;

    }
}

