/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.Module;
import tigase.component.responses.ResponseManager;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsInvocationHandler;
import tigase.stats.StatisticsList;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="stanzaProcessor", active=true)
public class StanzaProcessor
implements ComponentStatisticsProvider {
    private Logger log = Logger.getLogger(this.getClass().getName());
    @Inject(type=Module.class, nullAllowed=true)
    private List<Module> modules;
    @Inject
    private ResponseManager responseManager;
    @Inject
    private PacketWriter writer;
    private ConcurrentHashMap<Class<? extends Module>, ModuleStatistics> modulesStatistics = new ConcurrentHashMap();

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules == null ? Collections.emptyList() : modules;
        this.modulesStatistics = new ConcurrentHashMap<Class, ModuleStatistics>(modules.stream().collect(Collectors.toMap(Object::getClass, ModuleStatistics::new)));
    }

    public ResponseManager getResponseManager() {
        return this.responseManager;
    }

    public void setResponseManager(ResponseManager responseManager) {
        this.responseManager = responseManager;
    }

    public PacketWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PacketWriter writer) {
        this.writer = writer;
    }

    public void processPacket(Packet packet) {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Received: " + packet.getElement());
        }
        try {
            boolean handled;
            JID senderJID = packet.getStanzaFrom();
            if (senderJID == null) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(packet.getElemName() + " stanza without 'from' attribute ignored.");
                }
                return;
            }
            Runnable responseHandler = this.responseManager.getResponseHandler(packet);
            if (responseHandler != null) {
                handled = true;
                responseHandler.run();
            } else {
                handled = this.process(packet);
            }
            if (!handled && this.shouldSendException(packet)) {
                throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
            }
        }
        catch (TigaseStringprepException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessage() + " when processing " + packet.toString());
            }
            this.sendException(packet, new ComponentException(Authorization.JID_MALFORMED));
        }
        catch (ComponentException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessageWithPosition() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, e);
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, e.getMessage() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, new ComponentException(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    public void sendException(Packet packet, ComponentException e) {
        block4: {
            try {
                if (!this.shouldSendException(packet)) {
                    return;
                }
                Packet result = e.makeElement(packet, true);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Sending back: " + result.toString());
                }
                this.writer.write(result);
            }
            catch (Exception e1) {
                if (!this.log.isLoggable(Level.WARNING)) break block4;
                this.log.log(Level.WARNING, "Problem during generate error response", e1);
            }
        }
    }

    protected boolean shouldSendException(Packet packet) {
        StanzaType type = packet.getType();
        if (type == StanzaType.error || type == StanzaType.result) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(packet.getElemName() + " stanza with type='" + type + "' ignored");
            }
            return false;
        }
        return true;
    }

    @Override
    public void everyHour() {
        this.modulesStatistics.values().forEach(StatisticsInvocationHandler.Statistics::everyHour);
    }

    @Override
    public void everyMinute() {
        this.modulesStatistics.values().forEach(StatisticsInvocationHandler.Statistics::everyMinute);
    }

    @Override
    public void everySecond() {
        this.modulesStatistics.values().forEach(StatisticsInvocationHandler.Statistics::everySecond);
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        for (ModuleStatistics statistics : this.modulesStatistics.values()) {
            statistics.getStatistics(compName, "stanzaProcessor", list);
        }
    }

    private boolean process(Packet packet) throws ComponentException, TigaseStringprepException {
        boolean handled = false;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finest("Processing packet: " + packet.toString());
        }
        for (Module module : this.modules) {
            if (!module.canHandle(packet)) continue;
            handled = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Handled by module " + module.getClass());
            }
            this.execute(module, packet);
            if (!this.log.isLoggable(Level.FINEST)) continue;
            this.log.finest("Finished " + module.getClass());
        }
        return handled;
    }

    private void execute(Module module, Packet packet) throws ComponentException, TigaseStringprepException {
        ModuleStatistics statistics = this.modulesStatistics.get(module.getClass());
        try {
            long start = System.currentTimeMillis();
            module.process(packet);
            long end = System.currentTimeMillis();
            if (statistics != null) {
                statistics.updateExecutionTime(end - start);
            }
        }
        catch (Throwable ex) {
            if (statistics != null) {
                statistics.executionFailed();
            }
            throw ex;
        }
    }

    public static class ModuleStatistics
    extends StatisticsInvocationHandler.Statistics {
        private static String generateModuleName(Module module) {
            return module.getClass().getSimpleName();
        }

        public ModuleStatistics(Module module) {
            super(ModuleStatistics.generateModuleName(module));
        }
    }
}

