/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import tigase.auth.credentials.Credentials;
import tigase.db.beans.AuthRepositoryMDPoolBean;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.xmpp.jid.BareJID;

@Bean(name="credentialDecoders", parent=AuthRepositoryMDPoolBean.AuthRepositoryConfigBean.class, active=true)
public class CredentialsDecoderBean
implements RegistrarBean {
    @Inject
    private List<Credentials.Decoder> decoders;

    public List<String> getSupportedMechanisms() {
        return this.decoders.stream().map(dec -> dec.getName()).collect(Collectors.toList());
    }

    public Credentials.Entry decode(BareJID user, String mechanism, String password) throws NoSuchAlgorithmException {
        for (Credentials.Decoder decoder : this.decoders) {
            if (!mechanism.equals(decoder.getName())) continue;
            return decoder.decode(user, password);
        }
        throw new NoSuchAlgorithmException("No password decoder for mechanism " + mechanism);
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }
}

