/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import javax.security.auth.callback.CallbackHandler;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.MechanismNameAware;
import tigase.auth.NonAuthUserRepositoryAware;
import tigase.auth.SessionAware;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.callbacks.CallbackHandlerFactoryIfc;
import tigase.auth.impl.PlainCallbackHandler;
import tigase.auth.impl.ScramCallbackHandler;
import tigase.auth.impl.XTokenCallbackHandler;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="callback-handler-factory", parent=TigaseSaslProvider.class, active=true)
public class CallbackHandlerFactory
implements CallbackHandlerFactoryIfc {
    public static final String AUTH_JID = "authentication-jid";
    private static final String CALLBACK_HANDLER_KEY = "callbackhandler";

    @Override
    public CallbackHandler create(String mechanismName, XMPPResourceConnection session, NonAuthUserRepository repo) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> handlerClass;
        CallbackHandler handler;
        String handlerClassName = this.getHandlerClassname(mechanismName, session, repo);
        if (handlerClassName == null) {
            handlerClassName = PlainCallbackHandler.class.getName();
        }
        if ((handler = (CallbackHandler)(handlerClass = Class.forName(handlerClassName)).newInstance()) instanceof SessionAware) {
            ((SessionAware)((Object)handler)).setSession(session);
        }
        if (handler instanceof DomainAware) {
            ((DomainAware)((Object)handler)).setDomain(session.getDomain().getVhost().getDomain());
        }
        if (handler instanceof NonAuthUserRepositoryAware) {
            ((NonAuthUserRepositoryAware)((Object)handler)).setNonAuthUserRepository(repo);
        }
        if (handler instanceof AuthRepositoryAware) {
            ((AuthRepositoryAware)((Object)handler)).setAuthRepository(session.getAuthRepository());
        }
        if (handler instanceof MechanismNameAware) {
            ((MechanismNameAware)((Object)handler)).setMechanismName(mechanismName);
        }
        return handler;
    }

    protected String getHandlerClassname(String mechanismName, XMPPResourceConnection session, NonAuthUserRepository repo) {
        switch (mechanismName) {
            case "SCRAM-SHA-1": 
            case "SCRAM-SHA-1-PLUS": 
            case "SCRAM-SHA-256": 
            case "SCRAM-SHA-256-PLUS": 
            case "SCRAM-SHA-512": 
            case "SCRAM-SHA-512-PLUS": {
                return ScramCallbackHandler.class.getName();
            }
            case "XTOKEN-HMAC-SHA-256": {
                return XTokenCallbackHandler.class.getName();
            }
        }
        return null;
    }
}

