/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.TestLogger;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.conf.LoggingBean;
import tigase.db.TigaseDBException;
import tigase.db.comp.RepositoryItem;
import tigase.db.xml.XMLRepository;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.dns.DNSEntry;
import tigase.util.dns.DNSResolverDefault;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.dns.DNSResolverIfc;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemDefaults;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.VHostJDBCRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

public class VHostJDBCRepositoryTest {
    static final String mainVHost = "domain.com";
    static final String defaultConfigDomainName = "default";
    protected static Kernel kernel;
    static Logger log;
    static XMLRepository repository;
    static TestVHostJDBCRepository vHostJDBCRepository;

    @AfterClass
    public static void resetDNSResolver() {
        DNSResolverFactory.setDnsResolverClassName((String)DNSResolverDefault.class.getCanonicalName());
    }

    @BeforeClass
    public static void setup() {
        DNSResolverFactory.setDnsResolverClassName((String)PassThroughDNSResolver.class.getName());
        log = TestLogger.getLogger(VHostJDBCRepositoryTest.class);
        TestLogger.configureLogger(log, Level.OFF);
        TestLogger.configureLogger(Logger.getLogger("tigase"), Level.OFF);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "VHost");
        props.put("default-virtual-host", mainVHost);
        kernel = new Kernel();
        kernel.setName("VHost");
        kernel.setForceAllowNull(true);
        kernel.registerBean(DefaultTypesConverter.class).exec();
        kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        DSLBeanConfiguratorWithBackwardCompatibility config = (DSLBeanConfiguratorWithBackwardCompatibility)kernel.getInstance(DSLBeanConfiguratorWithBackwardCompatibility.class);
        config.setProperties(props);
        kernel.registerBean("vHostJDBCRepository").asClass(TestVHostJDBCRepository.class).exportable().setActive(true).exec();
        kernel.registerBean(VHostItemExtensionManager.class).exportable().setActive(true).exec();
        kernel.registerBean(VHostItemDefaults.class).exportable().setActive(true).exec();
        kernel.registerBean("repo").asClass(XMLRepository.class).exportable().setActive(true).exec();
        kernel.registerBean("logging").asClass(LoggingBean.class).setActive(true).setPinned(true).exec();
        try {
            VHostItemExtensionManager extensionManager = (VHostItemExtensionManager)kernel.getInstance(VHostItemExtensionManager.class);
            extensionManager.setProviders(new VHostItemExtensionProvider[]{new TestVHostExtensionProvider()});
            repository = (XMLRepository)kernel.getInstance(XMLRepository.class);
            repository.initRepository("memory://", new ConcurrentHashMap());
            vHostJDBCRepository = (TestVHostJDBCRepository)((Object)kernel.getInstance(TestVHostJDBCRepository.class));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex, () -> "There was an error setting up test");
        }
    }

    @After
    public void cleanup() {
        vHostJDBCRepository.removeItem(defaultConfigDomainName);
    }

    @Before
    public void setupDefault() {
        VHostItem instance = vHostJDBCRepository.getItemInstance();
        instance.setKey(defaultConfigDomainName);
        vHostJDBCRepository.addItem((RepositoryItem)instance);
    }

    @Test
    public void testDomainNameCases() throws TigaseStringprepException {
        String domain = UUID.randomUUID().toString();
        VHostItemImpl vHostItem = new VHostItemImpl(domain);
        vHostJDBCRepository.addItem((RepositoryItem)vHostItem);
        Assert.assertEquals((Object)vHostItem, (Object)vHostJDBCRepository.getItem(domain.toUpperCase()));
    }

    @Test
    public void testMinimalItemFromCommand() throws TigaseDBException, TigaseStringprepException {
        String domain = UUID.randomUUID().toString();
        Element x = Command.createIqCommand((JID)JID.jidInstanceNS((String)"test@domain.com"), null, (StanzaType)StanzaType.set, (String)UUID.randomUUID().toString(), (String)"x", (Command.DataType)Command.DataType.submit);
        Packet packet = Packet.packetInstance((Element)x);
        Command.addFieldValue((Packet)packet, (String)"Domain name", (String)domain);
        Command.addCheckBoxField((Packet)packet, (String)"Enabled", (boolean)true);
        packet.initVars();
        VHostItem domainItemInstance = vHostJDBCRepository.getItemInstance();
        domainItemInstance.initFromCommand(packet);
        String validateItem = vHostJDBCRepository.validateItem(domainItemInstance);
        Assert.assertNull((Object)validateItem);
    }

    @Test
    public void testItemLoading() throws TigaseDBException, TigaseStringprepException {
        String domain = UUID.randomUUID().toString();
        VHostItem domainItemInstance = vHostJDBCRepository.getItemInstance();
        domainItemInstance.setKey(domain);
        vHostJDBCRepository.addItem((RepositoryItem)domainItemInstance);
        Optional<Element> defaultVHostElement = this.getVHostElementFromRepository(defaultConfigDomainName);
        Assert.assertTrue((boolean)defaultVHostElement.isPresent());
        Assert.assertNull((Object)defaultVHostElement.get().getChildren());
        Optional<Element> domainVHostElement = this.getVHostElementFromRepository(domain);
        Assert.assertTrue((boolean)domainVHostElement.isPresent());
        Assert.assertNull((Object)domainVHostElement.get().getChildren());
        log.fine("By default extension is enabled for both domain and as a default");
        this.verifyDomainStateInRepository(domain, true);
        this.verifyDomainStateInStore(domain, true);
        this.verifyDomainStateInRepository(defaultConfigDomainName, true);
        this.verifyDomainStateInStore(defaultConfigDomainName, true);
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("let's disable extension");
        this.setExtensionStateForDomain(domain, false);
        log.fine("extension is still enabled in 'default' it should be true here (effective value in Wrapper)");
        this.verifyDomainStateInRepository(domain, true);
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("...but in repository we store current, correct domain setting");
        this.verifyDomainStateInStore(domain, false);
        log.fine("let's disable extension for default domain");
        this.setExtensionStateForDomain(defaultConfigDomainName, false);
        log.fine("it should now be disabled everywhere");
        this.verifyDomainStateInRepository(defaultConfigDomainName, false);
        this.verifyDomainStateInStore(defaultConfigDomainName, false);
        this.verifyDomainStateInRepository(domain, false);
        this.verifyDomainStateInStore(domain, false);
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("let's enabled it again for domain");
        this.setExtensionStateForDomain(domain, true);
        log.fine("it should be enabled for domain (including repository)");
        this.verifyDomainStateInRepository(domain, true);
        this.verifyDomainStateInStore(domain, true);
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("...but still disabled for default");
        this.verifyDomainStateInRepository(defaultConfigDomainName, false);
        this.verifyDomainStateInStore(defaultConfigDomainName, false);
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
    }

    @Test
    public void testTLSSettings() throws TigaseDBException, TigaseStringprepException {
        String domain = UUID.randomUUID().toString();
        VHostItem domainItemInstance = vHostJDBCRepository.getItemInstance();
        domainItemInstance.setKey(domain);
        vHostJDBCRepository.addItem((RepositoryItem)domainItemInstance);
        Optional<Element> defaultVHostElement = this.getVHostElementFromRepository(defaultConfigDomainName);
        Assert.assertTrue((boolean)defaultVHostElement.isPresent());
        Assert.assertNull((Object)defaultVHostElement.get().getChildren());
        Optional<Element> domainVHostElement = this.getVHostElementFromRepository(domain);
        Assert.assertTrue((boolean)domainVHostElement.isPresent());
        Assert.assertNull((Object)domainVHostElement.get().getChildren());
        log.fine("By default TLS is enabled for both domain and as a default");
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(defaultConfigDomainName)).isTlsRequired());
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        this.setTLSRequiredStateForDomain(domain, false);
        log.fine("given, that TLS is still enabled in 'default' it should be true here (effective value in Wrapper)");
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("let's disable TLS for default domain");
        this.setTLSRequiredStateForDomain(defaultConfigDomainName, false);
        log.fine("it should now be disabled everywhere");
        Assert.assertFalse((boolean)((VHostItem)vHostJDBCRepository.getItem(defaultConfigDomainName)).isTlsRequired());
        Assert.assertFalse((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("let's enabled it again for domain");
        this.setTLSRequiredStateForDomain(domain, true);
        log.fine("it should be enabled for domain");
        Assert.assertTrue((boolean)((VHostItem)vHostJDBCRepository.getItem(domain)).isTlsRequired());
        log.fine("...but still disabled for default");
        Assert.assertFalse((boolean)((VHostItem)vHostJDBCRepository.getItem(defaultConfigDomainName)).isTlsRequired());
    }

    Optional<Element> getVHostElementFromRepository(String domain) throws TigaseDBException {
        Assert.assertNotNull((Object)domain);
        String items_list = repository.getData(vHostJDBCRepository.getRepoUser(), vHostJDBCRepository.getItemsListPKey());
        if (!items_list.isEmpty()) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            SimpleParser parser = SingletonFactory.getParserInstance();
            parser.parse((SimpleHandler)domHandler, items_list);
            Queue elems = domHandler.getParsedElements();
            return elems.stream().filter(element -> domain.equals(element.getAttributeStaticStr("hostname"))).findAny();
        }
        return Optional.empty();
    }

    private void verifyDomainStateInRepository(String domain, boolean state) throws TigaseDBException {
        VHostItem item = (VHostItem)vHostJDBCRepository.getItem(domain);
        TestVHostExtension extension = (TestVHostExtension)item.getExtension(TestVHostExtension.class);
        log.log(Level.FINE, "Verifying state: '" + state + "' for domain: '" + domain + "' with item: " + item + "; Testing extension: " + extension);
        Assert.assertNotNull((Object)((Object)extension));
        Assert.assertEquals((Object)state, (Object)extension.isEnabled());
        String itemString = item.toString();
        if (state) {
            Assert.assertTrue((itemString.contains("TestVHostExtension(enabled: true)") || !itemString.contains("TestVHostExtension") ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((boolean)itemString.contains("TestVHostExtension(enabled: false)"));
        }
    }

    private void verifyDomainStateInStore(String domain, boolean state) throws TigaseDBException {
        Optional<Element> domainVHostElement = this.getVHostElementFromRepository(domain);
        Assert.assertTrue((boolean)domainVHostElement.isPresent());
        Element testElementInVHost = domainVHostElement.get().getChild("test");
        log.log(Level.FINE, "Verifying in store state: " + state + " for domain: " + domain + " with element: " + domainVHostElement);
        if (state) {
            Assert.assertNull((Object)testElementInVHost);
        } else {
            Assert.assertNotNull((Object)testElementInVHost);
            Assert.assertEquals((Object)String.valueOf(state), (Object)testElementInVHost.getAttributeStaticStr("enabled"));
        }
    }

    private VHostItem setExtensionStateForDomain(String domain, boolean state) throws TigaseStringprepException {
        log.log(Level.FINE, "Setting domain: '" + domain + "' extension state to: " + state);
        Element x = Command.createIqCommand((JID)JID.jidInstanceNS((String)"test@domain.com"), null, (StanzaType)StanzaType.set, (String)UUID.randomUUID().toString(), (String)"x", (Command.DataType)Command.DataType.submit);
        Packet packet = Packet.packetInstance((Element)x);
        Command.addFieldValue((Packet)packet, (String)"Domain name", (String)domain);
        TestVHostExtension extension = new TestVHostExtension(state);
        extension.addCommandFields(extension.getId(), packet, false);
        packet.initVars();
        VHostItem vHostItem = vHostJDBCRepository.getItemInstance();
        vHostItem.initFromCommand(packet);
        vHostJDBCRepository.addItem((RepositoryItem)vHostItem);
        return vHostItem;
    }

    private VHostItem setTLSRequiredStateForDomain(String domain, boolean state) throws TigaseStringprepException {
        log.log(Level.FINE, "Setting domain: '" + domain + "' TLS-required state to: " + state);
        Element x = Command.createIqCommand((JID)JID.jidInstanceNS((String)"test@domain.com"), null, (StanzaType)StanzaType.set, (String)UUID.randomUUID().toString(), (String)"x", (Command.DataType)Command.DataType.submit);
        Packet packet = Packet.packetInstance((Element)x);
        Command.addFieldValue((Packet)packet, (String)"Domain name", (String)domain);
        Command.addCheckBoxField((Packet)packet, (String)"TLS required", (boolean)state);
        packet.initVars();
        VHostItem vHostItem = vHostJDBCRepository.getItemInstance();
        vHostItem.initFromCommand(packet);
        vHostJDBCRepository.addItem((RepositoryItem)vHostItem);
        return vHostItem;
    }

    public static class PassThroughDNSResolver
    implements DNSResolverIfc {
        public DNSEntry[] getHostSRV_Entries(String hostname) throws UnknownHostException {
            return new DNSEntry[]{new DNSEntry(hostname, hostname), new DNSEntry(VHostJDBCRepositoryTest.defaultConfigDomainName, VHostJDBCRepositoryTest.defaultConfigDomainName)};
        }

        public String getDefaultHost() {
            return VHostJDBCRepositoryTest.defaultConfigDomainName;
        }

        public String[] getHostIPs(String s) throws UnknownHostException {
            return new String[]{s, VHostJDBCRepositoryTest.defaultConfigDomainName};
        }
    }

    public static class TestVHostJDBCRepository
    extends VHostJDBCRepository {
        public void setAutoloadTimer(long delay) {
            super.setAutoloadTimer(0L);
        }

        public void setAutoReloadInterval(long autoLoadInterval) {
            super.setAutoReloadInterval(0L);
        }

        void reinitialiseRepository() {
            this.items.clear();
        }
    }

    public static class TestVHostExtensionProvider
    implements VHostItemExtensionProvider<TestVHostExtension> {
        public String getId() {
            return "test";
        }

        public Class<TestVHostExtension> getExtensionClazz() {
            return TestVHostExtension.class;
        }
    }

    public static class TestVHostExtension
    extends AbstractVHostItemExtension<TestVHostExtension> {
        public static final String ID = "test";
        private static final boolean ENABLED_DEFAULT_VAL = true;
        private boolean enabled = true;

        public TestVHostExtension() {
        }

        public TestVHostExtension(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getId() {
            return ID;
        }

        public void initFromElement(Element item) {
            String enabledAttr = item.getAttributeStaticStr("enabled");
            this.enabled = enabledAttr == null ? true : Boolean.parseBoolean(enabledAttr);
        }

        public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
            Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-enabled"))).ifPresent(s -> {
                this.enabled = Boolean.parseBoolean(s);
            });
        }

        public String toDebugString() {
            return "enabled: " + this.enabled;
        }

        public Element toElement() {
            return this.enabled ? null : new Element(ID, new String[]{"enabled"}, new String[]{String.valueOf(this.enabled)});
        }

        public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
            Element commandEl = packet.getElemChild("command", "http://jabber.org/protocol/commands");
            DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-enabled"), (String)String.valueOf(this.enabled), (String)"boolean", (String)"Extension Enabled");
        }

        public TestVHostExtension mergeWithDefaults(TestVHostExtension defaults) {
            return new TestVHostExtension(this.enabled || defaults.enabled);
        }
    }
}

