/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.junit.Assert;
import org.junit.Test;
import tigase.cluster.repo.ClConConfigRepository;
import tigase.cluster.repo.ClConDirRepository;
import tigase.cluster.repo.ClConSQLRepository;
import tigase.cluster.repo.ClusterRepoItem;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.RepositoryItem;
import tigase.util.reflection.ReflectionHelper;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostJDBCRepository;

public class ReflectionHelperTest {
    @Test
    public void testClassMatchesType() throws NoSuchFieldException {
        Field f = null;
        Type type = null;
        f = Test1.class.getDeclaredField("repo1");
        type = f.getGenericType();
        Assert.assertTrue((boolean)ReflectionHelper.classMatchesType(ClConSQLRepository.class, (Type)type));
        Assert.assertTrue((boolean)ReflectionHelper.classMatchesType(ClConConfigRepository.class, (Type)type));
        Assert.assertTrue((boolean)ReflectionHelper.classMatchesType(ClConDirRepository.class, (Type)type));
        Assert.assertFalse((boolean)ReflectionHelper.classMatchesType(VHostJDBCRepository.class, (Type)type));
        f = Test1.class.getDeclaredField("repo2");
        type = f.getGenericType();
        Assert.assertFalse((boolean)ReflectionHelper.classMatchesType(ClConSQLRepository.class, (Type)type));
        Assert.assertFalse((boolean)ReflectionHelper.classMatchesType(ClConConfigRepository.class, (Type)type));
        Assert.assertFalse((boolean)ReflectionHelper.classMatchesType(ClConDirRepository.class, (Type)type));
        Assert.assertTrue((boolean)ReflectionHelper.classMatchesType(VHostJDBCRepository.class, (Type)type));
    }

    @Test
    public void testClassMatchesClassWithParameters() {
        Assert.assertTrue((boolean)ReflectionHelper.classMatchesClassWithParameters(ClConSQLRepository.class, ComponentRepository.class, (Type[])new Type[]{ClusterRepoItem.class}));
        Assert.assertFalse((boolean)ReflectionHelper.classMatchesClassWithParameters(ClConSQLRepository.class, ComponentRepository.class, (Type[])new Type[]{VHostItem.class}));
        Assert.assertTrue((boolean)ReflectionHelper.classMatchesClassWithParameters(ClConSQLRepository.class, ComponentRepository.class, (Type[])new Type[]{RepositoryItem.class}));
    }

    private class Test1 {
        private ComponentRepository<ClusterRepoItem> repo1;
        private ComponentRepository<VHostItem> repo2;

        private Test1() {
        }
    }
}

