/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import tigase.TestLogger;
import tigase.cert.CertCheckResult;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.conf.LoggingBean;
import tigase.eventbus.EventBusFactory;
import tigase.io.CertificateContainer;
import tigase.io.SSLContextContainer;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnection;
import tigase.server.xmppserver.S2SConnectionHandlerIfc;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SConnectionSelector;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SRandomSelector;
import tigase.server.xmppserver.SSLTestAbstract;
import tigase.server.xmppserver.proc.AuthenticatorSelectorManager;
import tigase.server.xmppserver.proc.Dialback;
import tigase.server.xmppserver.proc.StartTLS;
import tigase.util.dns.DNSEntry;
import tigase.util.dns.DNSResolverFactory;
import tigase.vhosts.DummyVHostManager;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;

public class S2SConnManAbstractTest
extends SSLTestAbstract {
    protected static Kernel kernel;
    private static CID cid;
    private static S2SConnectionHandlerImpl handler;

    private static void dumpConfiguration(DSLBeanConfiguratorWithBackwardCompatibility config) throws IOException {
        StringWriter stringWriter = new StringWriter();
        config.dumpConfiguration((Writer)stringWriter);
        System.out.println("Configuration dump:" + stringWriter.toString());
    }

    private static DSLBeanConfiguratorWithBackwardCompatibility prepareKernel() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "s2s");
        kernel = new Kernel();
        kernel.setName("s2s");
        kernel.setForceAllowNull(true);
        kernel.registerBean(DefaultTypesConverter.class).exec();
        kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        DSLBeanConfiguratorWithBackwardCompatibility config = (DSLBeanConfiguratorWithBackwardCompatibility)kernel.getInstance(DSLBeanConfiguratorWithBackwardCompatibility.class);
        config.setProperties(props);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean(ConnectionManager.PortsConfigBean.class).exec();
        kernel.registerBean(CIDConnections.CIDConnectionsOpenerService.class).exportable().exec();
        kernel.registerBean(S2SRandomSelector.class).exportable().exec();
        kernel.registerBean(CertificateContainer.class).exportable().exec();
        kernel.registerBean(StartTLS.class).exportable().exec();
        kernel.registerBean(DummyDialbackImpl.class).exportable().setActive(true).exec();
        kernel.registerBean(AuthenticatorSelectorManager.class).exportable().setActive(true).exec();
        kernel.registerBean("vHostManager").asClass(DummyVHostManager.class).exportable().setActive(true).exec();
        kernel.registerBean(SSLContextContainer.class).exportable().setActive(true).exec();
        kernel.registerBean("service").asClass(S2SConnectionHandlerImpl.class).setActive(true).exec();
        kernel.registerBean("logging").asClass(LoggingBean.class).setActive(true).setPinned(true).exec();
        return config;
    }

    @BeforeClass
    public static void setup() {
        S2SConnManAbstractTest.getSslDebugString().ifPresent(debug -> System.setProperty("javax.net.debug", debug));
        log = Logger.getLogger("tigase");
        TestLogger.configureLogger(log, Level.CONFIG);
        DSLBeanConfiguratorWithBackwardCompatibility config = S2SConnManAbstractTest.prepareKernel();
        try {
            SSLContextContainer context = (SSLContextContainer)kernel.getInstance(SSLContextContainer.class);
            LoggingBean loggingBean = (LoggingBean)kernel.getInstance(LoggingBean.class);
            loggingBean.setPacketFullDebug(true);
            AuthenticatorSelectorManager instance = (AuthenticatorSelectorManager)kernel.getInstance(AuthenticatorSelectorManager.class);
            System.out.println(instance);
            handler = (S2SConnectionHandlerImpl)((Object)kernel.getInstance(S2SConnectionHandlerImpl.class));
            handler.start();
            S2SConnManAbstractTest.dumpConfiguration(config);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex, () -> "There was an error setting up test");
        }
        TestLogger.configureLogger(log, Level.ALL);
    }

    protected static void setupCID(String localHostname, String remoteHostname) {
        cid = new CID(localHostname, remoteHostname);
        DummyVHostManager instance = (DummyVHostManager)kernel.getInstance(VHostManagerIfc.class);
        if (instance.getVHostItem(localHostname) == null) {
            instance.addVhost(localHostname);
        }
        try {
            SSLContextContainer sSLContextContainer = (SSLContextContainer)kernel.getInstance(SSLContextContainer.class);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex, () -> "There was an error setting up test");
        }
    }

    private static void setupSslContextContainer(SSLContextContainer context, String localDomain, SSLContextContainer.HARDENED_MODE mode, String[] protocols, String[] ciphers) {
        if (mode != null) {
            context.setHardenedMode(mode);
        }
        context.setEnabledProtocols(protocols);
        context.setEnabledCiphers(ciphers);
        context.getSSLContext("TLS", localDomain, false, null);
    }

    protected void testS2STigaseConnectionManager(String localDomain, String[] protocols) {
        this.testS2STigaseConnectionManager(localDomain, protocols, certCheckResult -> Assert.assertEquals((Object)CertCheckResult.trusted, (Object)certCheckResult), Assert::assertTrue);
    }

    protected void testS2STigaseConnectionManager(String localDomain, String[] protocols, S2SConnectionHandlerImpl.IPFamily ipFamily) {
        this.testS2STigaseConnectionManager(localDomain, protocols, ipFamily, certCheckResult -> Assert.assertEquals((Object)CertCheckResult.trusted, (Object)certCheckResult), Assert::assertTrue);
    }

    protected void testS2STigaseConnectionManager(String localDomain, String[] protocols, Consumer<CertCheckResult> certificateCheckResult, Consumer<Boolean> authenticatedConsumer) {
        this.testS2STigaseConnectionManager(localDomain, protocols, S2SConnectionHandlerImpl.IPFamily.ANY, certificateCheckResult, authenticatedConsumer);
    }

    protected void testS2STigaseConnectionManager(String localDomain, String[] protocols, S2SConnectionHandlerImpl.IPFamily ipFamily, Consumer<CertCheckResult> certificateCheckResult, Consumer<Boolean> authenticatedConsumer) {
        try {
            handler.setIpFamily(ipFamily);
            SSLContextContainer context = (SSLContextContainer)kernel.getInstance(SSLContextContainer.class);
            S2SConnManAbstractTest.setupSslContextContainer(context, localDomain, SSLContextContainer.HARDENED_MODE.secure, protocols, null);
            this.testConnectionForCID(cid, certificateCheckResult, authenticatedConsumer);
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error running test", e);
            Assert.fail((String)("exception: " + e));
        }
    }

    private void testConnectionForCID(CID cid, Consumer<CertCheckResult> certificateCheckResult, Consumer<Boolean> authenticatedConsumer) throws NotLocalhostException, LocalhostException, InterruptedException {
        fastCIDConnections connections = handler.createNewCIDConnections(cid);
        connections.openConnections();
        try {
            Packet packet = Iq.packetInstance((String)("iq_version_query_test" + UUID.randomUUID()), (String)cid.getLocalHost(), (String)cid.getRemoteHost(), (StanzaType)StanzaType.get);
            Element iqElement = packet.getElement();
            iqElement.setAttribute("id", UUID.randomUUID().toString());
            Element query = new Element("query");
            query.setXMLNS("jabber:iq:version");
            iqElement.addChild((XMLNodeIfc)query);
            handler.addPacket(packet);
        }
        catch (Exception packet) {
            // empty catch block
        }
        S2SIOService s2SIOService = null;
        int delayRetryLimit = 100;
        boolean connected = false;
        boolean authenticated = false;
        boolean completed = false;
        CertCheckResult trusted = CertCheckResult.none;
        boolean dialbackCompleted = false;
        do {
            TimeUnit.MILLISECONDS.sleep(100L);
            if (dialbackCompleted) break;
            s2SIOService = connections.getS2SIOService();
            if (s2SIOService == null) continue;
            connected = s2SIOService.isConnected();
            authenticated = s2SIOService.isAuthenticated();
            completed = s2SIOService.isStreamNegotiationCompleted();
            trusted = (CertCheckResult)s2SIOService.getSessionData().get("cert-check-result");
            dialbackCompleted = "completed".equals(s2SIOService.getSessionData().get("dialback"));
        } while ((s2SIOService == null || !connected || !authenticated || !completed || !CertCheckResult.trusted.equals((Object)trusted)) && delayRetryLimit-- > 0);
        log.log(Level.INFO, cid + ": isConnected(): " + connected);
        log.log(Level.INFO, cid + ": isAuthenticated(): " + authenticated);
        log.log(Level.INFO, cid + ": isStreamNegotiationCompleted(): " + completed);
        log.log(Level.INFO, cid + ": getSessionData().get(CERT_CHECK_RESULT): " + trusted);
        Assert.assertNotNull((String)"TLS handshake not completed", s2SIOService.getSessionData().get("tlsHandshakeCompleted"));
        if (s2SIOService.isConnected()) {
            String value = (String)s2SIOService.getSessionData().get("dialback");
            if (value != null) {
                Assert.assertTrue(("completed".equals(value) || "started".equals(value) ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotEquals((String)"Dialback still not completed", (Object)"started", s2SIOService.getSessionData().get("dialback"));
        }
        if (s2SIOService.isConnected()) {
            TimeUnit.SECONDS.sleep(5L);
        }
        handler.serviceStopped(s2SIOService);
    }

    static {
        handler = null;
    }

    public static class DummyDialbackImpl
    extends Dialback {
        protected void initDialback(S2SIOService serv, String remote_id) {
            super.initDialback(serv, remote_id);
            serv.getSessionData().put("dialback", "started");
        }

        public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
            if (p.getElemName() == "result" || p.getElemName() == "db:result") {
                serv.getSessionData().put("dialback", "completed");
            }
            return super.process(p, serv, results);
        }
    }

    public static class S2SConnectionHandlerImpl
    extends S2SConnectionManager {
        private IPFamily ipFamily = IPFamily.ANY;

        public S2SConnectionHandlerImpl() {
            this.connectionDelay = 0L;
        }

        public IPFamily getIpFamily() {
            return this.ipFamily;
        }

        public void setIpFamily(IPFamily ipFamily) {
            this.ipFamily = ipFamily;
        }

        public HashSet<Integer> getDefPorts() {
            return new HashSet<Integer>();
        }

        public fastCIDConnections createNewCIDConnections(CID cid) throws NotLocalhostException, LocalhostException {
            fastCIDConnections conns = new fastCIDConnections(cid, (S2SConnectionHandlerIfc<S2SIOService>)this);
            this.cidConnections.put(cid, conns);
            return conns;
        }

        public Queue<Packet> processSocketData(S2SIOService serv) {
            Queue receivedPackets = serv.getReceivedPackets();
            if (receivedPackets != null) {
                receivedPackets.forEach(x -> SSLTestAbstract.log.log(Level.INFO, "Received packet: " + x));
            }
            return super.processSocketData(serv);
        }

        protected void addWaitingTask(Map<String, Object> conn) {
            this.reconnectService(conn, this.connectionDelay);
        }

        private void reconnectService(Map<String, Object> port_props, long delay) {
            String host;
            if (SSLTestAbstract.log.isLoggable(Level.FINER)) {
                String cid = port_props.get("local-hostname") + "@" + port_props.get("remote-hostname");
                SSLTestAbstract.log.log(Level.FINER, "Reconnecting service for: {0}, scheduling next try in {1} seconds, cid: {2}, props: {3}", new Object[]{this.getName(), delay / 1000L, cid, port_props});
            }
            if ((host = (String)port_props.get("remote-host")) == null) {
                host = (String)port_props.get("remote-hostname");
            }
            int port = (Integer)port_props.get("port-no");
            if (SSLTestAbstract.log.isLoggable(Level.FINE)) {
                SSLTestAbstract.log.log(Level.FINE, "Reconnecting service for component: {0}, to remote host: {1} on port: {2,number,#}", new Object[]{this.getName(), host, port});
            }
            this.startService(port_props);
        }

        public void tlsHandshakeCompleted(S2SIOService serv) {
            super.tlsHandshakeCompleted(serv);
            serv.getSessionData().put("tlsHandshakeCompleted", "true");
        }

        public void xmppStreamClosed(S2SIOService serv) {
            if ("started".equals(serv.getSessionData().get("dialback"))) {
                serv.getSessionData().put("dialback", "stream-closed");
            }
            super.xmppStreamClosed(serv);
        }

        public static enum IPFamily {
            ANY,
            IPv6,
            IPv4;

        }
    }

    private static class fastCIDConnections
    extends CIDConnections {
        private final CID cid;
        S2SConnection s2s_conn = null;

        public fastCIDConnections(CID cid, S2SConnectionHandlerIfc<S2SIOService> handler) {
            super(cid, handler, (S2SConnectionSelector)new S2SRandomSelector(), 1, 1, 1, 0L);
            this.cid = cid;
        }

        public void connectionAuthenticated(S2SIOService serv, CID cid) {
            super.connectionAuthenticated(serv, cid);
        }

        public S2SIOService getS2SIOService() {
            return this.s2s_conn.getS2SIOService();
        }

        protected boolean hasExceededMaxWaitingTime() {
            return false;
        }

        public void openConnections() {
            try {
                if (SSLTestAbstract.log.isLoggable(Level.FINEST)) {
                    SSLTestAbstract.log.log(Level.FINEST, "Checking DNS for host: {0} for: {1}", new Object[]{this.cid.getRemoteHost(), this.cid});
                }
                String serverName = this.cid.getRemoteHost();
                DNSEntry[] dns_entries = DNSResolverFactory.getInstance().getHostSRV_Entries(serverName);
                DNSEntry dns_entry = this.selectDnsEntry(dns_entries).orElseThrow(() -> new NoValidDnsEntry());
                String ip = dns_entry.getIp();
                this.s2s_conn = new S2SConnection((S2SConnectionHandlerIfc)handler, ip);
                TreeMap<String, String> port_props = new TreeMap<String, String>();
                port_props.put("cert-required-domain", serverName);
                this.initNewConnection(ip, dns_entry.getPort(), this.s2s_conn, port_props);
            }
            catch (NoValidDnsEntry ex) {
                SSLTestAbstract.log.log(Level.FINE, "No valid DNS entries found: " + this.cid.getRemoteHost() + ", for: " + this.cid + ", ipFamily: " + handler.getIpFamily());
            }
            catch (UnknownHostException ex) {
                SSLTestAbstract.log.log(Level.FINE, "Remote host not found: " + this.cid.getRemoteHost() + ", for: " + this.cid, ex);
                Assert.fail((String)("Remote host not found: " + this.cid.getRemoteHost() + ", for: " + this.cid));
            }
        }

        protected Optional<DNSEntry> selectDnsEntry(DNSEntry[] dns_entries) {
            if (dns_entries == null) {
                return Optional.empty();
            }
            Predicate<String> ipPredicate = switch (handler.getIpFamily()) {
                default -> throw new IncompatibleClassChangeError();
                case S2SConnectionHandlerImpl.IPFamily.ANY -> ip -> true;
                case S2SConnectionHandlerImpl.IPFamily.IPv4 -> ip -> ip.contains(".");
                case S2SConnectionHandlerImpl.IPFamily.IPv6 -> ip -> !ip.contains(".");
            };
            return Arrays.stream(dns_entries).map(e -> {
                String[] ips = (String[])Arrays.stream(e.getIps()).filter(ipPredicate).toArray(String[]::new);
                if (ips.length == 0) {
                    return null;
                }
                return new DNSEntry(e.getHostname(), e.getDnsResultHost(), ips, e.getPort(), e.getTtl(), e.getPriority(), e.getWeight());
            }).filter(Objects::nonNull).findFirst();
        }

        protected class NoValidDnsEntry
        extends Exception {
            protected NoValidDnsEntry() {
            }
        }
    }
}

