/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import tigase.server.websocket.WebSocketHixie76;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;

public class WebSocketHixie76Test
extends TestCase {
    private WebSocketHixie76 impl;

    @Test
    public void testFrameEncodingDecoding() throws IOException {
        String input = "<test-data><subdata/></test-data>";
        ByteBuffer buf = ByteBuffer.wrap(input.getBytes());
        final ByteBuffer tmp = ByteBuffer.allocate(1024);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHixie76()}){

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }
        };
        this.impl.encodeFrameAndWrite((WebSocketXMPPIOService)io, buf);
        tmp.flip();
        ByteBuffer decoded = this.impl.decodeFrame((WebSocketXMPPIOService)io, tmp);
        Assert.assertArrayEquals((String)"Data before encoding do not match data after decoding", (byte[])input.getBytes(), (byte[])decoded.array());
    }

    @Test
    public void testHandshakeOK() throws NoSuchAlgorithmException, IOException {
        final ByteBuffer tmp = ByteBuffer.allocate(2048);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHixie76()}){

            public int getLocalPort() {
                return 80;
            }

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sec-WebSocket-Key1".toUpperCase(), "1C2J899_05  6  !  M 9    ^4");
        params.put("Sec-WebSocket-Key2".toUpperCase(), "23 2ff0M_E0#.454X23");
        params.put("Sec-WebSocket-Protocol".toUpperCase(), "xmpp");
        byte[] bytes = new byte[10];
        bytes[0] = 13;
        bytes[1] = 10;
        Assert.assertTrue((String)"Handshake failed", (boolean)this.impl.handshake((WebSocketXMPPIOService)io, params, bytes));
    }

    @Test
    public void testHandshakeFail() throws NoSuchAlgorithmException, IOException {
        final ByteBuffer tmp = ByteBuffer.allocate(2048);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHixie76()}){

            public int getLocalPort() {
                return 80;
            }

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sec-WebSocket-Version".toUpperCase(), "13");
        params.put("Sec-WebSocket-Protocol".toUpperCase(), "xmpp");
        byte[] bytes = new byte[10];
        bytes[0] = 13;
        bytes[1] = 10;
        Assert.assertFalse((String)"Handshake succeeded", (boolean)this.impl.handshake((WebSocketXMPPIOService)io, params, bytes));
    }

    protected void setUp() throws Exception {
        this.impl = new WebSocketHixie76();
    }

    protected void tearDown() throws Exception {
        this.impl = null;
    }
}

