/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.db;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.db.DataSource;
import tigase.db.MsgRepositoryIfc;
import tigase.db.TigaseDBException;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.AbstractProcessorWithDataSourceAwareTestCase;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractMsgRepositoryTest<DS extends DataSource, T>
extends AbstractProcessorWithDataSourceAwareTestCase<DS, MsgRepository> {
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    protected boolean checkEmoji = true;
    private JID recipient;
    private XMPPResourceConnection recipientSession;
    private JID sender;

    @Before
    public void setup() throws Exception {
        this.sender = JID.jidInstance((String)("sender-" + UUID.randomUUID()), (String)"example.com", (String)"resource-1");
        this.getUserRepository().addUser(this.sender.getBareJID());
        this.recipient = JID.jidInstance((String)("recipient-" + UUID.randomUUID()), (String)"example.com", (String)"resource-1");
        this.getUserRepository().addUser(this.recipient.getBareJID());
        this.recipientSession = this.getSession(this.recipient, this.recipient);
    }

    @Test
    public void testStorageOfOfflineMessage() throws TigaseDBException, NotAuthorizedException, TigaseStringprepException {
        Element el2;
        Element el1;
        ArrayList<Packet> messages = new ArrayList<Packet>();
        for (int i = 0; i < 5; ++i) {
            Packet message = Message.getMessage((JID)this.sender, (JID)this.recipient, (StanzaType)StanzaType.chat, (String)this.generateRandomBody(), null, null, (String)UUID.randomUUID().toString());
            Assert.assertTrue((boolean)((MsgRepository)this.repo).storeMessage(this.sender, this.recipient, null, message.getElement(), null));
            messages.add(message);
        }
        Map count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
        Assert.assertEquals((long)1L, (long)count.size());
        Assert.assertNotNull(count.get(MsgRepository.MSG_TYPES.message));
        Assert.assertEquals((long)5L, (long)((Long)count.get(MsgRepository.MSG_TYPES.message)));
        List list = ((MsgRepository)this.repo).getMessagesList(this.recipient);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)5L, (long)list.size());
        for (Element item2 : list) {
            Assert.assertEquals((Object)this.recipient.getBareJID().toString(), (Object)item2.getAttributeStaticStr("jid"));
            Assert.assertNotNull((Object)item2.getAttributeStaticStr("node"));
            Assert.assertEquals((Object)"message", (Object)item2.getAttributeStaticStr("type"));
            Assert.assertEquals((Object)this.sender.getBareJID().toString(), (Object)item2.getAttributeStaticStr("name"));
        }
        List msgIds = list.stream().map(item -> item.getAttributeStaticStr("node")).collect(Collectors.toList());
        Queue loaded = ((MsgRepository)this.repo).loadMessagesToJID(this.recipientSession, false);
        for (Packet message : messages) {
            el1 = message.getElement();
            el2 = (Element)loaded.poll();
            Assert.assertNotNull((Object)el2);
            Assert.assertEquals((Object)el1.getAttributeStaticStr("id"), (Object)el2.getAttributeStaticStr("id"));
            Assert.assertEquals((Object)el1.getChildStaticStr("body"), (Object)el2.getChildStaticStr("body"));
        }
        loaded = ((MsgRepository)this.repo).loadMessagesToJID(msgIds.subList(0, 3), this.recipientSession, false, null);
        for (Packet message : messages.subList(0, 3)) {
            el1 = message.getElement();
            el2 = (Element)loaded.poll();
            Assert.assertNotNull((Object)el2);
            Assert.assertEquals((Object)el1.getAttributeStaticStr("id"), (Object)el2.getAttributeStaticStr("id"));
            Assert.assertEquals((Object)el1.getChildStaticStr("body"), (Object)el2.getChildStaticStr("body"));
        }
        ((MsgRepository)this.repo).deleteMessage(this.getMsgId((String)msgIds.remove(0)));
        loaded = ((MsgRepository)this.repo).loadMessagesToJID(msgIds.subList(0, 3), this.recipientSession, false, null);
        for (Packet message : messages.subList(1, 4)) {
            el1 = message.getElement();
            el2 = (Element)loaded.poll();
            Assert.assertNotNull((Object)el2);
            Assert.assertEquals((Object)el1.getAttributeStaticStr("id"), (Object)el2.getAttributeStaticStr("id"));
            Assert.assertEquals((Object)el1.getChildStaticStr("body"), (Object)el2.getChildStaticStr("body"));
        }
        count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
        Assert.assertEquals((long)1L, (long)count.size());
        Assert.assertNotNull(count.get(MsgRepository.MSG_TYPES.message));
        Assert.assertEquals((long)4L, (long)((Long)count.get(MsgRepository.MSG_TYPES.message)));
        ((MsgRepository)this.repo).loadMessagesToJID(this.recipientSession, true);
        count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
        Assert.assertEquals((long)0L, (long)count.size());
    }

    @Test
    public void testStorageOfOfflineMessageWithExpiration1() throws TigaseDBException, NotAuthorizedException, TigaseStringprepException {
        try {
            Date expire = new Date(System.currentTimeMillis() - 60000L);
            ArrayList<Packet> messages = new ArrayList<Packet>();
            for (int i = 0; i < 5; ++i) {
                Packet message = Message.getMessage((JID)this.sender, (JID)this.recipient, (StanzaType)StanzaType.chat, (String)this.generateRandomBody(), null, null, (String)UUID.randomUUID().toString());
                Assert.assertTrue((boolean)((MsgRepository)this.repo).storeMessage(this.sender, this.recipient, expire, message.getElement(), null));
                messages.add(message);
            }
            Map count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
            Assert.assertEquals((long)1L, (long)count.size());
            Assert.assertNotNull(count.get(MsgRepository.MSG_TYPES.message));
            Assert.assertEquals((long)5L, (long)((Long)count.get(MsgRepository.MSG_TYPES.message)));
            Element elem = ((MsgRepository)this.repo).getMessageExpired(System.currentTimeMillis(), true);
            Assert.assertNotNull((Object)elem);
            count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
            Assert.assertEquals((long)1L, (long)count.size());
            Assert.assertNotNull(count.get(MsgRepository.MSG_TYPES.message));
            Assert.assertEquals((long)4L, (long)((Long)count.get(MsgRepository.MSG_TYPES.message)));
            ((MsgRepository)this.repo).expiredQueue.clear();
            ((MsgRepository)this.repo).earliestOffline = Long.MAX_VALUE;
            elem = ((MsgRepository)this.repo).getMessageExpired(System.currentTimeMillis(), true);
            Assert.assertNotNull((Object)elem);
            count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
            Assert.assertEquals((long)1L, (long)count.size());
            Assert.assertNotNull(count.get(MsgRepository.MSG_TYPES.message));
            Assert.assertEquals((long)3L, (long)((Long)count.get(MsgRepository.MSG_TYPES.message)));
            ((MsgRepository)this.repo).earliestOffline = Long.MAX_VALUE;
            elem = ((MsgRepository)this.repo).getMessageExpired(System.currentTimeMillis(), true);
            Assert.assertNotNull((Object)elem);
            count = ((MsgRepository)this.repo).getMessagesCount(this.recipient);
            Assert.assertEquals((long)1L, (long)count.size());
            Assert.assertNotNull(count.get(MsgRepository.MSG_TYPES.message));
            Assert.assertEquals((long)2L, (long)((Long)count.get(MsgRepository.MSG_TYPES.message)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected abstract <T> T getMsgId(String var1);

    @Override
    protected Class getDataSourceAwareIfc() {
        return MsgRepositoryIfc.class;
    }

    @Override
    protected MsgRepository prepareDataSourceAware() throws Exception {
        MsgRepository repository = (MsgRepository)super.prepareDataSourceAware();
        ReentrantLock lock = new ReentrantLock();
        repository.setCondition(lock, lock.newCondition());
        return repository;
    }

    protected String generateRandomBody() {
        String body = "Body " + UUID.randomUUID().toString();
        if (this.checkEmoji) {
            body = body + emoji;
        }
        return body;
    }
}

