/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import tigase.auth.BruteForceLockerBean;
import tigase.eventbus.impl.Event1;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class EventBusSerializerTest {
    @Test
    public void testDeserialize() {
        EventBusSerializer serializer = new EventBusSerializer();
        Event1 eo = new Event1();
        eo.setJid(JID.jidInstanceNS((String)"a@b.c/d"));
        eo.setTransientField("123");
        eo.setV1("message");
        eo.setV2(9898);
        eo.setElementField(new Element("x", "v", new String[]{"a"}, new String[]{"b"}));
        eo.setStrArrField(new String[]{"ala", "m,a", "kota"});
        eo.setSetField(new HashSet<String>(Arrays.asList("test123")));
        Element ex = serializer.serialize((Object)eo);
        Event1 ed = (Event1)serializer.deserialize(ex);
        Assert.assertNotNull((Object)ed);
        Assert.assertNotSame((Object)eo, (Object)ed);
        Assert.assertEquals((Object)JID.jidInstanceNS((String)"a@b.c/d"), (Object)ed.getJid());
        Assert.assertNull((Object)ed.getTransientField());
        Assert.assertEquals((Object)"message", (Object)ed.getV1());
        Assert.assertEquals((long)9898L, (long)ed.getV2());
        Assert.assertEquals((Object)new Element("x", "v", new String[]{"a"}, new String[]{"b"}), (Object)ed.getElementField());
        Assert.assertArrayEquals((Object[])new String[]{"ala", "m,a", "kota"}, (Object[])ed.getStrArrField());
        Assert.assertTrue((boolean)eo.getSetField().contains("test123"));
    }

    @Test
    public void testSerialize() {
        EventBusSerializer serializer = new EventBusSerializer();
        Event1 eo = new Event1();
        eo.setJid(JID.jidInstanceNS((String)"a@b.c/d"));
        eo.setTransientField("123");
        eo.setV1("message");
        eo.setV2(9898);
        eo.setElementField(new Element("x", "v", new String[]{"a"}, new String[]{"b"}));
        eo.setStrArrField(new String[]{"ala", "m,a", "kota"});
        Element ex = serializer.serialize((Object)eo);
        Assert.assertEquals((long)5L, (long)ex.getChildren().size());
        Assert.assertEquals((Object)"event", (Object)ex.getName());
        Assert.assertEquals((Object)"tigase.eventbus.impl.Event1", (Object)ex.getAttributeStaticStr("class"));
        Assert.assertEquals((Object)"a@b.c/d", (Object)ex.getCData(new String[]{"event", "jid"}));
        Assert.assertNull((Object)ex.getCData(new String[]{"event", "transientField"}));
        Assert.assertEquals((Object)"message", (Object)ex.getCData(new String[]{"event", "v1"}));
        Assert.assertEquals((Object)"9898", (Object)ex.getCData(new String[]{"event", "v2"}));
        Assert.assertEquals((Object)"v", (Object)ex.getCData(new String[]{"event", "elementField", "x"}));
        Assert.assertNotEquals((Object)"ala,m,a,kota", (Object)ex.getCData(new String[]{"event", "strArrField"}));
    }

    @Test
    public void testSerializeXmlValidity() throws TigaseStringprepException {
        EventBusSerializer serializer = new EventBusSerializer();
        BruteForceLockerBean.StatHolder statHolder = new BruteForceLockerBean.StatHolder();
        statHolder.addIP("192.168.0.1");
        statHolder.addIP("::1");
        statHolder.addJID(BareJID.bareJIDInstance((String)"test@zeus"));
        BruteForceLockerBean.StatisticsEmitEvent eo = new BruteForceLockerBean.StatisticsEmitEvent("test", statHolder);
        String xmlString = serializer.serialize((Object)eo).toString();
        SimpleParser parser = SingletonFactory.getParserInstance();
        TestDomBuilderHandler domHandler = new TestDomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, xmlString.toCharArray(), 0, xmlString.length());
        Assert.assertFalse((boolean)domHandler.isError());
        Element ex = (Element)domHandler.getParsedElements().poll();
        BruteForceLockerBean.StatisticsEmitEvent eor = (BruteForceLockerBean.StatisticsEmitEvent)serializer.deserialize(ex);
        Assert.assertNotNull((Object)eor);
        String xmlString2 = serializer.serialize((Object)eor).toString();
        Assert.assertEquals((Object)xmlString, (Object)xmlString2);
    }

    private static class TestDomBuilderHandler
    extends DomBuilderHandler {
        private boolean error = false;

        private TestDomBuilderHandler() {
        }

        public void error(String errorMessage) {
            super.error(errorMessage);
            this.error = true;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

