/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import junit.framework.TestCase;
import org.junit.Assert;
import tigase.auth.mechanisms.SCRAMHelper;
import tigase.util.Base64;

public class SCRAMHelperTest
extends TestCase {
    public void testEncodePlainPassword() throws NoSuchAlgorithmException, InvalidKeyException {
        SCRAMHelper.AuthenticationData authData = SCRAMHelper.encodePlainPassword((String)"SHA1", (byte[])Base64.decode((String)"QSXCR+Q6sek8bf92"), (int)4096, (String)"pencil");
        Assert.assertArrayEquals((byte[])Base64.decode((String)"D+CSWLOshSulAsxiupA+qs2/fTE="), (byte[])authData.serverKey());
        Assert.assertArrayEquals((byte[])Base64.decode((String)"6dlGYMOdZcOPutkcNY8U2g7vK9Y="), (byte[])authData.storedKey());
    }

    public void testTranscode() throws NoSuchAlgorithmException, InvalidKeyException {
        SCRAMHelper.AuthenticationData authData = SCRAMHelper.transcode((String)"SHA1", (byte[])Base64.decode((String)"HZbuOlKbWl+eR8AfIposuKbhX30="));
        Assert.assertArrayEquals((byte[])Base64.decode((String)"D+CSWLOshSulAsxiupA+qs2/fTE="), (byte[])authData.serverKey());
        Assert.assertArrayEquals((byte[])Base64.decode((String)"6dlGYMOdZcOPutkcNY8U2g7vK9Y="), (byte[])authData.storedKey());
    }
}

