/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.xmppclient.StreamManagementCommand;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.SaslAuth2;

@Bean(name="urn:xmpp:sm:3", parent=SessionManager.class, active=true)
public class StreamManagementInline
implements SaslAuth2.Inline {
    public static final String SESSION_RESUMPTION_ID_KEY = "session-resumption-id";
    @Inject(bean="service", nullAllowed=true)
    private SessionManager sessionManager;

    @Override
    public boolean canHandle(XMPPResourceConnection connection, Element el) {
        return switch (el.getName()) {
            case "enable", "resume" -> {
                if (el.getXMLNS() == "urn:xmpp:sm:3") {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public Element[] supStreamFeatures(SaslAuth2.Inline.Action action) {
        Element[] elementArray;
        switch (action) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case sasl2: {
                Element[] elementArray2 = new Element[1];
                elementArray = elementArray2;
                elementArray2[0] = new Element("sm", new String[]{"xmlns"}, new String[]{"urn:xmpp:sm:3"});
                break;
            }
            case bind2: {
                Element[] elementArray3 = new Element[1];
                elementArray = elementArray3;
                elementArray3[0] = new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:sm:3"});
            }
        }
        return elementArray;
    }

    @Override
    public CompletableFuture<SaslAuth2.Inline.Result> process(XMPPResourceConnection session, Element action) {
        return switch (action.getName()) {
            case "resume" -> this.resumeSession(session, action);
            case "enable" -> this.enable(session, action);
            default -> CompletableFuture.failedFuture(new ComponentException(Authorization.BAD_REQUEST));
        };
    }

    private CompletableFuture<SaslAuth2.Inline.Result> enable(XMPPResourceConnection session, Element action) {
        try {
            boolean resume = Boolean.parseBoolean(action.getAttributeStaticStr("resume"));
            Integer max = action.getAttributeStaticStr("max") != null ? Integer.valueOf(Integer.parseInt(action.getAttributeStaticStr("max"))) : null;
            Packet request = StreamManagementCommand.ENABLE.create(session.getSMComponentId(), session.getConnectionId());
            Command.addCheckBoxField(request, "resume", resume);
            if (resume && max != null) {
                Command.addFieldValue(request, "max", String.valueOf(max));
            }
            final CompletableFuture<SaslAuth2.Inline.Result> future = new CompletableFuture<SaslAuth2.Inline.Result>();
            this.sessionManager.addOutPacketWithTimeout(request, new ReceiverTimeoutHandler(){

                @Override
                public void timeOutExpired(Packet data) {
                    future.complete(StreamManagementInline.this.prepareFailed(Authorization.REMOTE_SERVER_TIMEOUT));
                }

                @Override
                public void responseReceived(Packet data, Packet result) {
                    String maxTimeout;
                    String location;
                    Element enabled = new Element("enabled");
                    enabled.setXMLNS("urn:xmpp:sm:3");
                    String resumptionId = Command.getFieldValue(result, "id");
                    if (resumptionId != null) {
                        enabled.setAttribute("id", resumptionId);
                    }
                    if ((location = Command.getFieldValue(result, "location")) != null) {
                        enabled.addAttribute("location", location);
                    }
                    if ((maxTimeout = Command.getFieldValue(result, "max")) != null) {
                        enabled.addAttribute("max", maxTimeout);
                    }
                    future.complete(new SaslAuth2.Inline.Result(enabled, true));
                }
            }, 10L, TimeUnit.SECONDS);
            return future;
        }
        catch (Exception ex) {
            return CompletableFuture.completedFuture(this.prepareFailed(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    private CompletableFuture<SaslAuth2.Inline.Result> resumeSession(final XMPPResourceConnection session, Element action) {
        String resumptionId = action.getAttributeStaticStr("previd");
        int h = Integer.parseInt(action.getAttributeStaticStr("h"));
        final Optional<XMPPResourceConnection> oldSessionOptional = session.getParentSession().getActiveResources().stream().filter(sess -> resumptionId.equals(sess.getSessionData(SESSION_RESUMPTION_ID_KEY))).findFirst();
        if (oldSessionOptional.isEmpty()) {
            return CompletableFuture.completedFuture(this.prepareFailed(Authorization.ITEM_NOT_FOUND));
        }
        try {
            Packet request = StreamManagementCommand.MOVE_STREAM.create(session.getSMComponentId(), session.getConnectionId());
            Command.addFieldValue(request, "resumption-id", resumptionId);
            Command.addFieldValue(request, "h", String.valueOf(h));
            final CompletableFuture<SaslAuth2.Inline.Result> future = new CompletableFuture<SaslAuth2.Inline.Result>();
            this.sessionManager.addOutPacketWithTimeout(request, new ReceiverTimeoutHandler(){

                @Override
                public void timeOutExpired(Packet data) {
                    future.complete(StreamManagementInline.this.prepareFailed(Authorization.RESOURCE_CONSTRAINT));
                }

                @Override
                public void responseReceived(Packet data, Packet result) {
                    if (result.getType() == StanzaType.error) {
                        List children;
                        Authorization auth = Authorization.INTERNAL_SERVER_ERROR;
                        Element el = result.getElemChild("error");
                        if (el != null && (children = el.getChildren()) != null) {
                            for (Element child : children) {
                                Authorization tmp = Authorization.getByCondition(child.getName());
                                if (tmp == null) continue;
                                auth = tmp;
                                break;
                            }
                        }
                        future.complete(StreamManagementInline.this.prepareFailed(auth));
                    } else {
                        try {
                            Field resourceField = XMPPResourceConnection.class.getDeclaredField("resource");
                            resourceField.setAccessible(true);
                            resourceField.set(session, ((XMPPResourceConnection)oldSessionOptional.get()).getResource());
                            Element resumed = new Element("resumed");
                            resumed.setXMLNS("urn:xmpp:sm:3");
                            String hResponse = Command.getFieldValue(result, "h");
                            resumed.setAttribute("h", hResponse);
                            future.complete(new SaslAuth2.Inline.Result(resumed, false));
                        }
                        catch (Throwable ex) {
                            future.completeExceptionally(ex);
                        }
                    }
                }
            }, 10L, TimeUnit.SECONDS);
            return future;
        }
        catch (NoConnectionIdException ex) {
            return CompletableFuture.completedFuture(this.prepareFailed(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    private SaslAuth2.Inline.Result prepareFailed(Authorization authorization) {
        Element failed = new Element("failed");
        failed.setXMLNS("urn:xmpp:sm:3");
        failed.withElement(authorization.getCondition(), "urn:ietf:params:xml:ns:xmpp-stanzas", (String)null);
        return new SaslAuth2.Inline.Result(failed, true);
    }
}

