/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.db.DBInitException;
import tigase.db.Repository;
import tigase.util.reflection.ClassUtilBean;

public class DataSourceHelper {
    private static final Logger log = Logger.getLogger(DataSourceHelper.class.getCanonicalName());

    public static <T extends Class<?>> Set<T> getAnnotatedClasses(T cls) {
        HashSet classes = new HashSet();
        for (Class<?> clazz : ClassUtilBean.getInstance().getAllClasses()) {
            Repository.Meta annotation = clazz.getAnnotation(Repository.Meta.class);
            if (annotation == null || !cls.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static <T extends Class<?>> T getDefaultClass(T cls, String uri, Matcher matcher) throws DBInitException {
        Set<T> classes = DataSourceHelper.getAnnotatedClasses(cls);
        HashSet<T> supported = new HashSet<T>();
        for (T clazz : classes) {
            if (matcher != null && !matcher.matches(clazz)) continue;
            Repository.Meta annotation = clazz.getAnnotation(Repository.Meta.class);
            if (annotation != null) {
                String[] supportedUris = annotation.supportedUris();
                if (supportedUris != null) {
                    for (String supportedUri : supportedUris) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "checking if {0} for {1} supports {2} while it supports {3} result = {4}", new Object[]{clazz.getCanonicalName(), cls.getCanonicalName(), uri, supportedUri, Pattern.matches(supportedUri, uri)});
                        }
                        if (!Pattern.matches(supportedUri, uri)) continue;
                        supported.add(clazz);
                    }
                    continue;
                }
                supported.add(clazz);
                continue;
            }
            supported.add(clazz);
        }
        if (supported.isEmpty()) {
            throw new DBInitException("[DataSourceHelper] Not found class supporting uri = " + uri);
        }
        Class result = null;
        for (Class clazz : supported) {
            if (result == null) {
                result = clazz;
                continue;
            }
            Repository.Meta ar = result.getAnnotation(Repository.Meta.class);
            Repository.Meta ac = clazz.getAnnotation(Repository.Meta.class);
            if (ac == null || (ar != null || ac == null) && (ar.isDefault() || (ar.supportedUris() != null || ac.supportedUris() == null) && !ac.isDefault())) continue;
            result = clazz;
        }
        return (T)result;
    }

    public static <T extends Class<?>> T getDefaultClass(T cls, String uri) throws DBInitException {
        return DataSourceHelper.getDefaultClass(cls, uri, null);
    }

    public static String getDefaultClassName(Class cls, String uri) throws DBInitException {
        Class result = DataSourceHelper.getDefaultClass(cls, uri);
        return result.getCanonicalName();
    }

    public static interface Matcher {
        public boolean matches(Class var1);
    }
}

