/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.xmpp.impl.ProcessorTestCase;

public class AbstractProcessorWithDataSourceTestCase<DS extends DataSource>
extends ProcessorTestCase {
    protected static String uri = System.getProperty("testDbUri");
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    protected DS dataSource;

    @AfterClass
    public static void cleanDerby() {
        if (uri.contains("jdbc:derby:")) {
            File f = new File("derby_test");
            if (!f.exists()) {
                f = new File("tigase_test");
            }
            if (f.exists()) {
                if (f.listFiles() != null) {
                    Arrays.asList(f.listFiles()).forEach(f2 -> {
                        if (f2.listFiles() != null) {
                            Arrays.asList(f2.listFiles()).forEach(f3 -> f3.delete());
                        }
                        f2.delete();
                    });
                }
                f.delete();
            }
        }
    }

    protected static void loadSchema(String schemaId, String schemaVersion, Set<String> components) throws DBInitException {
        SchemaLoader loader = SchemaLoader.newInstance((String)"jdbc");
        SchemaLoader.Parameters params = loader.createParameters();
        params.parseUri(uri);
        params.setDbRootCredentials(null, null);
        loader.init(params, Optional.empty());
        loader.validateDBConnection();
        loader.validateDBExists();
        Assert.assertEquals((Object)SchemaLoader.Result.ok, (Object)loader.loadCommonSchema());
        Optional schemaInfo = SchemaManager.getDefaultSchemaFor((String)uri, (String)schemaId, components);
        Assert.assertEquals((Object)SchemaLoader.Result.ok, (Object)loader.loadSchema((SchemaManager.SchemaInfo)schemaInfo.get(), schemaVersion));
        loader.postInstallation();
        loader.shutdown();
    }

    @Before
    public void setupDataSource() throws Exception {
        this.dataSource = this.prepareDataSource();
        this.getKernel().registerBean("dataSource").asInstance(this.dataSource).exportable().exec();
    }

    protected DS prepareDataSource() throws RepositoryException, IllegalAccessException, InstantiationException {
        DataSource dataSource = (DataSource)DataSourceHelper.getDefaultClass(DataSource.class, (String)uri).newInstance();
        dataSource.initialize(uri);
        return (DS)dataSource;
    }
}

