/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.io.CertificateContainer;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainer;
import tigase.io.SSLContextContainerAbstract;

public class CertificateContainerTest {
    private static final Logger LOGGER = Logger.getLogger(CertificateContainerTest.class.getName());
    private final String domain = "example.com";
    private CertificateContainer certificateContainer;

    @Test
    public void testRegularDomain() throws Exception {
        this.testDomain("example.com", true);
    }

    @Test
    public void testWildcardDomain() throws Exception {
        this.testDomain("push.example.com", true);
    }

    @Test
    public void testUpperCaseDomain() throws Exception {
        this.testDomain("example.com".toUpperCase(), true);
    }

    @Test
    public void testNonexistentDomain() throws Exception {
        this.testDomain("xmpp.org", false);
    }

    @Before
    public void setup() throws CertificateException, NoSuchAlgorithmException, IOException, SignatureException, NoSuchProviderException, InvalidKeyException {
        this.certificateContainer = new CertificateContainer(){

            KeyManagerFactory addCertificateEntry(CertificateEntry entry, String alias, boolean store) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
                return super.addCertificateEntry(entry, alias, false);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cert-alias", "example.com");
        CertificateEntry selfSignedCertificate = CertificateUtil.createSelfSignedCertificate((String)"test@mail.com", (String)"*.example.com", (String)"OU", (String)"O", (String)"City", (String)"State", (String)"Country", () -> CertificateUtil.createKeyPair((int)1024, (String)"secret"));
        String pemCertificate = CertificateUtil.exportToPemFormat((CertificateEntry)selfSignedCertificate);
        params.put("pem-certificate", pemCertificate);
        params.put("cert-save-to-disk", "false");
        this.certificateContainer.addCertificates(params);
    }

    private void testDomain(String hostname, boolean expectsExist) throws Exception {
        CertificateEntry certificateEntry = this.certificateContainer.getCertificateEntry(hostname);
        LOGGER.log(Level.INFO, "Certificate for hostname " + hostname + ": " + (certificateEntry != null ? certificateEntry.toString(true) : "n/a"));
        if (expectsExist) {
            Assert.assertNotNull((Object)certificateEntry);
        } else {
            Assert.assertNull((Object)certificateEntry);
        }
        SSLContextContainer sslContextContainer = new SSLContextContainer((CertificateContainerIfc)this.certificateContainer);
        SSLContextContainerAbstract.SSLHolder ssl = sslContextContainer.createContextHolder("SSL", hostname, hostname, false, new TrustManager[0]);
        Assert.assertNotNull((Object)ssl);
        Assert.assertNotNull((Object)ssl.domainCertificate);
        String CName = CertificateUtil.getCertCName((X509Certificate)ssl.domainCertificate);
        if (expectsExist) {
            Assert.assertEquals((Object)certificateEntry.getCertChain()[0], (Object)ssl.domainCertificate);
            Assert.assertTrue((boolean)CName.contains("example.com"));
        } else {
            Assert.assertFalse((boolean)CName.contains("example.com"));
        }
    }
}

