/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.locker;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import tigase.TestLogger;
import tigase.db.util.locker.ConnectionLock;

public class ConnectionLockTest {
    protected static String uri = System.getProperty("testDbUri");
    @ClassRule
    public static TestRule rule = (statement, description) -> {
        if (uri == null || !uri.startsWith("jdbc:")) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                }
            };
        }
        return statement;
    };

    @BeforeClass
    public static void setUp() throws Exception {
        TestLogger.configureLogger(Logger.getLogger("tigase.db.util.locker"), Level.FINEST);
    }

    @Test
    public void permitSkipIfAbsent() {
        Optional connectionLock = ConnectionLock.getConnectionLocker((String)uri);
        Assert.assertTrue((connectionLock.isEmpty() || ((ConnectionLock)connectionLock.get()).lock() ? 1 : 0) != 0);
        if (connectionLock.isPresent()) {
            ConnectionLock lock = (ConnectionLock)connectionLock.get();
            Assert.assertTrue((boolean)lock.isLocked());
            Assert.assertTrue((boolean)lock.unlock());
        }
    }

    @Test
    public void singleLockAndUnlock() {
        Optional connectionLocker = ConnectionLock.getConnectionLocker((String)uri);
        if (connectionLocker.isPresent()) {
            ConnectionLock lock = (ConnectionLock)connectionLocker.get();
            Assert.assertFalse((boolean)lock.isLocked());
            Assert.assertTrue((boolean)lock.lock());
            Assert.assertTrue((boolean)lock.isLocked());
            Assert.assertTrue((boolean)lock.unlock());
            Assert.assertFalse((boolean)lock.isLocked());
        }
    }

    @Test
    public void multipleLockAndUnlock() {
        Optional connectionLocker = ConnectionLock.getConnectionLocker((String)uri);
        Optional connectionLocker2 = ConnectionLock.getConnectionLocker((String)uri);
        if (connectionLocker.isPresent() && connectionLocker2.isPresent()) {
            ConnectionLock lock = (ConnectionLock)connectionLocker.get();
            ConnectionLock lock2 = (ConnectionLock)connectionLocker2.get();
            ((ConnectionLock)connectionLocker.get()).lockAttemptsLimit = 3;
            ((ConnectionLock)connectionLocker2.get()).lockAttemptsLimit = 3;
            Assert.assertFalse((boolean)lock.isLocked());
            Assert.assertFalse((boolean)lock2.isLocked());
            Assert.assertTrue((boolean)lock.lock());
            Assert.assertTrue((boolean)lock.isLocked());
            Assert.assertFalse((boolean)lock2.lock());
            Assert.assertFalse((boolean)lock2.isLocked());
            Assert.assertTrue((boolean)lock.unlock());
            Assert.assertFalse((boolean)lock.isLocked());
        }
    }
}

