/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.RepositoryPool;
import tigase.db.TigaseDBException;
import tigase.xmpp.jid.BareJID;

public class AuthRepositoryPool
implements AuthRepository,
RepositoryPool<AuthRepository> {
    private static final Logger log = Logger.getLogger(AuthRepositoryPool.class.getName());
    private LinkedBlockingQueue<AuthRepository> repoPool = new LinkedBlockingQueue();

    @Override
    public void addRepo(AuthRepository repo) {
        this.repoPool.offer(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(BareJID user, String password) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.addUser(user, password);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                AuthRepository.AccountStatus accountStatus = repo.getAccountStatus(user);
                return accountStatus;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials(BareJID user, String credentialId) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                Credentials credentials = repo.getCredentials(user, credentialId);
                return credentials;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getPassword(user);
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    @Override
    public String getResourceUri() {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                String string = repo.getResourceUri();
                return string;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getActiveUsersCountIn(Duration duration) {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getActiveUsersCountIn(duration);
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getCredentialIds(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                Collection<String> collection = repo.getCredentialIds(user);
                return collection;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount() {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getUsersCount();
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsersCount(String domain) {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                long l = repo.getUsersCount(domain);
                return l;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return -1L;
    }

    @Override
    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMechanismSupported(String domain, String mechanism) {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.isMechanismSupported(domain, mechanism);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserDisabled(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.isUserDisabled(user);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    @Override
    public void loggedIn(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.loggedIn(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    @Override
    public void logout(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.logout(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean otherAuth(Map<String, Object> authProps) throws TigaseDBException, AuthorizationException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                boolean bl = repo.otherAuth(authProps);
                return bl;
            }
            finally {
                this.addRepo(repo);
            }
        }
        log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        return false;
    }

    @Override
    public void queryAuth(Map<String, Object> authProps) {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.queryAuth(authProps);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCredential(BareJID user, String credentialId) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeCredential(user, credentialId);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    @Override
    public void removeUser(BareJID user) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.removeUser(user);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.setAccountStatus(user, status);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserDisabled(BareJID user, Boolean value) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.setUserDisabled(user, value);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    public AuthRepository takeRepo() {
        try {
            return this.repoPool.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain user auth repository from the pool", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredential(BareJID user, String credentialId, String password) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.updateCredential(user, credentialId, password);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePassword(BareJID user, String password) throws TigaseDBException {
        AuthRepository repo = this.takeRepo();
        if (repo != null) {
            try {
                repo.updatePassword(user, password);
            }
            finally {
                this.addRepo(repo);
            }
        } else {
            log.warning("repo is NULL, pool empty? - " + this.repoPool.size());
        }
    }
}

