/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules.impl.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.form.Form;
import tigase.kernel.BeanUtils;
import tigase.kernel.TypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Converter;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="BeanConfiguratorAdHocCommand", active=true)
public class ConfiguratorCommand
implements AdHocCommand {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject(bean="defaultTypesConverter")
    protected TypesConverter defaultTypesConverter;
    @Inject(bean="defaultBeanConfigurator")
    private AbstractBeanConfigurator beanConfigurator;
    @Inject(bean="kernel")
    private Kernel kernel;
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form f;
        Element data = request.getCommand().getChild("x", "jabber:x:data");
        Form form = f = data == null ? null : new Form(data);
        if (request.getAction() != null && "cancel".equals(request.getAction())) {
            response.cancelSession();
        } else if (data == null) {
            Form form2 = new Form("form", "Select Bean to configure", null);
            ArrayList<String> items = this.getConfigurableBeansNames();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            Collections.sort(items);
            arrayList.add("-- All --");
            values.add("-");
            for (String bn : items) {
                arrayList.add(bn);
                values.add(bn);
            }
            form2.addField(tigase.form.Field.fieldListSingle((String)"bean", (String)"-", (String)"Bean to configure", (String[])arrayList.toArray(new String[0]), (String[])values.toArray(new String[0])));
            response.getElements().add(form2.getElement());
            response.startSession();
        } else if (f != null && f.getAsString("bean") != null) {
            try {
                String n = f.getAsString("bean");
                n = n.equals("-") ? null : n.trim();
                Form form3 = new Form("form", "Configure Beans", null);
                ArrayList<ConfigFieldItem> arrayList = this.getConfigItems(n);
                Collections.sort(arrayList);
                BeanConfig bc = null;
                for (ConfigFieldItem cfi : arrayList) {
                    String key = cfi.beanConfig.getBeanName() + "/" + cfi.field.getName();
                    Object bean = this.kernel.getInstance(cfi.beanConfig.getBeanName());
                    Object value = BeanUtils.getValue(bean, cfi.field);
                    if (bc == null || !bc.equals(cfi.beanConfig)) {
                        form3.addField(tigase.form.Field.fieldFixed((String)("Bean: " + cfi.beanConfig.getBeanName())));
                        bc = cfi.beanConfig;
                    }
                    TypesConverter converter = this.defaultTypesConverter;
                    Converter cAnn = cfi.field.getAnnotation(Converter.class);
                    if (cAnn != null) {
                        converter = this.kernel.getInstance(cAnn.converter());
                    }
                    tigase.form.Field field = tigase.form.Field.fieldTextSingle((String)key, (String)(value == null ? "" : converter.toString(value)), (String)cfi.configField.desc());
                    form3.addField(field);
                }
                response.getElements().add(form3.getElement());
                response.startSession();
            }
            catch (Exception e) {
                throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
            }
        } else {
            HashMap values = new HashMap();
            for (tigase.form.Field field : f.getAllFields()) {
                int i = field.getVar().indexOf(47);
                String bn = field.getVar().substring(0, i);
                String fn = field.getVar().substring(i + 1);
                String value = field.getValue();
                BeanConfig beanConfig = this.kernel.getDependencyManager().getBeanConfig(bn);
                if (!values.containsKey(beanConfig)) {
                    values.put(beanConfig, new HashMap());
                }
                HashMap valuesToSet = (HashMap)values.get(beanConfig);
                valuesToSet.put(fn, value);
            }
            for (Map.Entry entry : values.entrySet()) {
                BeanConfig beanConfig = (BeanConfig)entry.getKey();
                Object bean = this.kernel.getInstance(beanConfig.getBeanName());
                this.beanConfigurator.configure(beanConfig, bean, (Map)entry.getValue());
            }
        }
    }

    @Override
    public String getName() {
        return "Configurator";
    }

    @Override
    public String getNode() {
        return "bean-configurator";
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }

    private ArrayList<ConfigFieldItem> getConfigItems(String beanName) {
        ArrayList<ConfigFieldItem> result = new ArrayList<ConfigFieldItem>();
        for (BeanConfig bc : this.kernel.getDependencyManager().getBeanConfigs()) {
            Field[] fields;
            if (beanName != null && !beanName.equals(bc.getBeanName())) continue;
            Class<?> cl = bc.getClazz();
            for (Field field : fields = DependencyManager.getAllFields(cl)) {
                ConfigField cf = field.getAnnotation(ConfigField.class);
                if (cf == null) continue;
                ConfigFieldItem cfi = new ConfigFieldItem();
                cfi.beanConfig = bc;
                cfi.configField = cf;
                cfi.field = field;
                result.add(cfi);
            }
        }
        return result;
    }

    private ArrayList<String> getConfigurableBeansNames() {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (BeanConfig bc : this.kernel.getDependencyManager().getBeanConfigs()) {
            Field[] fields;
            Class<?> cl = bc.getClazz();
            for (Field field : fields = DependencyManager.getAllFields(cl)) {
                ConfigField cf = field.getAnnotation(ConfigField.class);
                if (cf == null) continue;
                result.add(bc.getBeanName());
                continue block0;
            }
        }
        return result;
    }

    private class ConfigFieldItem
    implements Comparable<ConfigFieldItem> {
        BeanConfig beanConfig;
        ConfigField configField;
        Field field;

        private ConfigFieldItem() {
        }

        @Override
        public int compareTo(ConfigFieldItem o) {
            String t0 = this.beanConfig.getBeanName() + "#" + this.field.getName();
            String t1 = o.beanConfig.getBeanName() + "#" + o.field.getName();
            return t0.compareTo(t1);
        }
    }
}

