/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.lang.reflect.Field;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import tigase.Assert;
import tigase.db.DataSource;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.core.Kernel;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.amp.db.MsgRepository;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MessageDeliveryLogic;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.push.PushNotificationHelper;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.JID;

public class PushNotificationsTest
extends ProcessorTestCase {
    private MsgRepository msgRepository;
    private PushNotifications pushNotifications;
    private JID pushServiceJid = JID.jidInstanceNS((String)"push.example.com");
    private JID recipientJid;
    private JID senderJid;

    @Override
    @Before
    public void setUp() throws Exception {
        this.recipientJid = JID.jidInstanceNS((String)("recipient-" + UUID.randomUUID() + "@example.com/res-1"));
        this.senderJid = JID.jidInstanceNS((String)("sender-" + UUID.randomUUID() + "@example.com/res-1"));
        super.setUp();
        this.registerLocalBeans(this.getKernel());
        this.pushNotifications = this.getInstance(PushNotifications.class);
        this.msgRepository = this.getInstance(MsgRepository.class);
        Field f = RosterFactory.class.getDeclaredField("shared");
        f.setAccessible(true);
        f.set(null, RosterFactory.newRosterInstance((String)RosterFactory.ROSTER_IMPL_PROP_VAL));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_initialState() throws Exception {
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void test_enable() throws Exception {
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.recipientJid);
        this.enable(session, null);
    }

    protected void enable(XMPPResourceConnection session, Consumer<Element> consumer) throws Exception {
        Element enableEl = new Element("enable", new String[]{"xmlns", "jid", "node"}, new String[]{"urn:xmpp:push:0", this.pushServiceJid.toString(), "push-node"});
        if (consumer != null) {
            consumer.accept(enableEl);
        }
        Element iqEl = new Element("iq", new Element[]{enableEl}, new String[]{"type", "id"}, new String[]{"set", UUID.randomUUID().toString()});
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(session.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.process(iq, session, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        org.junit.Assert.assertEquals((String)("wrong result = " + result), (Object)StanzaType.result, (Object)result.getType());
        org.junit.Assert.assertNotNull((Object)this.getInstance(UserRepository.class).getData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node"));
        Map settings = this.pushNotifications.getPushServices(this.recipientJid.getBareJID());
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)1L, (long)settings.size());
        Assert.assertElementEquals(new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}), (Element)settings.get(this.pushServiceJid + "/push-node"));
        settings = this.pushNotifications.getPushServices(session);
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)1L, (long)settings.size());
        Assert.assertElementEquals(new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}), (Element)settings.get(this.pushServiceJid + "/push-node"));
    }

    @Test
    public void test_disable() throws Exception {
        Element iqEl = new Element("iq", new Element[]{new Element("disable", new String[]{"xmlns", "jid", "node"}, new String[]{"urn:xmpp:push:0", this.pushServiceJid.toString(), "push-node"})}, new String[]{"type", "id"}, new String[]{"set", UUID.randomUUID().toString()});
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.recipientJid);
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(session.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.process(iq, session, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        org.junit.Assert.assertEquals((String)("wrong result = " + result), (Object)StanzaType.result, (Object)result.getType());
        org.junit.Assert.assertNull((Object)this.getInstance(UserRepository.class).getData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node"));
        Map settings = this.pushNotifications.getPushServices(this.recipientJid.getBareJID());
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)0L, (long)settings.size());
        settings = this.pushNotifications.getPushServices(session);
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)0L, (long)settings.size());
    }

    @Test
    public void test_notificationGeneration() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createPlainNotification(1L, this.senderJid, msgBody));
        Assert.assertElementEquals(expNotification.getElement(), results.poll().packet.getElement());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        results.clear();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createPlainNotification(2L, this.senderJid, msgBody));
        Assert.assertElementEquals(expNotification.getElement(), results.poll().packet.getElement());
    }

    @Test
    public void test_notificationGenerationForOMEMO() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        msg.addChild((XMLNodeIfc)new Element("encrypted", new String[]{"xmlns"}, new String[]{"eu.siacs.conversations.axolotl"}));
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createPlainNotification(1L, this.senderJid, msgBody));
        Assert.assertElementEquals(expNotification.getElement(), results.poll().packet.getElement());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        results.clear();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createPlainNotification(2L, this.senderJid, "New secure message. Open to see the message."));
        Assert.assertElementEquals(expNotification.getElement(), results.poll().packet.getElement());
    }

    @Test
    public void test_notificationGenerationForMUCwhenOnlineOLD() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)this.recipientJid.getDomain()), this.recipientJid);
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        Element presence = new Element("presence");
        session.setPresence(presence);
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns", "type"}, new String[]{"jabber:client", "groupchat"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void test_notificationGenerationForMUCwhenOnline() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)this.recipientJid.getDomain()), this.recipientJid);
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        Element presence = new Element("presence");
        session.setPresence(presence);
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns", "type"}, new String[]{"jabber:client", "groupchat"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        this.enable(session, enableEl -> enableEl.withElement("groupchat", "tigase:push:filter:groupchat:0", mucEl -> mucEl.withElement("room", roomEl -> {
            roomEl.setAttribute("jid", this.senderJid.getBareJID().toString());
            roomEl.setAttribute("allow", "always");
        })));
        msgBody = "Message body " + UUID.randomUUID().toString() + " - my_nick";
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns", "type"}, new String[]{"jabber:client", "groupchat"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        this.enable(session, enableEl -> enableEl.withElement("groupchat", "tigase:push:filter:groupchat:0", mucEl -> mucEl.withElement("room", roomEl -> {
            roomEl.setAttribute("jid", this.senderJid.getBareJID().toString());
            roomEl.setAttribute("allow", "mentioned");
            roomEl.setAttribute("nick", "my_nick");
        })));
        msgBody = "Message body " + UUID.randomUUID().toString() + " - my_nick";
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns", "type"}, new String[]{"jabber:client", "groupchat"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testMutingNotifications() throws TigaseDBException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        settings.withElement("muted", "tigase:push:filter:muted:0", mutedEl -> mutedEl.withElement("item", itemEl -> itemEl.setAttribute("jid", this.senderJid.getBareJID().toString())));
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testIgnoreUnknownNotifications() throws TigaseDBException, NotAuthorizedException, TigaseStringprepException, PolicyViolationException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        settings.addAttribute("ignore-from-unknown", "true");
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        RosterAbstract roster = RosterFactory.getRosterImplementation((boolean)true);
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)"test@test/1"), this.recipientJid);
        roster.addBuddy(session, this.senderJid.copyWithoutResource(), "Sender 1", null, RosterAbstract.SubscriptionType.both, null);
        session.logout();
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        results.clear();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testEncryptedNotification() throws TigaseDBException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[16];
        random.nextBytes(key);
        settings.withElement("encrypt", "tigase:push:encrypt:0", el -> {
            el.setCData(Base64.encode((byte[])key));
            el.setAttribute("alg", "aes-128-gcm");
        });
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Element notificationElem = results.remove().packet.getElement().findChild(new String[]{"iq", "pubsub", "publish", "item", "notification"});
        Element encrypted = notificationElem.getChild("encrypted", "tigase:push:encrypt:0");
        byte[] enc = Base64.decode((String)encrypted.getCData());
        byte[] iv = Base64.decode((String)encrypted.getAttributeStaticStr("iv"));
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
        byte[] decoded = cipher.doFinal(enc);
        org.junit.Assert.assertTrue((boolean)new String(decoded).contains(msgBody));
    }

    @Test
    public void testEncryptedJingleNotification() throws TigaseDBException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        settings.addChild((XMLNodeIfc)new Element("jingle", new String[]{"xmlns", "id"}, new String[]{"tigase:push:jingle:0", "test-1"}));
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[16];
        random.nextBytes(key);
        settings.withElement("encrypt", "tigase:push:encrypt:0", el -> {
            el.setCData(Base64.encode((byte[])key));
            el.setAttribute("alg", "aes-128-gcm");
        });
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        Element msg = new Element("message", new Element[]{new Element("propose", new String[]{"xmlns", "id"}, new String[]{"urn:xmpp:jingle-message:0", "test-1"})}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Element notificationElem = results.remove().packet.getElement().findChild(new String[]{"iq", "pubsub", "publish", "item", "notification"});
        Element encrypted = notificationElem.getChild("encrypted", "tigase:push:encrypt:0");
        org.junit.Assert.assertEquals((Object)"voip", (Object)encrypted.getAttributeStaticStr("type"));
        byte[] enc = Base64.decode((String)encrypted.getCData());
        byte[] iv = Base64.decode((String)encrypted.getAttributeStaticStr("iv"));
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
        byte[] decoded = cipher.doFinal(enc);
        org.junit.Assert.assertTrue((boolean)new String(decoded).contains("test-1"));
    }

    @Test
    public void testEncryptedJingleNotification_reject() throws TigaseDBException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NotAuthorizedException, TigaseStringprepException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        settings.addChild((XMLNodeIfc)new Element("jingle", new String[]{"xmlns", "id"}, new String[]{"tigase:push:jingle:0", "test-1"}));
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[16];
        random.nextBytes(key);
        settings.withElement("encrypt", "tigase:push:encrypt:0", el -> {
            el.setCData(Base64.encode((byte[])key));
            el.setAttribute("alg", "aes-128-gcm");
        });
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        Element msg = new Element("message", new Element[]{new Element("reject", new String[]{"xmlns", "id"}, new String[]{"urn:xmpp:jingle-message:0", "test-1"})}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.recipientJid, (JID)this.senderJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)"test-1", (String)"example.com", (String)"test-1"), this.recipientJid);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, session, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Element notificationElem = results.remove().packet.getElement().findChild(new String[]{"iq", "pubsub", "publish", "item", "notification"});
        Element encrypted = notificationElem.getChild("encrypted", "tigase:push:encrypt:0");
        org.junit.Assert.assertEquals((Object)"voip", (Object)encrypted.getAttributeStaticStr("type"));
        byte[] enc = Base64.decode((String)encrypted.getCData());
        byte[] iv = Base64.decode((String)encrypted.getAttributeStaticStr("iv"));
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
        byte[] decoded = cipher.doFinal(enc);
        org.junit.Assert.assertTrue((boolean)new String(decoded).contains("test-1"));
    }

    @Test
    public void testEncryptedNotificationForOMEMO() throws TigaseDBException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[16];
        random.nextBytes(key);
        settings.withElement("encrypt", "tigase:push:encrypt:0", el -> {
            el.setCData(Base64.encode((byte[])key));
            el.setAttribute("alg", "aes-128-gcm");
        });
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        msg.addChild((XMLNodeIfc)new Element("encrypted", new String[]{"xmlns"}, new String[]{"eu.siacs.conversations.axolotl"}));
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Element notificationElem = results.remove().packet.getElement().findChild(new String[]{"iq", "pubsub", "publish", "item", "notification"});
        Element encrypted = notificationElem.getChild("encrypted", "tigase:push:encrypt:0");
        byte[] enc = Base64.decode((String)encrypted.getCData());
        byte[] iv = Base64.decode((String)encrypted.getAttributeStaticStr("iv"));
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, iv));
        byte[] decoded = cipher.doFinal(enc);
        org.junit.Assert.assertTrue((boolean)new String(decoded).contains("New secure message. Open to see the message."));
    }

    @Test
    public void testMessageRetrieved() throws TigaseDBException, NotAuthorizedException, TigaseStringprepException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        settings.setAttribute("priority", "true");
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyOfflineMessagesRetrieved(this.getSession(this.recipientJid, this.recipientJid), new ArrayDeque());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        org.junit.Assert.assertEquals((Object)"low", (Object)results.poll().packet.getElemCDataStaticStr(new String[]{"iq", "pubsub", "publish", "item", "notification", "priority"}));
    }

    @Test
    public void testMessageRetrieved2() throws TigaseDBException, NotAuthorizedException, TigaseStringprepException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyOfflineMessagesRetrieved(this.getSession(this.recipientJid, this.recipientJid), new ArrayDeque());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        org.junit.Assert.assertEquals(null, (Object)results.poll().packet.getElemCDataStaticStr(new String[]{"iq", "pubsub", "publish", "item", "notification", "priority"}));
    }

    @Test
    public void testPushError() throws TigaseDBException, XMPPException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        Element settings1 = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node-1"});
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node-1", settings1.toString());
        ArrayDeque results = new ArrayDeque();
        Packet message = Message.getMessage((JID)this.senderJid, (JID)this.recipientJid, (StanzaType)StanzaType.chat, (String)("Message " + UUID.randomUUID().toString()), null, null, (String)UUID.randomUUID().toString());
        this.pushNotifications.notifyNewOfflineMessage(message, null, results, new HashMap());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> items = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        org.junit.Assert.assertEquals((long)items.size(), (long)2L);
        ProcessorTestCase.SessionManagerHandlerImpl.Item item = null;
        while ((item = items.poll()) != null) {
            if ("push-node-1".equals(item.packet.getAttributeStaticStr(new String[]{"iq", "pubsub", "publish"}, "node"))) {
                item.handler.handle(Authorization.ITEM_NOT_FOUND.getResponseMessage(item.packet, null, false));
                continue;
            }
            item.handler.handle(item.packet.okResult((String)null, 0));
        }
        Map data = this.getInstance(UserRepository.class).getDataMap(this.recipientJid.getBareJID(), "urn:xmpp:push:0");
        org.junit.Assert.assertNotNull((Object)data);
        org.junit.Assert.assertEquals((long)1L, (long)data.size());
        org.junit.Assert.assertNotNull(data.get(this.pushServiceJid.toString() + "/push-node"));
    }

    @Test
    public void testPushDisableByComponent() throws TigaseDBException, NotAuthorizedException {
        Element settings = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"});
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", settings.toString());
        Element settings1 = new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node-1"});
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node-1", settings1.toString());
        ArrayDeque results = new ArrayDeque();
        Packet message = Packet.packetInstance((Element)new Element("message").withElement("pubsub", "http://jabber.org/protocol/pubsub", pubsubEl -> {
            pubsubEl.setAttribute("node", "push-node-1");
            pubsubEl.withElement("affiliation", affEl -> {
                affEl.setAttribute("jid", this.recipientJid.toString());
                affEl.setAttribute("affiliation", "none");
            });
        }), (JID)this.pushServiceJid, (JID)this.recipientJid);
        this.pushNotifications.processMessage(message, null, new ArrayDeque()::offer);
        Map data = this.getInstance(UserRepository.class).getDataMap(this.recipientJid.getBareJID(), "urn:xmpp:push:0");
        org.junit.Assert.assertNotNull((Object)data);
        org.junit.Assert.assertEquals((long)1L, (long)data.size());
        org.junit.Assert.assertNotNull(data.get(this.pushServiceJid.toString() + "/push-node"));
    }

    protected void registerLocalBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("sess-man").asInstance((Object)this.getSessionManagerHandler()).setActive(true).exportable().exec();
        kernel.registerBean(MessageDeliveryLogic.class).setActive(true).exportable().exec();
        kernel.registerBean("msgRepository").asClass(MsgRepositoryIfcImpl.class).exportable().exec();
        kernel.registerBean(PushNotifications.class).setActive(true).exec();
    }

    public static class MsgRepositoryIfcImpl
    extends MsgRepository {
        private final Queue<Packet> stored = new ArrayDeque<Packet>();

        public Element getMessageExpired(long time, boolean delete) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
            LinkedList<Element> res = new LinkedList<Element>();
            for (Packet pac : this.stored) {
                res.add(pac.getElement());
            }
            return res;
        }

        public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
            return this.stored.offer(Packet.packetInstance((Element)msg, (JID)from, (JID)to));
        }

        public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException {
            return this.stored.stream().collect(Collectors.groupingBy(packet -> {
                switch (packet.getElemName()) {
                    case "message": {
                        return MsgRepository.MSG_TYPES.message;
                    }
                    case "presence": {
                        return MsgRepository.MSG_TYPES.presence;
                    }
                }
                return MsgRepository.MSG_TYPES.none;
            }, Collectors.counting()));
        }

        public List<Element> getMessagesList(JID to) throws UserNotFoundException {
            return null;
        }

        public int deleteMessagesToJID(List db_ids, XMPPResourceConnection session) throws UserNotFoundException {
            return 0;
        }

        public Queue<Element> loadMessagesToJID(List db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
            return null;
        }

        public Queue<Packet> getStored() {
            return this.stored;
        }

        public void setDataSource(DataSource dataSource) {
        }

        protected void loadExpiredQueue(int max) {
        }

        protected void loadExpiredQueue(Date expired) {
        }

        protected void deleteMessage(Object db_id) {
        }
    }
}

