/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.TestLogger;
import tigase.server.Packet;
import tigase.server.xmppclient.StreamManagementIOProcessor;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;

public class StreamManagementIOProcessorTest
extends TestCase {
    private static final String[] DELAY_PATH = new String[]{"message", "delay"};
    private static final String DELAY_XMLNS = "urn:xmpp:delay";
    private static final Logger log = TestLogger.getLogger(StreamManagementIOProcessorTest.class);

    @Test
    public void testValidateOutQueueOverflowToZero() {
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        int start = 0x7FFFFFF5;
        queue.setCounter(start - 1);
        int packetToAck = start + 5;
        for (int i = start; i <= Integer.MAX_VALUE && i > 0; ++i) {
            try {
                Packet p = Packet.packetInstance((Element)new Element("message", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p, Integer.MAX_VALUE);
                continue;
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        queue.ack(packetToAck);
        int size = queue.waitingForAck();
        StreamManagementIOProcessorTest.assertEquals((int)5, (int)size);
        StreamManagementIOProcessorTest.assertEquals((String)((StreamManagementIOProcessor.OutQueue.Entry)queue.getQueue().peek()).getPacketWithStamp().getElement().getAttributeStaticStr("id"), (String)String.valueOf(packetToAck + 1));
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertTrue((boolean)e.getPacketWithStamp().isXMLNSStaticStr(DELAY_PATH, DELAY_XMLNS)));
    }

    @Test
    public void testValidateOutQueueOverflowOverZero() {
        Packet p;
        int i;
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        int start = 0x7FFFFFFA;
        queue.setCounter(start - 1);
        int packetToAck = start + 3;
        for (i = start; i <= Integer.MAX_VALUE && i > 0; ++i) {
            try {
                p = Packet.packetInstance((Element)new Element("message", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p, Integer.MAX_VALUE);
                continue;
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        for (i = 0; i < 3; ++i) {
            try {
                p = Packet.packetInstance((Element)new Element("message", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p, Integer.MAX_VALUE);
                continue;
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        queue.ack(packetToAck);
        int size = queue.waitingForAck();
        StreamManagementIOProcessorTest.assertEquals((int)5, (int)size);
        StreamManagementIOProcessorTest.assertEquals((String)((StreamManagementIOProcessor.OutQueue.Entry)queue.getQueue().peek()).getPacketWithStamp().getElement().getAttributeStaticStr("id"), (String)String.valueOf(packetToAck + 1));
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertTrue((boolean)e.getPacketWithStamp().isXMLNSStaticStr(DELAY_PATH, DELAY_XMLNS)));
    }

    @Test
    public void testNoDelayForIq() {
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        int start = 0x7FFFFFF5;
        queue.setCounter(start - 1);
        int packetToAck = start + 5;
        for (int i = start; i <= Integer.MAX_VALUE && i > 0; ++i) {
            try {
                Packet p = Packet.packetInstance((Element)new Element("iq", new String[]{"id", "from", "to"}, new String[]{String.valueOf(i), "from@example.com", "to@example.com"}));
                queue.append(p, Integer.MAX_VALUE);
                continue;
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertFalse((boolean)e.getPacketWithStamp().isXMLNSStaticStr(new String[]{"iq", "delay"}, DELAY_XMLNS)));
    }

    @Test
    public void testForceDelayForResumption() {
        Packet p;
        StreamManagementIOProcessor.OutQueue queue = new StreamManagementIOProcessor.OutQueue();
        try {
            p = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{DELAY_XMLNS, "2015-07-10T00:00:00.000Z"})}, new String[]{"id", "from", "to"}, new String[]{String.valueOf("id-1"), "from@example.com", "to@example.com"}));
            queue.append(p, Integer.MAX_VALUE);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertEquals((int)1, (int)e.getPacketWithStamp().getElement().findChildren(el -> el.getName() == "delay").size()));
        queue.getQueue().clear();
        queue.setResumptionEnabled(true);
        try {
            p = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{DELAY_XMLNS, "2015-07-10T00:00:00.000Z"})}, new String[]{"id", "from", "to"}, new String[]{String.valueOf("id-1"), "from@example.com", "to@example.com"}));
            queue.append(p, Integer.MAX_VALUE);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertEquals((int)1, (int)e.getPacketWithStamp().getElement().findChildren(el -> el.getName() == "delay").size()));
        queue.getQueue().clear();
        try {
            p = Packet.packetInstance((Element)new Element("iq", new String[]{"id", "from", "to"}, new String[]{String.valueOf("id-2"), "from@example.com", "to@example.com"}));
            queue.append(p, Integer.MAX_VALUE);
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        queue.getQueue().forEach(e -> StreamManagementIOProcessorTest.assertFalse((boolean)e.getPacketWithStamp().isXMLNSStaticStr(new String[]{"iq", "delay"}, DELAY_XMLNS)));
    }

    @Test
    public void testShouldRequestAck() throws NoSuchFieldException, IllegalAccessException, TigaseStringprepException, InterruptedException {
        Packet p;
        int i;
        StreamManagementIOProcessor processor = new StreamManagementIOProcessor();
        Field ackRefMinDelayField = StreamManagementIOProcessor.class.getDeclaredField("ack_request_min_delay");
        ackRefMinDelayField.setAccessible(true);
        ackRefMinDelayField.set(processor, 20L);
        StreamManagementIOProcessor.OutQueue outQueue = new StreamManagementIOProcessor.OutQueue();
        StreamManagementIOProcessorTest.assertFalse((String)"Requesting ACK if queue is empty", (boolean)processor.shouldRequestAck(null, outQueue));
        for (i = 0; i < 10; ++i) {
            p = Packet.packetInstance((Element)new Element("message").withElement("body", null, "Test " + UUID.randomUUID().toString()));
            outQueue.append(p, 2000, 2000);
            StreamManagementIOProcessorTest.assertEquals((String)"Only call after adding 10th message should request ACK", (i == 9 ? 1 : 0) != 0, (boolean)processor.shouldRequestAck(null, outQueue));
        }
        outQueue.sendingRequest();
        StreamManagementIOProcessorTest.assertFalse((String)"ACK shouldn't be requested just after sending one!", (boolean)processor.shouldRequestAck(null, outQueue));
        for (i = 0; i < 10; ++i) {
            p = Packet.packetInstance((Element)new Element("message").withElement("body", null, "Test " + UUID.randomUUID().toString()));
            outQueue.append(p, 2000, 2000);
            StreamManagementIOProcessorTest.assertFalse((String)"ACK shouldn't be requested for 20ms after sending request for ACK", (boolean)processor.shouldRequestAck(null, outQueue));
        }
        Thread.sleep(21L);
        StreamManagementIOProcessorTest.assertTrue((String)"Request for ACK should be sent as over 20ms passed", (boolean)processor.shouldRequestAck(null, outQueue));
        outQueue.ack(10);
        StreamManagementIOProcessorTest.assertFalse((String)"Request for ACK shouldn't be sent for 20ms after receiving ACK", (boolean)processor.shouldRequestAck(null, outQueue));
        Thread.sleep(21L);
        StreamManagementIOProcessorTest.assertTrue((String)"Request for ACK should be sent as over 20ms passed", (boolean)processor.shouldRequestAck(null, outQueue));
    }
}

