/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import tigase.io.IOInterface;
import tigase.net.IOService;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.dns.DNSResolverFactory;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPIOServiceListener;

public class ConnectionManagerTest {
    @Test
    public void test_watchDog_timeout_whitespace() throws Exception {
        this.test_watchDogStop(ConnectionManager.WATCHDOG_PING_TYPE.WHITESPACE, Type.timeout, false);
    }

    @Test
    public void test_watchDog_timeout_xmppPing() throws Exception {
        this.test_watchDogStop(ConnectionManager.WATCHDOG_PING_TYPE.XMPP, Type.timeout, false);
    }

    @Test
    public void test_watchDog_timeout_whitespace_withDataWaiting() throws Exception {
        this.test_watchDogStop(ConnectionManager.WATCHDOG_PING_TYPE.WHITESPACE, Type.timeout, true);
    }

    @Test
    public void test_watchDog_timeout_xmppPing_withDataWaiting() throws Exception {
        this.test_watchDogStop(ConnectionManager.WATCHDOG_PING_TYPE.XMPP, Type.timeout, true);
    }

    protected ConnectionManager newConnectionManager(ConnectionManager.WATCHDOG_PING_TYPE pingType) throws Exception {
        ConnectionManager connectionManager = new ConnectionManager(){

            public Queue<Packet> processSocketData(XMPPIOService serv) {
                return null;
            }

            public boolean processUndeliveredPacket(Packet packet, Long stamp, String errorMessage) {
                return false;
            }

            public void reconnectionFailed(Map port_props) {
            }

            public void xmppStreamClosed(XMPPIOService serv) {
            }

            public String[] xmppStreamOpened(XMPPIOService serv, Map attribs) {
                return null;
            }

            public void packetsReady(IOService service) throws IOException {
            }

            public boolean serviceStopped(IOService service) {
                return super.serviceStopped((XMPPIOService)service);
            }

            public void tlsHandshakeCompleted(IOService service) {
            }

            protected long getMaxInactiveTime() {
                return 180000L;
            }

            protected XMPPIOService<?> getXMPPIOServiceInstance() {
                return null;
            }
        };
        Field f = ConnectionManager.class.getDeclaredField("watchdogPingType");
        f.setAccessible(true);
        f.set(connectionManager, pingType);
        f = ConnectionManager.class.getDeclaredField("watchdogDelay");
        f.setAccessible(true);
        f.set(connectionManager, 1);
        f = ConnectionManager.class.getDeclaredField("watchdogTimeout");
        f.setAccessible(true);
        f.set(connectionManager, -1);
        return connectionManager;
    }

    protected XMPPIOService getXMPPIOServiceInstance() {
        return new XMPPIOService(){

            public boolean waitingToRead() {
                return false;
            }

            public boolean waitingToSend() {
                return false;
            }
        };
    }

    protected XMPPIOService registerService(ConnectionManager connectionManager, final boolean waitingToSend) throws Exception {
        XMPPIOService service = this.getXMPPIOServiceInstance();
        Assert.assertNotNull((Object)service);
        IOInterface io = new IOInterface(){

            public int bytesRead() {
                return 0;
            }

            public boolean checkCapabilities(String caps) {
                return false;
            }

            public int getInputPacketSize() throws IOException {
                return 0;
            }

            public SocketChannel getSocketChannel() {
                return null;
            }

            public void getStatistics(StatisticsList list, boolean reset) {
            }

            public long getBytesSent(boolean reset) {
                return 0L;
            }

            public long getTotalBytesSent() {
                return 0L;
            }

            public long getBytesReceived(boolean reset) {
                return 0L;
            }

            public long getTotalBytesReceived() {
                return 0L;
            }

            public long getBuffOverflow(boolean reset) {
                return 0L;
            }

            public long getTotalBuffOverflow() {
                return 0L;
            }

            public boolean isConnected() {
                return false;
            }

            public boolean isRemoteAddress(String addr) {
                return false;
            }

            public ByteBuffer read(ByteBuffer buff) throws IOException {
                throw new IOException("Read failed!");
            }

            public void stop() throws IOException {
            }

            public boolean waitingToSend() {
                return waitingToSend;
            }

            public int waitingToSendSize() {
                return 0;
            }

            public int write(ByteBuffer buff) throws IOException {
                throw new IOException("Write failed!");
            }

            public void setLogId(String logId) {
            }
        };
        Field f = IOService.class.getDeclaredField("socketIO");
        f.setAccessible(true);
        f.set(service, io);
        String serviceId = UUID.randomUUID().toString();
        f = IOService.class.getDeclaredField("id");
        f.setAccessible(true);
        f.set(service, serviceId);
        this.getServices(connectionManager).put(serviceId, service);
        service.setIOServiceListener((XMPPIOServiceListener)connectionManager);
        service.setUserJid("m" + SecureRandom.getInstanceStrong().nextInt() + ".example.com");
        service.getSessionData().put("hostname-key", DNSResolverFactory.getInstance().getDefaultHost());
        return service;
    }

    protected void test_watchDogStop(ConnectionManager.WATCHDOG_PING_TYPE pingType, Type testType, boolean waitingToSend) throws Exception {
        ConnectionManager connectionManager = this.newConnectionManager(pingType);
        XMPPIOService service = this.registerService(connectionManager, waitingToSend);
        Field f = pingType == ConnectionManager.WATCHDOG_PING_TYPE.XMPP ? XMPPIOService.class.getDeclaredField("lastXmppPacketReceivedTime") : IOService.class.getDeclaredField("lastTransferTime");
        f.setAccessible(true);
        switch (testType) {
            case inactivity: {
                f.set(service, System.currentTimeMillis() - connectionManager.getMaxInactiveTime());
            }
            case timeout: {
                f.set(service, System.currentTimeMillis() - connectionManager.getMaxInactiveTime() / 2L);
            }
        }
        this.execute_watchDogStop(connectionManager);
    }

    protected void execute_watchDogStop(ConnectionManager connectionManager) throws Exception {
        ConnectionManager.Watchdog watchdog = connectionManager.newWatchdog();
        Method m = ConnectionManager.Watchdog.class.getDeclaredMethod("executeWatchdog", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)watchdog, new Object[0]);
        Assert.assertTrue((String)"All connections should be removed due to IOExceptions", (boolean)this.getServices(connectionManager).isEmpty());
    }

    protected Map<String, XMPPIOService> getServices(ConnectionManager connectionManager) throws Exception {
        Field f = ConnectionManager.class.getDeclaredField("services");
        f.setAccessible(true);
        return (Map)f.get(connectionManager);
    }

    private static enum Type {
        inactivity,
        timeout;

    }
}

