/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.core.Kernel;
import tigase.server.BasicComponent;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.script.AddScriptCommand;
import tigase.server.script.Script;
import tigase.util.log.LogFormatter;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

public class BasicComponentTest {
    static Logger log;
    private static BasicComponent instance;
    private static Kernel kernel;

    static void configureLogger(Logger log, Level level) {
        log.setUseParentHandlers(false);
        log.setLevel(level);
        Handler[] handlers = log.getHandlers();
        if (Arrays.stream(handlers).noneMatch(ConsoleHandler.class::isInstance)) {
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel(level);
            ch.setFormatter((Formatter)new LogFormatter());
            log.addHandler(ch);
        }
        for (Handler logHandler : handlers) {
            logHandler.setLevel(level);
        }
    }

    private static Script getTestScript() throws ScriptException {
        AddScriptCommand addScriptCommand = new AddScriptCommand();
        InputStream resourceAsStream = BasicComponentTest.class.getResourceAsStream("/TestScript.groovy");
        BufferedReader br = new BufferedReader(new InputStreamReader(resourceAsStream));
        String scriptTxt = br.lines().collect(Collectors.joining("\n"));
        Bindings bindings = BasicComponentTest.instance.scriptEngineManager.getBindings();
        return addScriptCommand.addAdminScript("test-cmd", "Test script", "tigase", scriptTxt, "groovy", "groovy", bindings);
    }

    @BeforeClass
    public static void setup() {
        log = Logger.getLogger("tigase");
        BasicComponentTest.configureLogger(log, Level.WARNING);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "basic");
        kernel = new Kernel();
        kernel.setName("basic");
        kernel.setForceAllowNull(true);
        kernel.registerBean(DefaultTypesConverter.class).exec();
        kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        DSLBeanConfiguratorWithBackwardCompatibility config = (DSLBeanConfiguratorWithBackwardCompatibility)kernel.getInstance(DSLBeanConfiguratorWithBackwardCompatibility.class);
        config.setProperties(props);
        kernel.registerBean("service").asClass(TestBasicComponent.class).setActive(true).exec();
        try {
            instance = (BasicComponent)kernel.getInstance(TestBasicComponent.class);
            Script script = BasicComponentTest.getTestScript();
            BasicComponentTest.instance.scriptCommands.put("test-cmd", script);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex, () -> "There was an error setting up test");
        }
    }

    @Test
    public void paralelScriptExecution() {
        this.runTest(true);
    }

    @Test
    public void serialScriptExecution() {
        this.runTest(false);
    }

    public void runTest(boolean paralel) {
        ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
        Set<Iq> iqPackets = this.generatePackets(1000);
        Set JIDs = (paralel ? iqPackets.parallelStream() : iqPackets.stream()).map(iqPacket -> {
            JID from = iqPacket.getFrom();
            instance.processScriptCommand((Packet)iqPacket, results);
            return from;
        }).collect(Collectors.toSet());
        Set resultJIDs = results.stream().map(packet -> JID.jidInstanceNS((String)Command.getFieldValue((Packet)packet, (String)"Note"))).filter(Objects::nonNull).collect(Collectors.toSet());
        Assert.assertEquals(JIDs, resultJIDs);
    }

    @Test
    public void simpleTest() throws ScriptException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByExtension("groovy");
        String script = "return key";
        CompiledScript compiled = ((Compilable)((Object)scriptEngine)).compile("return key");
        Set input = Stream.generate(() -> UUID.randomUUID().toString()).limit(10L).collect(Collectors.toSet());
        Set output = ((Stream)input.stream().parallel()).map(uuid -> {
            SimpleScriptContext context = new SimpleScriptContext();
            Bindings bindings = scriptEngine.createBindings();
            context.setBindings(bindings, 100);
            bindings.put("key", uuid);
            Object eval = null;
            try {
                eval = compiled.eval(context);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            return (String)eval;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Assert.assertEquals(input, output);
    }

    private Set<Iq> generatePackets(int maxSize) {
        return Stream.generate(() -> {
            JID stanzaAddress = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"domain.com");
            Element iq = Command.createIqCommand((JID)stanzaAddress, (JID)stanzaAddress, (StanzaType)StanzaType.set, (String)stanzaAddress.toString(), (String)"test-cmd", (Command.DataType)Command.DataType.submit);
            Iq iqPacket = new Iq(iq, stanzaAddress, stanzaAddress);
            Command.addFieldValue((Packet)iqPacket, (String)"accountjid", (String)stanzaAddress.toString());
            iqPacket.setXMLNS("jabber:client");
            iqPacket.setPermissions(Permissions.ADMIN);
            return iqPacket;
        }).limit(maxSize).collect(Collectors.toSet());
    }

    @Bean(name="TestBasicComponent", parent=Kernel.class, exportable=true, active=true)
    public static class TestBasicComponent
    extends BasicComponent {
        public boolean canCallCommand(JID jid, String commandId) {
            return true;
        }

        public boolean canCallCommand(JID jid, String domain, String commandId) {
            return true;
        }
    }
}

