/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;
import tigase.conf.ConfigReader;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.TypesConverter;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class TypesConverterTest {
    private HashMap<String, EnumSet<XT>> mapEnumSetField;
    private Collection<Integer> collectionIntField;
    private List<Integer> listIntField;
    private ArrayList<Integer> arrayListIntField;
    private Set<Integer> setIntField;

    @Test
    public void testConvert() throws Exception {
        Cloneable test;
        DefaultTypesConverter converter = new DefaultTypesConverter();
        Assert.assertEquals((Object)123, (Object)converter.convert((Object)"123", Integer.class));
        Assert.assertEquals((Object)123, (Object)converter.convert((Object)123, Integer.class));
        Assert.assertEquals((Object)"123", (Object)converter.convert((Object)123, String.class));
        Integer x1 = new Integer(1);
        Integer x2 = (Integer)converter.convert((Object)x1, Integer.class);
        Assert.assertTrue((x1 == x2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((Object)XT.a1), (Object)converter.convert((Object)"a1", XT.class));
        Assert.assertEquals((Object)JID.jidInstanceNS((String)"a@.b.c/d"), (Object)converter.convert((Object)"a@.b.c/d", JID.class));
        Assert.assertEquals((Object)BareJID.bareJIDInstanceNS((String)"a@.b.c"), (Object)converter.convert((Object)"a@.b.c", BareJID.class));
        Assert.assertEquals((Object)"test", (Object)converter.convert((Object)"test", String.class));
        Assert.assertEquals((Object)123L, (Object)converter.convert((Object)"123", Long.class));
        Assert.assertEquals((long)1234L, (long)((Long)converter.convert((Object)"1234", Long.TYPE)));
        Assert.assertEquals((Object)123, (Object)converter.convert((Object)"123", Integer.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)converter.convert((Object)"anything", Boolean.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)converter.convert((Object)"yes", Boolean.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)converter.convert((Object)"true", Boolean.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)converter.convert((Object)"on", Boolean.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)converter.convert((Object)"1", Boolean.class));
        Assert.assertTrue((boolean)((Boolean)converter.convert((Object)"1", Boolean.TYPE)));
        Assert.assertEquals((Object)Float.valueOf(123.1f), (Object)converter.convert((Object)"123.1", Float.class));
        Assert.assertEquals((Object)Float.valueOf(123.1f), (Object)converter.convert((Object)"123.1", Float.TYPE));
        Assert.assertEquals((Object)123.1, (Object)converter.convert((Object)"123.1", Double.class));
        Assert.assertEquals((Object)123.1, (Object)converter.convert((Object)"123.1", Double.TYPE));
        Assert.assertArrayEquals((Object[])new JID[]{JID.jidInstanceNS((String)"1@b.c/a"), JID.jidInstanceNS((String)"2@b.c/a"), JID.jidInstanceNS((String)"3@b.c/a")}, (Object[])((Object[])converter.convert((Object)"1@b.c/a,2@b.c/a,3@b.c/a", JID[].class)));
        Assert.assertArrayEquals((Object[])new BareJID[]{BareJID.bareJIDInstanceNS((String)"1@b.c"), BareJID.bareJIDInstanceNS((String)"2@b.c"), BareJID.bareJIDInstanceNS((String)"3@b.c")}, (Object[])((Object[])converter.convert((Object)"1@b.c,2@b.c,3@b.c", BareJID[].class)));
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((Object[])converter.convert((Object)"1,2,3", String[].class)));
        Assert.assertArrayEquals((Object[])new XT[]{XT.a1, XT.a1, XT.c3}, (Object[])((Object[])converter.convert((Object)"a1,a1,c3", XT[].class)));
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3, 1}, (Object[])((Object[])converter.convert((Object)"1,2,3,1", Integer[].class)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 1}, (int[])((int[])converter.convert((Object)"1,2,3,1", int[].class)));
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 1L}, (long[])((long[])converter.convert((Object)"1,2,3,1", long[].class)));
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])((byte[])converter.convert((Object)"1,2,3,4", byte[].class)));
        Assert.assertArrayEquals((byte[])new byte[]{48, 49, 50, 52}, (byte[])((byte[])converter.convert((Object)"string:0124", byte[].class)));
        Assert.assertArrayEquals((byte[])new byte[]{48, 49, 50, 53}, (byte[])((byte[])converter.convert((Object)"base64:MDEyNQ==", byte[].class)));
        Assert.assertArrayEquals((char[])new char[]{'1', '2', '3', '4'}, (char[])((char[])converter.convert((Object)"1,2,3,4", char[].class)));
        Assert.assertArrayEquals((char[])new char[]{'0', '1', '2', '4'}, (char[])((char[])converter.convert((Object)"string:0124", char[].class)));
        Assert.assertArrayEquals((char[])new char[]{'0', '1', '2', '5'}, (char[])((char[])converter.convert((Object)"base64:MDEyNQ==", char[].class)));
        Assert.assertEquals((Object)Level.CONFIG, (Object)converter.convert((Object)"CONFIG", Level.class));
        Assert.assertEquals((Object)Level.ALL, (Object)converter.convert((Object)"ALL", Level.class));
        Assert.assertEquals((Object)new File("/dupa.txt"), (Object)converter.convert((Object)"/dupa.txt", File.class));
        Assert.assertEquals((Object)new File("/dupa.txt"), (Object)converter.convert((Object)converter.toString((Object)new File("/dupa.txt")), File.class));
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("t1", "a1,b2");
        values.put("t2", "b2,c3");
        this.mapEnumSetField = (HashMap)converter.convert(values, HashMap.class, this.getClass().getDeclaredField("mapEnumSetField").getGenericType());
        Assert.assertEquals(EnumSet.of(XT.a1, XT.b2), this.mapEnumSetField.get("t1"));
        Assert.assertEquals(EnumSet.of(XT.b2, XT.c3), this.mapEnumSetField.get("t2"));
        values = new HashMap();
        values.put("t1", "A1,B2");
        values.put("t2", "B2,C3");
        this.mapEnumSetField = (HashMap)converter.convert(values, HashMap.class, this.getClass().getDeclaredField("mapEnumSetField").getGenericType());
        Assert.assertEquals(EnumSet.of(XT.a1, XT.b2), this.mapEnumSetField.get("t1"));
        Assert.assertEquals(EnumSet.of(XT.b2, XT.c3), this.mapEnumSetField.get("t2"));
        values = new HashMap();
        values.put("t1", "A1,b2");
        values.put("t2", "b2,C3");
        this.mapEnumSetField = (HashMap)converter.convert(values, HashMap.class, this.getClass().getDeclaredField("mapEnumSetField").getGenericType());
        Assert.assertEquals(EnumSet.of(XT.a1, XT.b2), this.mapEnumSetField.get("t1"));
        Assert.assertEquals(EnumSet.of(XT.b2, XT.c3), this.mapEnumSetField.get("t2"));
        Assert.assertEquals((Object)System.getProperty("java.home"), (Object)converter.convert((Object)new ConfigReader.PropertyVariable("java.home", null), String.class));
        ConfigReader.CompositeVariable compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)"Java: ");
        compositeVariable.add('+', (Object)new ConfigReader.PropertyVariable("java.vendor", null));
        compositeVariable.add('+', (Object)" ");
        compositeVariable.add('+', (Object)new ConfigReader.PropertyVariable("java.version", null));
        Assert.assertEquals((Object)("Java: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version")), (Object)converter.convert((Object)compositeVariable, String.class));
        compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)5);
        compositeVariable.add('-', (Object)2);
        compositeVariable.add('*', (Object)60);
        compositeVariable.add('*', (Object)1000);
        Assert.assertEquals((Object)new Integer(-119995), (Object)converter.convert((Object)compositeVariable, Integer.class));
        compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)5);
        compositeVariable.add('*', (Object)60.0);
        compositeVariable.add('*', (Object)1000);
        Assert.assertEquals((Object)new Double(300000.0), (Object)converter.convert((Object)compositeVariable, Double.class));
        try {
            test = new HashMap<String, String>();
            ((HashMap)test).put("test-domain.com", "true");
            Assert.assertFalse((String)"Invalid conversion of Map<> to String, should throw!", (converter.convert(test, String.class) != null ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            test = new HashMap();
            ((HashMap)test).put("test-domain.com", "true");
            Assert.assertFalse((String)"Invalid conversion of Map<> to BareJID, should throw!", (converter.convert(test, BareJID.class) != null ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            test = new HashMap();
            ((HashMap)test).put("test-domain.com", "true");
            Assert.assertFalse((String)"Invalid conversion of Map<> to JID, should throw!", (converter.convert((Object)test, JID.class) != null ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            test = new ArrayList();
            test.add("test-domain.com");
            Assert.assertFalse((String)"Invalid conversion of List<> to String, should throw!", (converter.convert((Object)test, String.class) != null ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            test = new ArrayList();
            test.add("test-domain.com");
            Assert.assertFalse((String)"Invalid conversion of List<> to BareJID, should throw!", (converter.convert((Object)test, BareJID.class) != null ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            test = new ArrayList();
            test.add("test-domain.com");
            Assert.assertFalse((String)"Invalid conversion of List<> to JID, should throw!", (converter.convert((Object)test, JID.class) != null ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testCollections() throws NoSuchFieldException {
        DefaultTypesConverter converter = new DefaultTypesConverter();
        ParameterizedType pt = (ParameterizedType)this.getClass().getDeclaredField("collectionIntField").getGenericType();
        this.collectionIntField = (Collection)converter.convert((Object)"1,2,3", (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.collectionIntField.toArray(Integer[]::new));
        this.collectionIntField = (Collection)converter.convert((Object)new int[]{1, 2, 3}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.collectionIntField.toArray(Integer[]::new));
        this.collectionIntField = (Collection)converter.convert((Object)new String[]{"1", "2", "3"}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.collectionIntField.toArray(Integer[]::new));
        this.collectionIntField = (Collection)converter.convert(Arrays.asList(1, 2, 3), (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.collectionIntField.toArray(Integer[]::new));
        try {
            this.collectionIntField.add(4);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        pt = (ParameterizedType)this.getClass().getDeclaredField("listIntField").getGenericType();
        this.listIntField = (List)converter.convert((Object)"1,2,3", (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.listIntField.toArray(Integer[]::new));
        this.listIntField = (List)converter.convert((Object)new int[]{1, 2, 3}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.listIntField.toArray(Integer[]::new));
        this.listIntField = (List)converter.convert((Object)new String[]{"1", "2", "3"}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.listIntField.toArray(Integer[]::new));
        this.listIntField = (List)converter.convert(Arrays.asList(1, 2, 3), (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.listIntField.toArray(Integer[]::new));
        try {
            this.listIntField.add(4);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        pt = (ParameterizedType)this.getClass().getDeclaredField("setIntField").getGenericType();
        this.setIntField = (Set)converter.convert((Object)"1,2,3", (Class)pt.getRawType(), (Type)pt);
        Assert.assertEquals((long)this.listIntField.size(), (long)this.setIntField.stream().filter(i -> this.listIntField.contains(i)).count());
        this.setIntField = (Set)converter.convert((Object)new int[]{1, 2, 3}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertEquals((long)this.listIntField.size(), (long)this.setIntField.stream().filter(i -> this.listIntField.contains(i)).count());
        this.setIntField = (Set)converter.convert((Object)new String[]{"1", "2", "3"}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertEquals((long)this.listIntField.size(), (long)this.setIntField.stream().filter(i -> this.listIntField.contains(i)).count());
        this.setIntField = (Set)converter.convert(Arrays.asList(1, 2, 3), (Class)pt.getRawType(), (Type)pt);
        Assert.assertEquals((long)this.listIntField.size(), (long)this.setIntField.stream().filter(i -> this.listIntField.contains(i)).count());
        try {
            this.setIntField.add(4);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        pt = (ParameterizedType)this.getClass().getDeclaredField("arrayListIntField").getGenericType();
        this.arrayListIntField = (ArrayList)converter.convert((Object)"1,2,3", (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.arrayListIntField.toArray(Integer[]::new));
        this.arrayListIntField = (ArrayList)converter.convert((Object)new int[]{1, 2, 3}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.arrayListIntField.toArray(Integer[]::new));
        this.arrayListIntField = (ArrayList)converter.convert((Object)new String[]{"1", "2", "3"}, (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.arrayListIntField.toArray(Integer[]::new));
        this.arrayListIntField = (ArrayList)converter.convert(Arrays.asList(1, 2, 3), (Class)pt.getRawType(), (Type)pt);
        Assert.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])this.arrayListIntField.toArray(Integer[]::new));
        try {
            this.arrayListIntField.add(4);
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testParcelable() {
        DefaultTypesConverter converter = new DefaultTypesConverter();
        ParcelableObject o1 = new ParcelableObject();
        o1.setIp("1.2.3.4");
        o1.setTimestamp(123456L);
        o1.setJid(JID.jidInstanceNS((String)"ala@ma.kota"));
        o1.setDescription("blah bla, blah; blah... :-)");
        String encoded = converter.toString((Object)o1);
        Assert.assertEquals((Object)"1.2.3.4,ala@ma.kota,123456,blah bla\\, blah; blah... :-)", (Object)encoded);
        ParcelableObject o2 = (ParcelableObject)converter.convert((Object)encoded, ParcelableObject.class);
        Assert.assertEquals((Object)o1.getIp(), (Object)o2.getIp());
        Assert.assertEquals((long)o1.getTimestamp(), (long)o2.getTimestamp());
        Assert.assertEquals((Object)o1.getJid(), (Object)o2.getJid());
        Assert.assertEquals((Object)o1.getDescription(), (Object)o2.getDescription());
        Assert.assertEquals((Object)o1, (Object)o2);
    }

    @Test
    public void testToString() {
        DefaultTypesConverter converter = new DefaultTypesConverter();
        Assert.assertEquals((Object)"a1", (Object)converter.toString((Object)XT.a1));
        Assert.assertEquals((Object)"a1,a1,b2", (Object)converter.toString((Object)new XT[]{XT.a1, XT.a1, XT.b2}));
        Assert.assertEquals((Object)"a1,a1,b2", (Object)converter.toString((Object)new String[]{"a1", "a1", "b2"}));
        Assert.assertEquals((Object)"true,true,false,true", (Object)converter.toString((Object)new boolean[]{true, true, false, true}));
        Assert.assertEquals((Object)"1,2,3,4", (Object)converter.toString((Object)new char[]{'1', '2', '3', '4'}));
        Assert.assertEquals((Object)"1,2,3", (Object)converter.toString((Object)new byte[]{1, 2, 3}));
        Assert.assertEquals((Object)"1@b.c/a,2@b.c/a,3@b.c/a", (Object)converter.toString((Object)new JID[]{JID.jidInstanceNS((String)"1@b.c/a"), JID.jidInstanceNS((String)"2@b.c/a"), JID.jidInstanceNS((String)"3@b.c/a")}));
        Assert.assertEquals((Object)System.getProperty("java.home"), (Object)converter.toString((Object)new ConfigReader.PropertyVariable("java.home", null)));
        ConfigReader.CompositeVariable compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)"Java: ");
        compositeVariable.add('+', (Object)new ConfigReader.PropertyVariable("java.vendor", null));
        compositeVariable.add('+', (Object)" ");
        compositeVariable.add('+', (Object)new ConfigReader.PropertyVariable("java.version", null));
        Assert.assertEquals((Object)("Java: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version")), (Object)converter.toString((Object)compositeVariable));
        compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)5);
        compositeVariable.add('-', (Object)2);
        compositeVariable.add('*', (Object)60);
        compositeVariable.add('*', (Object)1000);
        Assert.assertEquals((Object)"-119995", (Object)converter.toString((Object)compositeVariable));
        compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)5);
        compositeVariable.add('*', (Object)60.0);
        compositeVariable.add('*', (Object)1000);
        Assert.assertEquals((Object)"300000.0", (Object)converter.toString((Object)compositeVariable));
    }

    public static enum XT {
        a1,
        b2,
        c3;

    }

    static class ParcelableObject
    implements TypesConverter.Parcelable {
        private String description;
        private String ip;
        private JID jid;
        private long timestamp;

        ParcelableObject() {
        }

        public String[] encodeToStrings() {
            return new String[]{this.ip, this.jid.toString(), Long.toString(this.timestamp), this.description};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParcelableObject that = (ParcelableObject)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            if (!this.description.equals(that.description)) {
                return false;
            }
            if (!this.ip.equals(that.ip)) {
                return false;
            }
            return this.jid.equals((Object)that.jid);
        }

        public void fillFromString(String[] encoded) {
            this.ip = encoded[0];
            this.jid = JID.jidInstanceNS((String)encoded[1]);
            this.timestamp = Long.valueOf(encoded[2]);
            this.description = encoded[3];
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public JID getJid() {
            return this.jid;
        }

        public void setJid(JID jid) {
            this.jid = jid;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + this.ip.hashCode();
            result = 31 * result + this.jid.hashCode();
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }
    }
}

