/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import tigase.io.SSLContextContainer;

public class SSLContextContainerTest {
    @Test
    public void testFind() {
        HashMap<String, String> domains = new HashMap<String, String>();
        domains.put("one.com", "one.com");
        domains.put("a.two.com", "a.two.com");
        domains.put("*.two.com", "*.two.com");
        Assert.assertEquals((Object)"one.com", (Object)SSLContextContainer.find(domains, (String)"one.com"));
        Assert.assertNull((Object)SSLContextContainer.find(domains, (String)"tone.com"));
        Assert.assertNull((Object)SSLContextContainer.find(domains, (String)"zero.com"));
        Assert.assertEquals((Object)"a.two.com", (Object)SSLContextContainer.find(domains, (String)"a.two.com"));
        Assert.assertEquals((Object)"*.two.com", (Object)SSLContextContainer.find(domains, (String)"b.two.com"));
        Assert.assertEquals((Object)"*.two.com", (Object)SSLContextContainer.find(domains, (String)"b.two.com"));
        Assert.assertNull((Object)SSLContextContainer.find(domains, (String)"btwo.com"));
        Assert.assertEquals((Object)"*.two.com", (Object)SSLContextContainer.find(domains, (String)".two.com"));
    }

    @Test
    public void testRemoveMatched() {
        HashMap<String, String> contexts = new HashMap<String, String>();
        contexts.put("one.com", "one.com");
        contexts.put("push.one.com", "push.one.com");
        contexts.put("sub.push.one.com", "sub.push.one.com");
        contexts.put("*.one.com", "*.one.com");
        contexts.put("a.two.com", "a.two.com");
        contexts.put("*.two.com", "*.two.com");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("one.com", "*.one.com", "two.com"));
        SSLContextContainer.removeMatchedDomains(contexts, domains);
        Assert.assertFalse((boolean)contexts.containsKey("one.com"));
        Assert.assertFalse((boolean)contexts.containsKey("push.one.com"));
        Assert.assertTrue((boolean)contexts.containsKey("sub.push.one.com"));
        Assert.assertFalse((boolean)contexts.containsKey("*.one.com"));
        Assert.assertTrue((boolean)contexts.containsKey("a.two.com"));
        Assert.assertTrue((boolean)contexts.containsKey("*.two.com"));
    }
}

