/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemExtensionBackwardCompatible;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.xml.Element;
import tigase.xmpp.XMPPIOService;

@Bean(name="client-trust-manager-factory", parent=ClientConnectionManager.class, active=true)
public class ClientTrustManagerFactory {
    public static final String CA_CERT_PATH = "clientCertCA";
    public static final String CERT_REQUIRED_KEY = "clientCertRequired";
    private static final char[] EMPTY_PASS = new char[0];
    private static final Logger log = Logger.getLogger(ClientTrustManagerFactory.class.getName());
    private final ArrayList<X509Certificate> acceptedIssuers = new ArrayList();
    protected final TrustManager[] emptyTrustManager;
    private final KeyStore keystore;
    private final ConcurrentHashMap<VHostItem, TrustManager[]> trustManagers = new ConcurrentHashMap();
    @ConfigField(desc="CA for client certificate", alias="clientCertCA")
    private String clientCertCA;
    @ConfigField(desc="Is client certificate required")
    private boolean clientCertRequired = false;
    protected TrustManager[] defaultTrustManagers;
    private TrustManagerFactory tmf;

    public ClientTrustManagerFactory() {
        this.emptyTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keystore.load(null, EMPTY_PASS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void setClientCertCA(String clientCertCA) {
        this.clientCertCA = clientCertCA;
        this.defaultTrustManagers = clientCertCA != null ? this.loadTrustedCert(clientCertCA) : null;
    }

    public TrustManager[] getManager(VHostItem vHost) {
        String vhostKey;
        TrustManager[] result = this.trustManagers.get(vHost);
        String string = vhostKey = vHost != null ? vHost.getKey() : "null";
        if (result == null) {
            TrustManager[] tmp;
            String path;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Creating new TrustManager for VHost " + vhostKey);
            }
            result = this.defaultTrustManagers;
            ClientTrustVHostItemExtension extension = vHost.getExtension(ClientTrustVHostItemExtension.class);
            String string2 = path = extension != null ? extension.getCaCertPath() : null;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("CA cert path=" + path + " for VHost " + vhostKey);
            }
            if (path != null && (tmp = this.loadTrustedCert(path)) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Using custom TrustManager for VHost " + vhostKey);
                }
                result = tmp;
                this.trustManagers.put(vHost, result);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Found TrustManager for VHost " + vhostKey);
        }
        return result;
    }

    public TrustManager[] getManager(XMPPIOService<Object> serv) {
        return this.isActive() ? this.emptyTrustManager : null;
    }

    public boolean isActive() {
        return this.acceptedIssuers.size() > 0;
    }

    public boolean isTlsNeedClientAuthEnabled(VHostItem vhost) {
        ClientTrustVHostItemExtension extension = vhost.getExtension(ClientTrustVHostItemExtension.class);
        if (extension == null || extension.isCertRequired() == null) {
            return this.clientCertRequired;
        }
        return extension.isCertRequired();
    }

    public boolean isTlsWantClientAuthEnabled(VHostItem vhost) {
        TrustManager[] tmp = this.getManager(vhost);
        return tmp != null && tmp.length > 0;
    }

    protected X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers.toArray(new X509Certificate[0]);
    }

    protected TrustManager[] loadTrustedCert(String caCertFile) {
        try {
            CertificateEntry certEntry = CertificateUtil.loadCertificate((String)caCertFile);
            Object[] chain = certEntry.getCertChain();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Loaded certificate from file " + caCertFile + " : " + certEntry);
            }
            if (chain != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Loaded cert chain: " + Arrays.toString(chain));
                }
                for (Object cert : chain) {
                    if (!(cert instanceof X509Certificate)) continue;
                    X509Certificate crt = (X509Certificate)cert;
                    String alias = crt.getSubjectX500Principal().getName();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Adding certificate to keystore: alias=" + alias + "; cert=" + crt);
                    }
                    this.keystore.setCertificateEntry(alias, crt);
                    this.acceptedIssuers.add(crt);
                }
            }
            this.tmf.init(this.keystore);
            return this.tmf.getTrustManagers();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can''t create TrustManager with certificate from file.", e);
            throw new RuntimeException(e);
        }
    }

    public static class ClientTrustVHostItemExtension
    extends AbstractVHostItemExtension<ClientTrustVHostItemExtension>
    implements VHostItemExtensionBackwardCompatible<ClientTrustVHostItemExtension> {
        protected static final String ID = "client-trust-extension";
        public static final String CA_CERT_PATH = "ca-cert-path";
        public static final String CERT_REQUIRED = "cert-required";
        private String caCertPath;
        private Boolean certRequired = null;

        @Override
        public String getId() {
            return ID;
        }

        public String getCaCertPath() {
            return this.caCertPath;
        }

        public Boolean isCertRequired() {
            return this.certRequired;
        }

        @Override
        public void initFromElement(Element item) {
            this.caCertPath = item.getAttributeStaticStr(CA_CERT_PATH);
            this.certRequired = Optional.ofNullable(item.getAttributeStaticStr(CERT_REQUIRED)).map(Boolean::parseBoolean).orElse(null);
        }

        @Override
        public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
            this.caCertPath = Optional.ofNullable(Command.getFieldValue(packet, prefix + "-ca-cert-path")).filter(s -> !s.isEmpty()).orElse(null);
            this.certRequired = Optional.ofNullable(Command.getFieldValue(packet, prefix + "-cert-required")).map(s -> s.isEmpty() ? null : s).map(Boolean::parseBoolean).orElse(null);
        }

        @Override
        public String toDebugString() {
            return "caCertPath: " + this.caCertPath + ", certRequired: " + this.certRequired;
        }

        @Override
        public Element toElement() {
            if (this.caCertPath != null && !this.caCertPath.isEmpty() || this.certRequired != null) {
                Element el = new Element(this.getId());
                if (this.caCertPath != null) {
                    el.addAttribute(CA_CERT_PATH, this.caCertPath);
                }
                if (this.certRequired != null) {
                    el.addAttribute(CERT_REQUIRED, String.valueOf(this.certRequired));
                }
                return el;
            }
            return null;
        }

        @Override
        public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
            Element commandEl = packet.getElemChild("command", "http://jabber.org/protocol/commands");
            DataForm.addFieldValue(commandEl, prefix + "-ca-cert-path", this.caCertPath, "text-single", "Client Certificate CA");
            this.addBooleanFieldWithDefaultToCommand(commandEl, prefix + "-cert-required", "Client Certificate Required", this.certRequired, forDefault);
        }

        @Override
        public void initFromData(Map<String, Object> data) {
            this.caCertPath = (String)data.remove(ClientTrustManagerFactory.CA_CERT_PATH);
            this.certRequired = (Boolean)data.remove(ClientTrustManagerFactory.CERT_REQUIRED_KEY);
        }

        @Override
        public ClientTrustVHostItemExtension mergeWithDefaults(ClientTrustVHostItemExtension defaults) {
            return this;
        }
    }

    @Bean(name="client-trust-extension", parent=VHostItemExtensionManager.class, active=true)
    public static class ClientTrustVHostItemExtensionProvider
    implements VHostItemExtensionProvider<ClientTrustVHostItemExtension> {
        @Override
        public String getId() {
            return "client-trust-extension";
        }

        @Override
        public Class<ClientTrustVHostItemExtension> getExtensionClazz() {
            return ClientTrustVHostItemExtension.class;
        }
    }
}

