/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.db.TigaseDBException;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.BlockingCommand;
import tigase.xmpp.impl.JabberIqPrivacy;
import tigase.xmpp.impl.Privacy;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.JID;

public class BlockingCommandTest
extends ProcessorTestCase {
    private BlockingCommand blockingCommand;
    private JabberIqPrivacy privacy;
    private ArrayDeque<Packet> results;
    private RosterAbstract roster_util;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getInstance(RosterFactory.Bean.class);
        this.blockingCommand = this.getInstance(BlockingCommand.class);
        this.privacy = this.getInstance(JabberIqPrivacy.class);
        this.roster_util = RosterFactory.getRosterImplementation((boolean)true);
        this.results = new ArrayDeque();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.roster_util.setEventBus(null);
        this.blockingCommand = null;
    }

    @Test
    public void testEmptyJID() throws TigaseStringprepException, XMPPException {
        JID connJid = JID.jidInstanceNS((String)"c2s@example.com/test-111");
        JID userJid = JID.jidInstanceNS((String)"user-1@example.com/res-1");
        Element iq = new Element("iq", new String[]{"type"}, new String[]{"set"});
        Element block = new Element("block", new String[]{"xmlns"}, new String[]{"urn:xmpp:blocking"});
        Element item = new Element("item", new String[]{"jid"}, new String[]{""});
        block.addChild((XMLNodeIfc)item);
        iq.addChild((XMLNodeIfc)block);
        Packet p = Packet.packetInstance((Element)iq, (JID)userJid, (JID)userJid);
        XMPPResourceConnection sess = this.getSession(connJid, userJid);
        this.blockingCommand.process(p, sess, null, this.results, null);
        Assert.assertEquals((long)1L, (long)this.results.size());
        Packet result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.error, (Object)result.getType());
    }

    @Test
    public void testBlockUnblock() throws Exception {
        JID connJid = JID.jidInstanceNS((String)"c2s@example.com/test-111");
        JID userJid = JID.jidInstanceNS((String)"user-1@example.com/res-1");
        XMPPResourceConnection sess = this.getSession(connJid, userJid);
        String blockJid = "block-1@example.com";
        this.checkPrivacyJidBlocked(sess, blockJid, false);
        List<String> blocked = this.getBlocked(sess);
        Assert.assertTrue((blocked == null || blocked.isEmpty() ? 1 : 0) != 0);
        this.block(sess, blockJid);
        Assert.assertEquals((long)2L, (long)this.results.size());
        this.privacy.filter(null, sess, null, this.results);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Packet result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        this.checkPrivacyJidBlocked(sess, blockJid, true);
        blocked = this.getBlocked(sess);
        Assert.assertTrue((boolean)blocked.contains(blockJid));
        this.unblock(sess, blockJid);
        Assert.assertEquals((long)2L, (long)this.results.size());
        this.privacy.filter(null, sess, null, this.results);
        Assert.assertEquals((long)2L, (long)this.results.size());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        this.checkPrivacyJidBlocked(sess, blockJid, false);
        blocked = this.getBlocked(sess);
        Assert.assertTrue((blocked == null || blocked.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testBlockUnblockAll() throws Exception {
        JID connJid = JID.jidInstanceNS((String)"c2s@example.com/test-111");
        JID userJid = JID.jidInstanceNS((String)"user-1@example.com/res-1");
        XMPPResourceConnection sess = this.getSession(connJid, userJid);
        String blockJid = "block-1@example.com";
        this.checkPrivacyJidBlocked(sess, blockJid, false);
        List<String> blocked = this.getBlocked(sess);
        Assert.assertTrue((blocked == null || blocked.isEmpty() ? 1 : 0) != 0);
        this.block(sess, blockJid);
        Assert.assertEquals((long)2L, (long)this.results.size());
        this.privacy.filter(null, sess, null, this.results);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Packet result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        this.checkPrivacyJidBlocked(sess, blockJid, true);
        blocked = this.getBlocked(sess);
        Assert.assertTrue((boolean)blocked.contains(blockJid));
        this.unblock(sess, blockJid);
        Assert.assertEquals((long)2L, (long)this.results.size());
        this.privacy.filter(null, sess, null, this.results);
        Assert.assertEquals((long)2L, (long)this.results.size());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        this.checkPrivacyJidBlocked(sess, blockJid, false);
        blocked = this.getBlocked(sess);
        Assert.assertTrue((blocked == null || blocked.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testBlockUnblockWithPresence() throws Exception {
        JID connJid = JID.jidInstanceNS((String)"c2s@example.com/test-111");
        JID userJid = JID.jidInstanceNS((String)"user-1@example.com/res-1");
        XMPPResourceConnection sess = this.getSession(connJid, userJid);
        String blockJid = "block-1@example.com";
        this.roster_util.addBuddy(sess, JID.jidInstance((String)blockJid), "Block-1", null, null, null);
        this.roster_util.setBuddySubscription(sess, RosterAbstract.SubscriptionType.both, JID.jidInstance((String)blockJid));
        this.checkPrivacyJidBlocked(sess, blockJid, false);
        List<String> blocked = this.getBlocked(sess);
        Assert.assertTrue((blocked == null || blocked.isEmpty() ? 1 : 0) != 0);
        this.block(sess, blockJid);
        Assert.assertEquals((long)3L, (long)this.results.size());
        this.privacy.filter(null, sess, null, this.results);
        Assert.assertEquals((long)3L, (long)this.results.size());
        Packet result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"presence", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.unavailable, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        this.checkPrivacyJidBlocked(sess, blockJid, true);
        blocked = this.getBlocked(sess);
        Assert.assertTrue((boolean)blocked.contains(blockJid));
        this.unblock(sess, blockJid);
        Assert.assertEquals((long)3L, (long)this.results.size());
        this.privacy.filter(null, sess, null, this.results);
        Assert.assertEquals((long)3L, (long)this.results.size());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"presence", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.probe, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        result = this.results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        this.checkPrivacyJidBlocked(sess, blockJid, false);
        blocked = this.getBlocked(sess);
        Assert.assertTrue((blocked == null || blocked.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean(RosterFactory.Bean.class).setActive(true).exec();
        kernel.registerBean(JabberIqPrivacy.class).setActive(true).exec();
        kernel.registerBean(BlockingCommand.class).setActive(true).exec();
    }

    private void block(XMPPResourceConnection sess, String jid) throws Exception {
        Element iq = new Element("iq", new String[]{"type"}, new String[]{"set"});
        Element block = new Element("block", new String[]{"xmlns"}, new String[]{"urn:xmpp:blocking"});
        Element item = new Element("item", new String[]{"jid"}, new String[]{jid});
        block.addChild((XMLNodeIfc)item);
        iq.addChild((XMLNodeIfc)block);
        Packet p = Packet.packetInstance((Element)iq);
        this.blockingCommand.process(p, sess, null, this.results, null);
    }

    private void unblock(XMPPResourceConnection sess, String jid) throws Exception {
        Element iq = new Element("iq", new String[]{"type"}, new String[]{"set"});
        Element block = new Element("unblock", new String[]{"xmlns"}, new String[]{"urn:xmpp:blocking"});
        Element item = new Element("item", new String[]{"jid"}, new String[]{jid});
        block.addChild((XMLNodeIfc)item);
        iq.addChild((XMLNodeIfc)block);
        Packet p = Packet.packetInstance((Element)iq);
        this.blockingCommand.process(p, sess, null, this.results, null);
    }

    private void unblockAll(XMPPResourceConnection sess) throws Exception {
        Element iq = new Element("iq", new String[]{"type"}, new String[]{"set"});
        Element block = new Element("unblock", new String[]{"xmlns"}, new String[]{"urn:xmpp:blocking"});
        iq.addChild((XMLNodeIfc)block);
        Packet p = Packet.packetInstance((Element)iq);
        this.blockingCommand.process(p, sess, null, this.results, null);
    }

    private void checkPrivacyJidBlocked(XMPPResourceConnection sess, String jid, boolean value) throws NotAuthorizedException, TigaseDBException {
        List blocked = Privacy.getBlocked((XMPPResourceConnection)sess);
        if (value) {
            Assert.assertTrue((blocked != null && blocked.contains(jid) ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((blocked == null || !blocked.contains(jid) ? 1 : 0) != 0);
        }
    }

    private List<String> getBlocked(XMPPResourceConnection sess) throws XMPPException, TigaseStringprepException {
        Element iq = new Element("iq", new String[]{"type"}, new String[]{"get"});
        Element blocklist = new Element("blocklist", new String[]{"xmlns"}, new String[]{"urn:xmpp:blocking"});
        iq.addChild((XMLNodeIfc)blocklist);
        Packet p = Packet.packetInstance((Element)iq);
        this.blockingCommand.process(p, sess, null, this.results, null);
        Assert.assertEquals((long)1L, (long)this.results.size());
        Packet result = this.results.poll();
        Assert.assertEquals((Object)"iq", (Object)result.getElemName());
        return result.getElement().getChild("blocklist").mapChildren(c -> c.getName() == "item", c -> c.getAttributeStaticStr("jid"));
    }
}

