/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.db.NonAuthUserRepository;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class XMPPProcessorAbstractTest
extends ProcessorTestCase {
    JID connId = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
    String domain = "domain";
    JID recipient = JID.jidInstanceNS((String)"recipient", (String)this.domain, (String)"resource");
    JID sender = JID.jidInstanceNS((String)"sender", (String)this.domain, (String)"resource");
    private XMPPProcessorAbstract processor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.processor = new SimpleXMPPProcessor();
    }

    @Test
    public void testProcessToUserPacketWithSession() throws TigaseStringprepException, PacketErrorTypeException, NotAuthorizedException {
        Iq iq = this.getIqPacket();
        ArrayDeque results = new ArrayDeque();
        XMPPResourceConnection session = this.getSession(this.connId, this.recipient, true);
        this.processor.processToUserPacket((Packet)iq, session, null, results, null);
        Assert.assertFalse((boolean)results.isEmpty());
        Assert.assertEquals((Object)((Packet)results.poll()).getType(), (Object)StanzaType.result);
    }

    @Test
    public void testProcessToUserPacketWithoutSession() throws TigaseStringprepException, PacketErrorTypeException, NotAuthorizedException {
        Iq iq = this.getIqPacket();
        ArrayDeque results = new ArrayDeque();
        XMPPResourceConnection emptySession = this.getSession(this.connId, this.recipient, false);
        this.processor.processToUserPacket((Packet)iq, emptySession, null, results, null);
        Assert.assertTrue((boolean)results.isEmpty());
    }

    private Iq getIqPacket() throws TigaseStringprepException {
        Element iqElement = new Element("iq").withAttribute("type", StanzaType.result.toString()).withAttribute("from", this.sender.toString()).withAttribute("to", this.recipient.toString());
        iqElement.addChild((XMLNodeIfc)new Element("ping").withAttribute("xmlns", "urn:xmpp:ping"));
        return new Iq(iqElement);
    }

    private static class SimpleXMPPProcessor
    extends XMPPProcessorAbstract {
        private SimpleXMPPProcessor() {
        }

        public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        }

        public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        }
    }
}

