/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.server.bosh.BoshIOService;

public class BoshIOServiceTest
extends TestCase {
    private BoshIOService boshIOService;

    @Before
    public void setUp() throws Exception {
        this.boshIOService = new BoshIOService(null);
    }

    @Test
    public void testGetCharset() {
        String c1 = "text/xml; charset=utf-8";
        BoshIOServiceTest.assertEquals((String)"utf-8", (String)this.boshIOService.getCharset(c1));
        String c2 = "text/xml; charset=";
        BoshIOServiceTest.assertEquals((String)"", (String)this.boshIOService.getCharset(c2));
        String c3 = "text/xml; charset=badEncoding";
        BoshIOServiceTest.assertEquals((String)"badEncoding", (String)this.boshIOService.getCharset(c3));
        String c4 = "text/xml; xxx=yy";
        BoshIOServiceTest.assertEquals(null, (String)this.boshIOService.getCharset(c4));
        String c5 = null;
        BoshIOServiceTest.assertEquals(null, (String)this.boshIOService.getCharset(c5));
        String c6 = "  ";
        BoshIOServiceTest.assertEquals(null, (String)this.boshIOService.getCharset(c6));
        String c7 = " ; ";
        BoshIOServiceTest.assertEquals(null, (String)this.boshIOService.getCharset(c7));
    }

    @Test
    public void testGetDataLength() {
        String data = "Information:javac 11.0.5";
        BoshIOServiceTest.assertEquals((int)this.boshIOService.getDataLength(data, "text/xml; charset=utf-8"), (int)24);
        BoshIOServiceTest.assertEquals((int)this.boshIOService.getDataLength(data, "text/xml; charset=GBK"), (int)24);
        BoshIOServiceTest.assertEquals((int)this.boshIOService.getDataLength(data, "text/xml; charset=badEncoding"), (int)24);
        BoshIOServiceTest.assertEquals((int)this.boshIOService.getDataLength(data, "text/xml; charset="), (int)24);
        BoshIOServiceTest.assertEquals((int)this.boshIOService.getDataLength(data, "text/xml; xxx=yy"), (int)24);
        String chineseData = data + "\u4e2d\u6587\u5b57\u7b26";
        int charLength = 28;
        BoshIOServiceTest.assertTrue((this.boshIOService.getDataLength(chineseData, "text/xml; charset=utf-8") != charLength ? 1 : 0) != 0);
        BoshIOServiceTest.assertTrue((this.boshIOService.getDataLength(chineseData, "text/xml; charset=utf-8") == charLength + 8 ? 1 : 0) != 0);
        BoshIOServiceTest.assertTrue((this.boshIOService.getDataLength(chineseData, "text/xml; charset=GBK") != charLength + 8 ? 1 : 0) != 0);
        BoshIOServiceTest.assertTrue((this.boshIOService.getDataLength(chineseData, "text/xml; charset=GBK") == charLength + 4 ? 1 : 0) != 0);
        BoshIOServiceTest.assertTrue((this.boshIOService.getDataLength(chineseData, "text/xml; charset=ISO-8859-1") == charLength ? 1 : 0) != 0);
        int dataLength = this.boshIOService.getDataLength(chineseData, "text/xml;");
        BoshIOServiceTest.assertTrue((boolean)(Charset.defaultCharset().equals(StandardCharsets.UTF_8) ? dataLength == charLength + 8 : (Charset.defaultCharset().equals(Charset.forName("GBK")) ? dataLength == charLength + 4 : dataLength == charLength)));
    }
}

