/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.kernel.AbstractKernelTestCase;

public class AbstractDataSourceTestCase<DS extends DataSource>
extends AbstractKernelTestCase {
    protected static String uri = System.getProperty("testDbUri");
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private DS dataSource;

    @AfterClass
    public static void cleanDerby() {
        File f;
        if (uri.contains("jdbc:derby:") && (f = new File("derby_test")).exists()) {
            if (f.listFiles() != null) {
                Arrays.asList(f.listFiles()).forEach(f2 -> {
                    if (f2.listFiles() != null) {
                        Arrays.asList(f2.listFiles()).forEach(f3 -> f3.delete());
                    }
                    f2.delete();
                });
            }
            f.delete();
        }
    }

    protected static void loadSchema(String schemaId, String schemaVersion, Set<String> components) throws DBInitException {
        SchemaLoader loader = SchemaLoader.newInstanceForURI((String)uri);
        SchemaLoader.Parameters params = loader.createParameters();
        params.parseUri(uri);
        params.setDbRootCredentials(null, null);
        params.setSchemaDirectory("src/main/database/");
        loader.init(params, Optional.empty());
        loader.validateDBConnection();
        loader.validateDBExists();
        Assert.assertNotEquals((Object)SchemaLoader.Result.error, (Object)loader.loadCommonSchema());
        Optional schemaInfo = SchemaManager.getDefaultSchemaFor((String)uri, (String)schemaId, components);
        Assert.assertNotEquals((Object)SchemaLoader.Result.error, (Object)loader.loadSchema((SchemaManager.SchemaInfo)schemaInfo.get(), schemaVersion));
        loader.postInstallation();
        loader.shutdown();
    }

    protected DS getDataSource() {
        return this.dataSource;
    }

    @Before
    public void setupDataSource() throws Exception {
        this.dataSource = this.prepareDataSource();
        this.getKernel().registerBean("dataSource").asInstance(this.dataSource).setPinned(false).exportable().exec();
    }

    protected DS prepareDataSource() throws DBInitException, IllegalAccessException, InstantiationException {
        DataSource dataSource = (DataSource)DataSourceHelper.getDefaultClass(DataSource.class, (String)uri).newInstance();
        dataSource.initRepository(uri, new HashMap());
        return (DS)dataSource;
    }
}

