/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.monitor.tasks.TasksEvent;
import tigase.util.common.OSUtils;
import tigase.util.datetime.TimestampHelper;

@Bean(name="disk-task", parent=MonitorComponent.class, active=true)
public class DiskTask
extends AbstractConfigurableTimerTask
implements Initializable {
    public static final String DISK_USAGE_MONITOR_EVENT_NAME = "tigase.monitor.tasks.DiskUsageMonitorEvent";
    protected static final TimestampHelper dtf = new TimestampHelper();
    private static final Logger log = Logger.getLogger(DiskTask.class.getName());
    @Inject
    protected MonitorComponent component;
    @Inject
    protected EventBus eventBus;
    @ConfigField(desc="Disk usage threshold")
    protected float threshold = 0.8f;
    private File[] roots;
    private boolean triggered = false;

    public DiskTask() {
        this.setPeriod(60000L);
    }

    @Override
    public Form getCurrentConfiguration() {
        Form x = super.getCurrentConfiguration();
        x.addField(Field.fieldTextSingle((String)"threshold", (String)("" + this.threshold), (String)"Disk usage ratio threshold"));
        return x;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(DiskUsageEvent.class, "Fired if disk usage is too high", false);
        this.findAllRoots();
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field diskUsageField = form.get("threshold");
        if (diskUsageField != null) {
            this.threshold = Float.parseFloat(diskUsageField.getValue());
        }
        super.setNewConfiguration(form);
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold.floatValue();
    }

    @Override
    protected void run() {
        for (File file : this.roots) {
            if ((float)file.getUsableSpace() < (float)file.getTotalSpace() * (1.0f - this.threshold)) {
                DiskUsageEvent event = new DiskUsageEvent(file.toString(), file.getUsableSpace(), file.getTotalSpace());
                if (this.triggered) continue;
                this.eventBus.fire(event);
                this.triggered = true;
                continue;
            }
            this.triggered = false;
        }
    }

    private void findAllRoots() {
        switch (OSUtils.getOSType()) {
            case windows: {
                File[] winRoots = File.listRoots();
                this.roots = winRoots;
                break;
            }
            case linux: {
                File[] linRoots = this.getLinuxRoots();
                this.roots = linRoots;
                break;
            }
            case sunos: 
            case solaris: {
                File[] solRoots = this.getSolarisRoots();
                this.roots = solRoots;
                break;
            }
            case mac: {
                File[] macRoots = this.getMacRoots();
                this.roots = macRoots;
                break;
            }
            default: {
                File[] otherRoots = File.listRoots();
                if (otherRoots.length != 1) break;
                File[] mtabRoots = this.getLinuxRoots();
                if (mtabRoots != null && mtabRoots.length > 1) {
                    otherRoots = mtabRoots;
                }
                this.roots = otherRoots;
            }
        }
    }

    private File[] getLinuxRoots() {
        try {
            String mtab = "/etc/mtab";
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Reading mtab: " + mtab);
            }
            BufferedReader buffr = new BufferedReader(new FileReader(mtab));
            String line = null;
            ArrayList<File> results = new ArrayList<File>();
            while ((line = buffr.readLine()) != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Analyzing line: " + line);
                }
                if (line.contains("proc") || line.contains("devfs") || line.contains("tmpfs") || line.contains("sysfs") || line.contains("devpts") || line.contains("securityfs")) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("Found virtual fs line, omitting...");
                    continue;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Splitting line...");
                }
                String[] parts = line.split("\\s");
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Found file system: " + parts[1]);
                }
                results.add(new File(parts[1]));
            }
            return results.toArray(new File[results.size()]);
        }
        catch (Exception e) {
            log.warning("Can not read filesystems from /etc/mtab file" + e);
            return File.listRoots();
        }
    }

    private File[] getMacRoots() {
        File volumes = new File("/Volumes");
        return volumes.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
    }

    private File[] getSolarisRoots() {
        return File.listRoots();
    }

    static class DiskUsageEvent
    extends TasksEvent {
        String root;
        long totalSpace;
        long usableSpace;

        public DiskUsageEvent(String name, String description) {
            super(name, description);
        }

        public DiskUsageEvent(String root, long usableSpace, long totalSpace) {
            super("DiskUsageEvent", "Fired if disk usage is too high");
            this.root = root;
            this.usableSpace = usableSpace;
            this.totalSpace = totalSpace;
        }

        @Override
        public Map<String, String> getAdditionalData() {
            return Map.of("root", this.root, "usableSpace", "" + this.usableSpace, "totalSpace", "" + this.totalSpace);
        }
    }
}

