/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigFieldType;
import tigase.kernel.core.Kernel;

public class DSLBeanConfiguratorTest {
    @Test
    public void dumpConfiguration() throws IOException {
        Kernel kernel = new Kernel();
        kernel.registerBean(DefaultTypesConverter.class).exec();
        kernel.registerBean(DSLBeanConfigurator.class).exec();
        HashMap props = new HashMap();
        HashMap<String, String> testBeanProps = new HashMap<String, String>();
        String plainFieldValue = "PlainFieldValue";
        String jdbcUrlPassword = "tigase_password";
        testBeanProps.put("plainConfigField", "PlainFieldValue");
        testBeanProps.put("jdbcUrl", "jdbc:postgresql://localhost/tigasedb?user=tigasedb&password=tigase_password&useSSL=false");
        String passwordFieldValue = "PasswordFieldValue";
        testBeanProps.put("passwordField", "PasswordFieldValue");
        props.put("TestBean", testBeanProps);
        DSLBeanConfigurator configurator = (DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class);
        configurator.setProperties(props);
        kernel.registerBean(TestBean.class).exec();
        StringWriter stringWriter = new StringWriter();
        configurator.dumpConfiguration((Writer)stringWriter);
        System.out.println(stringWriter);
        Assert.assertTrue((boolean)stringWriter.toString().contains("PlainFieldValue"));
        Assert.assertFalse((boolean)stringWriter.toString().contains("tigase_password"));
        Assert.assertFalse((boolean)stringWriter.toString().contains("PasswordFieldValue"));
    }

    @Bean(name="TestBean", active=true, parent=Kernel.class)
    public static class TestBean {
        @ConfigField(desc="JDBC URL field that should have only password obfuscated", type=ConfigFieldType.JdbcUrl)
        String jdbcUrl;
        @ConfigField(desc="Password field that should be completely obfuscated", type=ConfigFieldType.Password)
        String passwordField;
        @ConfigField(desc="Plain field without obfuscation")
        String plainConfigField;
    }
}

