/*
 * Tigase XMPP Server - The instant messaging server
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.server.xmppclient;

import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;

import java.io.IOException;

/**
 * @author andrzej
 */
public interface XMPPIOProcessor {

	/**
	 * Returns identifier of processor
	 */
	String getId();

	/**
	 * Returns statistics generated by this processor
	 *
	 */
	void getStatistics(StatisticsList list);

	/**
	 * Returns array of features added by this processor
	 *
	 */
	Element[] supStreamFeatures(XMPPIOService service);

	/**
	 * Process packets read from socket as they are sent to SessionManager.
	 * @return true if packet should not be forwarded
	 */
	boolean processIncoming(XMPPIOService service, Packet packet);

	/**
	 * Process outgoing packets as they are added to XMPPIOService outgoing packets queue.
	 * @return true if packet should be removed
	 */
	boolean processOutgoing(XMPPIOService service, Packet packet);

	/**
	 * Method is called when all waiting data was written to socket.
	 */
	void packetsSent(XMPPIOService service) throws IOException;

	/**
	 * Process command execution which may be sent from other component and should be processed by processor
	 *
	 */
	void processCommand(XMPPIOService service, Packet packet);

	/**
	 * Method called when XMPPIOService is closed.
	 * @return true if connecton manager should not be notified about stopping of this service
	 */
	boolean serviceStopped(XMPPIOService service, boolean streamClosed);

	/**
	 * Method called when XMPP stream error is about to be sent
	 *
	 */
	void streamError(XMPPIOService service, StreamError streamError);
}
