/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.ClientStateIndication;

@Bean(name="mobile_v1", parent=SessionManager.class, active=false)
public class MobileV1
extends XMPPProcessor
implements XMPPProcessorIfc,
ClientStateIndication.Logic {
    protected static final String ID = "mobile_v1";
    private static final int DEF_MAX_QUEUE_SIZE_VAL = 50;
    private static final long DEF_MAX_TIMEOUT_VAL = 360000L;
    private static final Logger log = Logger.getLogger(MobileV1.class.getCanonicalName());
    private static final String MAX_QUEUE_SIZE_KEY = "max-queue-size";
    private static final String MAX_TIMEOUT_KEY = "max-timeout";
    private static final String MOBILE_EL_NAME = "mobile";
    private static final String XMLNS = "http://tigase.org/protocol/mobile#v1";
    private static final String[][] ELEMENT_PATHS = new String[][]{{"iq", "mobile"}};
    private static final String[] XMLNSS = new String[]{"http://tigase.org/protocol/mobile#v1"};
    private static final String TIMEOUT_KEY = "mobile_v1-timeout";
    private static final Element[] SUP_FEATURES = new Element[]{new Element("mobile", new String[]{"xmlns"}, new String[]{"http://tigase.org/protocol/mobile#v1"})};
    private static final String QUEUE_KEY = "mobile_v1-queue";
    private static final String LAST_TRANSFER_KEY = "mobile_v1-last-transfer";
    @ConfigField(desc="Max queue size", alias="max-queue-size")
    private int maxQueueSize = 50;
    @ConfigField(desc="Max timeout", alias="max-timeout")
    private long maxTimeout = 360000L;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        try {
            StanzaType type = packet.getType();
            switch (type) {
                case set: {
                    boolean value;
                    Element el = packet.getElement().getChild(MOBILE_EL_NAME);
                    String valueStr = el.getAttributeStaticStr("enable");
                    boolean bl = value = valueStr != null && ("true".equals(valueStr) || "1".equals(valueStr));
                    if (el.getAttributeStaticStr("timeout") != null) {
                        long timeout = Long.parseLong(el.getAttributeStaticStr("timeout"));
                        this.setTimeout(session, timeout);
                    }
                    if (value) {
                        this.activate(session, results);
                    } else {
                        this.deactivate(session, results);
                    }
                    results.offer(packet.okResult((Element)null, 0));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Mobile processing type is incorrect", false));
                    break;
                }
            }
        }
        catch (PacketErrorTypeException ex) {
            Logger.getLogger(MobileV1.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null) {
            return null;
        }
        if (!session.isAuthorized()) {
            return null;
        }
        return SUP_FEATURES;
    }

    @Override
    public void activate(XMPPResourceConnection session, Queue<Packet> results) {
        if (session.getSessionData(QUEUE_KEY) == null) {
            session.putSessionDataIfAbsent(QUEUE_KEY, new LinkedBlockingQueue());
        }
        session.putSessionData(XMLNS, true);
    }

    @Override
    public void deactivate(XMPPResourceConnection session, Queue<Packet> results) {
        session.putSessionData(XMLNS, false);
        this.flushQueue(session, results);
    }

    @Override
    public void filter(Packet _packet, XMPPResourceConnection sessionFromSM, NonAuthUserRepository repo, Queue<Packet> results) {
        if (sessionFromSM == null || !sessionFromSM.isAuthorized() || results == null || results.size() == 0) {
            return;
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Packet p;
            Packet res = (Packet)it.next();
            if (res == null || res.getPacketTo() == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("packet without destination");
                continue;
            }
            XMPPSession parentSession = sessionFromSM.getParentSession();
            if (parentSession == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "no session for destination {0} for packet {1} - missing parent session", new Object[]{res.getPacketTo().toString(), res.toString()});
                continue;
            }
            XMPPResourceConnection session = parentSession.getResourceForConnectionId(res.getPacketTo());
            if (session == null) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "no session for destination {0} for packet {1}", new Object[]{res.getPacketTo().toString(), res.toString()});
                continue;
            }
            if (!this.isQueueEnabled(session)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("queue is no enabled");
                }
                this.flushQueue(session, results);
                continue;
            }
            Queue queue = (Queue)session.getSessionData(QUEUE_KEY);
            if (!this.filter(session, res, queue)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "queuing packet = {0}", res.toString());
            }
            it.remove();
            if (queue.size() <= this.maxQueueSize) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("sending packets from queue (OVERFLOW)");
            }
            while ((p = (Packet)queue.poll()) != null) {
                try {
                    p.setPacketTo(session.getConnectionId());
                    results.offer(p);
                }
                catch (NoConnectionIdException ex) {
                    log.log(Level.FINEST, "should not happen, as connection is ready", ex);
                }
            }
        }
    }

    public boolean filter(XMPPResourceConnection session, Packet res, Queue<Packet> queue) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "checking if packet should be queued {0}", res.toString());
        }
        if (res.getElemName() != "presence") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "ignoring packet, packet is not presence:  {0}", res.toString());
            }
            return false;
        }
        StanzaType type = res.getType();
        if (type != null && type != StanzaType.unavailable && type != StanzaType.available) {
            return false;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "queuing packet {0}", res.toString());
        }
        queue.offer(res);
        return true;
    }

    protected void flushQueue(XMPPResourceConnection session, Queue<Packet> results) {
        Queue queue = (Queue)session.getSessionData(QUEUE_KEY);
        if (queue != null && !queue.isEmpty()) {
            Packet p;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("sending packets from queue (DISABLED)");
            }
            while ((p = (Packet)queue.poll()) != null) {
                try {
                    p.setPacketTo(session.getConnectionId());
                    results.offer(p);
                }
                catch (NoConnectionIdException ex) {
                    log.log(Level.FINEST, "should not happen, as connection is ready", ex);
                }
            }
        }
    }

    protected boolean isQueueEnabled(XMPPResourceConnection session) {
        Boolean enabled = (Boolean)session.getSessionData(XMLNS);
        return enabled != null && enabled != false;
    }

    protected boolean isTimedOut(XMPPResourceConnection session) {
        Long lastAccessTime = (Long)session.getSessionData(LAST_TRANSFER_KEY);
        if (lastAccessTime == null) {
            return true;
        }
        return lastAccessTime + this.getTimeout(session) < System.currentTimeMillis();
    }

    protected void updateLastAccessTime(XMPPResourceConnection session) {
        session.putSessionData(LAST_TRANSFER_KEY, System.currentTimeMillis());
    }

    private long getTimeout(XMPPResourceConnection session) {
        Long timeout = (Long)session.getSessionData(TIMEOUT_KEY);
        if (timeout == null) {
            return this.maxTimeout;
        }
        return timeout;
    }

    private void setTimeout(XMPPResourceConnection session, long timeout) {
        if (timeout == 0L) {
            session.removeSessionData(TIMEOUT_KEY);
        } else {
            session.putSessionData(TIMEOUT_KEY, timeout);
        }
    }
}

