/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.script;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.AbstractScriptCommand;
import tigase.util.log.LogFormatter;

public class Script
extends AbstractScriptCommand {
    private static final Logger log = Logger.getLogger(Script.class.getName());
    private CompiledScript compiledScript = null;
    private String ext = null;
    private String language = null;
    private String script = null;
    private ScriptEngine scriptEngine = null;

    @Override
    public Bindings getBindings() {
        return this.scriptEngine.createBindings();
    }

    public String getFileExtension() {
        return this.ext;
    }

    public String getLanguageName() {
        return this.language;
    }

    public void init(String id, String description, String group, String script, String lang, String ext, Bindings binds) throws ScriptException {
        super.init(id, description, group);
        this.script = script;
        this.language = lang;
        this.ext = ext;
        ScriptEngineManager scriptEngineManager = (ScriptEngineManager)binds.get("scriptManager");
        log.log(Level.FINEST, "Trying to load admin command: {0}, description: {1}, language: {2}, ext: {3}", new Object[]{id, description, this.language, this.ext});
        if (this.language != null) {
            this.scriptEngine = scriptEngineManager.getEngineByName(this.language);
        }
        if (ext != null) {
            this.scriptEngine = scriptEngineManager.getEngineByExtension(ext);
        }
        if (!Packet.FULL_DEBUG && this.scriptEngine instanceof Compilable) {
            this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
        }
        if (this.language == null && this.scriptEngine != null) {
            this.language = this.scriptEngine.getFactory().getLanguageName();
        }
        if (this.ext == null && this.scriptEngine != null) {
            this.ext = this.scriptEngine.getFactory().getExtensions().get(0);
        }
        String THREADING = this.scriptEngine != null ? String.valueOf(this.scriptEngine.getFactory().getParameter("THREADING")) : null;
        log.log(Level.FINE, "Initialized script command, id: {0}, lang: {1}, ext: {2}, threading: {3}", new Object[]{id, this.language, this.ext, THREADING});
    }

    @Override
    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        SimpleScriptContext context = null;
        StringWriter writer = null;
        try {
            long start = System.currentTimeMillis();
            binds.put("packet", (Object)packet);
            Object res = "";
            binds.put("result", res);
            context = new SimpleScriptContext();
            context.setBindings(binds, 100);
            writer = new StringWriter();
            context.setErrorWriter(writer);
            res = this.compiledScript != null ? this.compiledScript.eval(context) : this.scriptEngine.eval(this.script, (ScriptContext)context);
            if (res == null && (res = binds.get("result")).toString().isEmpty() && (res = binds.get("packet")) == packet) {
                res = "Script finished with no errors but returned no results.";
            }
            if (res instanceof Packet) {
                results.offer((Packet)res);
            } else if (res instanceof Queue) {
                results.addAll((Queue)res);
            } else {
                Packet result = packet.commandResult(Command.DataType.result);
                String[] text = null;
                text = res != null ? res.toString().split("\n") : new String[]{"Script returned no results."};
                Command.addFieldMultiValue(result, "Script result", Arrays.asList(text));
                results.offer(result);
            }
            long end = System.currentTimeMillis();
            this.statisticExecutedIn(end - start);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Script execution error: " + e, e);
            Packet result = packet.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "Script execution error.");
            if (e.getMessage() != null) {
                Command.addTextField(result, "Error message", e.getMessage());
            }
            String stackTrace = LogFormatter.fillThrowable(e);
            Command.addFieldMultiValue(result, "Debug info", Collections.singletonList(stackTrace));
            results.offer(result);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Script{");
        sb.append("'").append(this.getGroup()).append(':').append(this.getCommandId()).append(':').append(this.language).append(':').append(this.getDescription()).append('\'');
        sb.append(", adminOnly=").append(this.isAdminOnly());
        sb.append(", stats='").append(this.getName()).append(':').append(this.getValue());
        sb.append('}');
        return sb.toString();
    }
}

