/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.ArrayDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.bosh.BoshConnectionManager;
import tigase.server.bosh.BoshSession;
import tigase.util.common.TimerTask;

public class BoshTask
extends TimerTask {
    private static final Logger log = Logger.getLogger(BoshTask.class.getName());
    protected long timerOrder = System.currentTimeMillis();
    private BoshSession bs = null;
    private BoshConnectionManager manager = null;

    public BoshTask(BoshSession bs, BoshConnectionManager manager) {
        this.bs = bs;
        this.manager = manager;
    }

    @Override
    public void run() {
        ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
        if (this.bs.task(out_results, this)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Closing session for BS task: " + this.bs.getSid());
            }
            this.manager.sessions.remove(this.bs.getSid());
        }
        this.manager.addOutPackets(out_results, this.bs);
    }
}

