/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.nio.ByteOrder;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import tigase.annotations.TigaseDeprecated;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.io.CertificateContainer;
import tigase.io.CertificateContainerIfc;
import tigase.io.IOInterface;
import tigase.io.JcaTLSWrapper;
import tigase.io.SSLContextContainerAbstract;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSEventHandler;
import tigase.io.TLSIO;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemExtensionBackwardCompatible;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;

@Bean(name="sslContextContainer", parent=ConnectionManager.class, active=true)
public class SSLContextContainer
extends SSLContextContainerAbstract
implements Initializable {
    private static final String EPHEMERAL_DH_KEYSIZE_KEY = "jdk.tls.ephemeralDHKeySize";
    private static final int EPHEMERAL_DH_KEYSIZE_VALUE = 4096;
    private static final String[] TLS_WORKAROUND_CIPHERS = new String[]{"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV", "TLS_RSA_WITH_AES_128_CBC_SHA"};
    private static final String[] HARDENED_SECURE_FORBIDDEN_CIPHERS = new String[]{"^.*(_(MD5|SHA1)$|RC4_.*$)", "^(TLS_RSA_WITH_AES.*$)"};
    private static final String[] HARDENED_STRICT_FORBIDDEN_CIPHERS = new String[]{"^.*_AES_128_.*$"};
    private static final String[] HARDENED_SECURE_FORBIDDEN_PROTOCOLS = new String[]{"SSL", "SSLv2", "SSLv3"};
    private static final String[] HARDENED_STRICT_FORBIDDEN_PROTOCOLS = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1"};
    private static final Logger log = Logger.getLogger(SSLContextContainer.class.getName());
    @Inject
    protected EventBus eventBus = EventBusFactory.getInstance();
    protected Map<String, SSLContextContainerAbstract.SSLHolder> sslContexts = new ConcurrentSkipListMap<String, SSLContextContainerAbstract.SSLHolder>();
    @Inject(nullAllowed=true)
    protected VHostManagerIfc vHostManager = null;
    Map<String, String[]> enabledCiphersMap = new ConcurrentHashMap<String, String[]>(3);
    Map<String, String[]> enabledProtocolsMap = new ConcurrentHashMap<String, String[]>(6);
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0", note="(temporarily) disable TLS 1.3 due to compatibility issues")
    @Deprecated
    @ConfigField(desc="Disable TLS 1.3", alias="tls-disable-tls13")
    private boolean disableTLS13 = true;
    @ConfigField(desc="Enabled TLS/SSL ciphers", alias="tls-disabled-ciphers")
    private String[] disabledCiphers;
    @ConfigField(desc="Enabled TLS/SSL protocols", alias="tls-disabled-protocols")
    private String[] disabledProtocols;
    @ConfigField(desc="Enabled TLS/SSL ciphers", alias="tls-enabled-ciphers")
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0", note="Control list of ciphers with `tls-disabled-ciphers`")
    @Deprecated
    private String[] enabledCiphers;
    @TigaseDeprecated(since="8.1.0", removeIn="9.0.0", note="Control list of protocols with `tls-disabled-protocols`")
    @Deprecated
    @ConfigField(desc="Enabled TLS/SSL protocols", alias="tls-enabled-protocols")
    private String[] enabledProtocols;
    @ConfigField(desc="Sets ephemeral DH Key Size", alias="ephemeral-key-size")
    private int ephemeralDHKeySize = 4096;
    @ConfigField(desc="TLS/SSL hardened mode", alias="hardened-mode")
    private HARDENED_MODE hardenedMode = HARDENED_MODE.secure;
    @Inject(bean="rootSslContextContainer", type=Root.class, nullAllowed=true)
    private SSLContextContainerIfc parent;
    @ConfigField(desc="TLS/SSL", alias="tls-jdk-nss-bug-workaround-active")
    private boolean tlsJdkNssBugWorkaround = false;

    private static String getKey(HARDENED_MODE mode, boolean client) {
        return (Object)((Object)mode) + (client ? "_client" : "");
    }

    private static String markEnabled(String[] enabled, String[] supported) {
        List<Object> en = enabled == null ? new ArrayList() : Arrays.asList(enabled);
        String result = "";
        if (supported != null) {
            for (int i = 0; i < supported.length; ++i) {
                String t = supported[i];
                result = result + (en.contains(t) ? "(+)" : "(-)");
                result = result + t;
                if (i + 1 >= supported.length) continue;
                result = result + ",";
            }
        }
        return result;
    }

    private static String[] subtractItemsFromCollection(String[] input, String[] itemsToRemove) {
        return (String[])Arrays.stream(input).filter(c -> !Arrays.stream(itemsToRemove).map(Pattern::compile).map(pat -> pat.matcher((CharSequence)c)).map(Matcher::matches).anyMatch(e -> e)).toArray(String[]::new);
    }

    public SSLContextContainer() {
        this(null, null);
    }

    public SSLContextContainer(CertificateContainerIfc certContainer) {
        this(certContainer, null);
    }

    public SSLContextContainer(CertificateContainerIfc certContainer, SSLContextContainerIfc parent) {
        super(certContainer);
        this.parent = parent;
    }

    @Override
    public IOInterface createIoInterface(String protocol, String local_hostname, String remote_hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth, ByteOrder byteOrder, TrustManager[] x509TrustManagers, TLSEventHandler eventHandler, IOInterface socketIO, CertificateContainerIfc certificateContainer) throws IOException {
        SSLContext sslContext = this.getSSLContext(protocol, local_hostname, clientMode, x509TrustManagers);
        JcaTLSWrapper wrapper = new JcaTLSWrapper(sslContext, eventHandler, remote_hostname, port, clientMode, wantClientAuth, needClientAuth, this.getEnabledCiphers(local_hostname), this.getEnabledProtocols(local_hostname, clientMode));
        return new TLSIO(socketIO, wrapper, byteOrder);
    }

    @Override
    public String[] getEnabledCiphers(String domain) {
        if (this.enabledCiphers != null && this.enabledCiphers.length != 0) {
            return this.enabledCiphers;
        }
        if (this.tlsJdkNssBugWorkaround) {
            return TLS_WORKAROUND_CIPHERS;
        }
        HARDENED_MODE mode = this.getHardenedMode(domain);
        String key = SSLContextContainer.getKey(mode, false);
        return this.enabledCiphersMap.get(key);
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Enabled ciphers: " + (enabledCiphers == null ? "default" : Arrays.toString(enabledCiphers)));
        }
        this.enabledCiphers = enabledCiphers;
    }

    @Override
    public String[] getEnabledProtocols(String domain, boolean client) {
        if (this.enabledProtocols != null && this.enabledProtocols.length != 0) {
            return this.enabledProtocols;
        }
        HARDENED_MODE mode = this.getHardenedMode(domain);
        String key = SSLContextContainer.getKey(mode, client);
        return this.enabledProtocolsMap.get(key);
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Enabled protocols: " + (enabledProtocols == null ? "default" : Arrays.toString(enabledProtocols)));
        }
        this.enabledProtocols = enabledProtocols;
    }

    public void setEphemeralDHKeySize(int ephemeralDHKeySize) {
        this.ephemeralDHKeySize = ephemeralDHKeySize;
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname, boolean clientMode, TrustManager[] tms) {
        SSLContextContainerAbstract.SSLHolder holder = null;
        String alias = hostname;
        try {
            if (tms == null) {
                if (this.parent != null) {
                    return this.parent.getSSLContext(protocol, hostname, clientMode, tms);
                }
                tms = this.getTrustManagers();
            }
            if (alias == null) {
                alias = this.getDefCertAlias();
            }
            if (!this.validateDomainCertificate(holder = SSLContextContainer.find(this.sslContexts, alias), alias)) {
                holder = null;
            }
            if (holder == null || !holder.isValid(tms)) {
                holder = this.createContextHolder(protocol, hostname, alias, clientMode, tms);
                if (clientMode) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Using SSLHolder: " + holder);
                    }
                    return holder.getSSLContext();
                }
                if (!this.validateDomainCertificate(holder, alias)) {
                    holder = this.createContextHolder(protocol, hostname, alias, clientMode, tms);
                }
                this.sslContexts.put(alias, holder);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSLContext for domain: " + alias + ", protocol: " + protocol, e);
            holder = null;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Using SSLHolder: " + holder);
        }
        return holder != null ? holder.getSSLContext() : null;
    }

    @Override
    public KeyStore getTrustStore() {
        KeyStore trustStore = super.getTrustStore();
        if (trustStore == null && this.parent != null) {
            trustStore = this.parent.getTrustStore();
        }
        return trustStore;
    }

    public void setHardenedMode(HARDENED_MODE hardenedMode) {
        this.hardenedMode = hardenedMode;
        if (HARDENED_MODE.relaxed.equals((Object)hardenedMode)) {
            System.clearProperty(EPHEMERAL_DH_KEYSIZE_KEY);
        }
    }

    public void setParent(SSLContextContainerIfc parent) {
        log.log(Level.FINE, "setting root = " + parent);
        this.parent = parent;
    }

    public void setTlsJdkNssBugWorkaround(boolean value) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Workaround for TLS/SSL bug is " + (value ? "enabled" : "disabled"));
        }
        this.tlsJdkNssBugWorkaround = value;
    }

    @Override
    public void initialize() {
        System.setProperty(EPHEMERAL_DH_KEYSIZE_KEY, String.valueOf(this.ephemeralDHKeySize));
        try {
            SSLContext sslContext = SSLContext.getDefault();
            SSLEngine tmpEngine = sslContext.createSSLEngine();
            tmpEngine.setUseClientMode(false);
            log.config("Supported protocols: " + SSLContextContainer.markEnabled(tmpEngine.getEnabledProtocols(), tmpEngine.getSupportedProtocols()));
            log.config("Supported ciphers: " + SSLContextContainer.markEnabled(tmpEngine.getEnabledCipherSuites(), tmpEngine.getSupportedCipherSuites()));
            Object[] TMP = this.disableTLS13 ? SSLContextContainer.subtractItemsFromCollection(tmpEngine.getEnabledProtocols(), new String[]{"TLSv1.3"}) : tmpEngine.getEnabledProtocols();
            if (this.disabledProtocols != null && this.disabledProtocols.length > 0) {
                TMP = SSLContextContainer.subtractItemsFromCollection((String[])TMP, this.disabledProtocols);
            }
            log.config("RELAXED protocols: " + Arrays.toString(TMP));
            this.enabledProtocolsMap.put(SSLContextContainer.getKey(HARDENED_MODE.relaxed, false), (String[])TMP);
            this.enabledProtocolsMap.put(SSLContextContainer.getKey(HARDENED_MODE.relaxed, true), SSLContextContainer.subtractItemsFromCollection((String[])TMP, new String[]{"SSLv2Hello"}));
            TMP = SSLContextContainer.subtractItemsFromCollection((String[])TMP, HARDENED_SECURE_FORBIDDEN_PROTOCOLS);
            log.config("SECURE protocols: " + Arrays.toString(TMP));
            this.enabledProtocolsMap.put(SSLContextContainer.getKey(HARDENED_MODE.secure, false), (String[])TMP);
            this.enabledProtocolsMap.put(SSLContextContainer.getKey(HARDENED_MODE.secure, true), SSLContextContainer.subtractItemsFromCollection((String[])TMP, new String[]{"SSLv2Hello"}));
            TMP = SSLContextContainer.subtractItemsFromCollection((String[])TMP, HARDENED_STRICT_FORBIDDEN_PROTOCOLS);
            log.config("STRICT protocols: " + Arrays.toString(TMP));
            this.enabledProtocolsMap.put(SSLContextContainer.getKey(HARDENED_MODE.strict, false), (String[])TMP);
            this.enabledProtocolsMap.put(SSLContextContainer.getKey(HARDENED_MODE.strict, true), SSLContextContainer.subtractItemsFromCollection((String[])TMP, new String[]{"SSLv2Hello"}));
            TMP = tmpEngine.getEnabledCipherSuites();
            if (this.disabledProtocols != null && this.disabledProtocols.length > 0) {
                TMP = SSLContextContainer.subtractItemsFromCollection((String[])TMP, this.disabledCiphers);
            }
            log.config("RELAXED ciphers: " + Arrays.toString(TMP));
            this.enabledCiphersMap.put(SSLContextContainer.getKey(HARDENED_MODE.relaxed, false), (String[])TMP);
            TMP = SSLContextContainer.subtractItemsFromCollection((String[])TMP, HARDENED_SECURE_FORBIDDEN_CIPHERS);
            log.config("SECURE ciphers: " + Arrays.toString(TMP));
            this.enabledCiphersMap.put(SSLContextContainer.getKey(HARDENED_MODE.secure, false), (String[])TMP);
            TMP = SSLContextContainer.subtractItemsFromCollection((String[])TMP, HARDENED_STRICT_FORBIDDEN_CIPHERS);
            log.config("STRICT ciphers: " + Arrays.toString(TMP));
            this.enabledCiphersMap.put(SSLContextContainer.getKey(HARDENED_MODE.strict, false), (String[])TMP);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.WARNING, "Can't determine supported protocols", e);
        }
    }

    @Override
    public void start() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void stop() {
        this.eventBus.unregisterAll(this);
    }

    private HARDENED_MODE getHardenedMode(String domain) {
        HardenedModeVHostItemExtension extension;
        VHostItem vHostItem;
        HARDENED_MODE mode = this.hardenedMode;
        if (domain != null && this.vHostManager != null && (vHostItem = this.vHostManager.getVHostItem(domain)) != null && (extension = vHostItem.getExtension(HardenedModeVHostItemExtension.class)) != null) {
            mode = extension.getMode();
        }
        mode = HARDENED_MODE.global.equals((Object)mode) ? this.hardenedMode : mode;
        log.log(Level.INFO, "Using hardened-mode: {0} for domain: {1}", new String[]{String.valueOf((Object)mode), domain});
        return mode;
    }

    private void invalidateContextHolder(SSLContextContainerAbstract.SSLHolder holder, String alias) throws Exception {
        this.sslContexts.remove(alias);
        this.createCertificate(alias);
    }

    @HandleEvent
    private void onCertificateChange(CertificateContainer.CertificateChanged event) {
        this.sslContexts.remove(event.getAlias());
        SSLContextContainer.removeMatchedDomains(this.sslContexts, event.getDomains());
    }

    private boolean validateDomainCertificate(SSLContextContainerAbstract.SSLHolder holder, String alias) throws Exception {
        if (holder != null && holder.domainCertificate != null && holder.domainCertificate.getIssuerDN().equals(holder.domainCertificate.getSubjectDN())) {
            try {
                holder.domainCertificate.checkValidity();
            }
            catch (CertificateException e) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Certificate for domain: {0} is not valid, exception: {1}, certificate: {2}", new String[]{alias, String.valueOf(e), String.valueOf(holder.domainCertificate)});
                }
                this.invalidateContextHolder(holder, alias);
                return false;
            }
        }
        return true;
    }

    @Bean(name="rootSslContextContainer", parent=Kernel.class, active=true, exportable=true)
    public static class Root
    extends SSLContextContainer
    implements Initializable,
    UnregisterAware {
        @Override
        public void beforeUnregister() {
            this.stop();
        }

        @Override
        public void initialize() {
            this.start();
        }

        @Override
        public void setParent(SSLContextContainerIfc parent) {
            log.log(Level.FINE, "setting root = " + parent);
        }
    }

    @Bean(name="hardened-mode", parent=VHostItemExtensionManager.class, active=true)
    public static class HardenedModeVHostItemExtensionProvider
    implements VHostItemExtensionProvider<HardenedModeVHostItemExtension> {
        @Override
        public String getId() {
            return "hardened-mode";
        }

        @Override
        public Class<HardenedModeVHostItemExtension> getExtensionClazz() {
            return HardenedModeVHostItemExtension.class;
        }
    }

    public static class HardenedModeVHostItemExtension
    extends AbstractVHostItemExtension<HardenedModeVHostItemExtension>
    implements VHostItemExtensionBackwardCompatible<HardenedModeVHostItemExtension> {
        public static final String ID = "hardened-mode";
        private HARDENED_MODE mode = HARDENED_MODE.secure;

        public static HARDENED_MODE parseHardenedModeFromString(String modeString) {
            HARDENED_MODE m = HARDENED_MODE.secure;
            try {
                m = HARDENED_MODE.valueOf(modeString);
            }
            catch (IllegalArgumentException e) {
                String legacyOption = modeString.trim().toLowerCase();
                if ("true".equals(legacyOption)) {
                    m = HARDENED_MODE.secure;
                } else if ("false".equals(legacyOption)) {
                    m = HARDENED_MODE.relaxed;
                }
            }
            catch (Exception e) {
                m = HARDENED_MODE.global;
            }
            return m;
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void initFromElement(Element item) {
            this.mode = HardenedModeVHostItemExtension.parseHardenedModeFromString(item.getAttributeStaticStr(this.getId()));
        }

        @Override
        public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
            String fieldValue = Command.getFieldValue(packet, prefix);
            this.mode = fieldValue != null ? HardenedModeVHostItemExtension.parseHardenedModeFromString(fieldValue) : HARDENED_MODE.global;
        }

        public HARDENED_MODE getMode() {
            return this.mode;
        }

        @Override
        public String toDebugString() {
            return "hardened-mode: " + (Object)((Object)this.mode);
        }

        @Override
        public Element toElement() {
            if (this.mode == null || this.mode.equals((Object)HARDENED_MODE.getDefault())) {
                return null;
            }
            Element el = new Element(this.getId());
            el.setAttribute(this.getId(), String.valueOf((Object)this.mode));
            return el;
        }

        @Override
        public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
            Element commandEl = packet.getElemChild("command", "http://jabber.org/protocol/commands");
            DataForm.addFieldValue(commandEl, this.getId(), String.valueOf((Object)this.getMode()), this.getId(), HARDENED_MODE.stringValues(), HARDENED_MODE.stringValues(), DataForm.FieldType.ListSingle.value());
        }

        @Override
        public void initFromData(Map<String, Object> data) {
            HARDENED_MODE val = (HARDENED_MODE)((Object)data.remove(this.getId()));
            if (val != null) {
                this.mode = val;
            }
        }

        @Override
        public HardenedModeVHostItemExtension mergeWithDefaults(HardenedModeVHostItemExtension defaults) {
            return this.mode == HARDENED_MODE.global ? defaults : this;
        }
    }

    public static enum HARDENED_MODE {
        global,
        relaxed,
        secure,
        strict;


        public static HARDENED_MODE getDefault() {
            return secure;
        }

        static String[] stringValues() {
            return (String[])EnumSet.allOf(HARDENED_MODE.class).stream().map(Enum::name).toArray(String[]::new);
        }
    }
}

