/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import tigase.Assert;
import tigase.db.DataSource;
import tigase.db.NonAuthUserRepository;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MessageAmp;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.push.PushNotificationHelper;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.jid.JID;

public class PushNotificationsWithAwayTest
extends ProcessorTestCase {
    private MsgRepository msgRepository;
    private PushNotifications pushNotifications;
    private JID pushServiceJid = JID.jidInstanceNS((String)"push.example.com");
    private JID recipientJid;
    private JID senderJid;

    @Override
    @Before
    public void setUp() throws Exception {
        this.recipientJid = JID.jidInstanceNS((String)("recipient-" + UUID.randomUUID() + "@example.com/res-1"));
        this.senderJid = JID.jidInstanceNS((String)("sender-" + UUID.randomUUID() + "@example.com/res-1"));
        super.setUp();
        this.registerLocalBeans(this.getKernel());
        this.pushNotifications = this.getInstance(PushNotifications.class);
        this.msgRepository = this.getInstance(MsgRepository.class);
        Kernel subkernel = (Kernel)this.getInstance("urn:xmpp:push:0#KERNEL");
        subkernel.setBeanActive("away", true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_initialState() throws Exception {
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void test_enable() throws Exception {
        Element iqEl = new Element("iq", new Element[]{new Element("enable", new String[]{"xmlns", "jid", "node", "away"}, new String[]{"urn:xmpp:push:0", this.pushServiceJid.toString(), "push-node", "true"})}, new String[]{"type", "id"}, new String[]{"set", UUID.randomUUID().toString()});
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.recipientJid);
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(session.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.process(iq, session, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        org.junit.Assert.assertEquals((String)("wrong result = " + result), (Object)StanzaType.result, (Object)result.getType());
        org.junit.Assert.assertNotNull((Object)this.getInstance(UserRepository.class).getData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node"));
        Map settings = this.pushNotifications.getPushServices(this.recipientJid.getBareJID());
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)1L, (long)settings.size());
        Assert.assertElementEquals(new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}), (Element)settings.get(this.pushServiceJid + "/push-node"));
        settings = this.pushNotifications.getPushServices(session);
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)1L, (long)settings.size());
        Assert.assertElementEquals(new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}), (Element)settings.get(this.pushServiceJid + "/push-node"));
    }

    @Test
    public void test_disable() throws Exception {
        Element iqEl = new Element("iq", new Element[]{new Element("disable", new String[]{"xmlns", "jid", "node"}, new String[]{"urn:xmpp:push:0", this.pushServiceJid.toString(), "push-node"})}, new String[]{"type", "id"}, new String[]{"set", UUID.randomUUID().toString()});
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.recipientJid);
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(session.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.process(iq, session, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        org.junit.Assert.assertEquals((String)("wrong result = " + result), (Object)StanzaType.result, (Object)result.getType());
        org.junit.Assert.assertNull((Object)this.getInstance(UserRepository.class).getData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node"));
        Map settings = this.pushNotifications.getPushServices(this.recipientJid.getBareJID());
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)0L, (long)settings.size());
        settings = this.pushNotifications.getPushServices(session);
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)0L, (long)settings.size());
    }

    @Test
    public void test_notificationGeneration() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node", "away"}, new String[]{this.pushServiceJid.toString(), "push-node", "true"}).toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createPlainNotification(1L, this.senderJid, msgBody));
        Assert.assertElementEquals(expNotification.getElement(), results.poll().packet.getElement());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        results.clear();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createPlainNotification(2L, this.senderJid, msgBody));
        Assert.assertElementEquals(expNotification.getElement(), results.poll().packet.getElement());
    }

    @Test
    public void test_notificationGenerationAway() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node", "away"}, new String[]{this.pushServiceJid.toString(), "push-node", "true"}).toString());
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)this.recipientJid.getDomain()), this.recipientJid);
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Element presence = new Element("presence");
        presence.addChild((XMLNodeIfc)new Element("show", "xa"));
        session.setPresence(presence);
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        presence = new Element("presence");
        session.setPresence(presence);
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertArrayEquals((Object[])new Element[0], (Object[])results.stream().map(ProcessorTestCase.SessionManagerHandlerImpl.Item::getPacket).map(Packet::getElement).toArray(Element[]::new));
    }

    @Test
    public void test_notificationGenerationForMUCwhenOnline() throws Exception {
        this.getInstance(UserRepository.class).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)this.recipientJid.getDomain()), this.recipientJid);
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        Queue<ProcessorTestCase.SessionManagerHandlerImpl.Item> results = this.getInstance(ProcessorTestCase.SessionManagerHandlerImpl.class).getOutQueue();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        Element presence = new Element("presence");
        session.setPresence(presence);
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns", "type"}, new String[]{"jabber:client", "groupchat"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid.copyWithoutResource());
        results.clear();
        this.pushNotifications.process(packet, session, null, new ArrayDeque(), new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
    }

    protected void registerLocalBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("sess-man").asInstance((Object)this.getSessionManagerHandler()).setActive(true).exportable().exec();
        kernel.registerBean(MessageAmp.class).setActive(true).exportable().exec();
        kernel.registerBean("msgRepository").asClass(MsgRepositoryIfcImpl.class).exportable().exec();
        kernel.registerBean(PushNotifications.class).setActive(true).exportable().exec();
    }

    public static class MsgRepositoryIfcImpl
    extends MsgRepository {
        private final Queue<Packet> stored = new ArrayDeque<Packet>();

        public Element getMessageExpired(long time, boolean delete) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
            LinkedList<Element> res = new LinkedList<Element>();
            for (Packet pac : this.stored) {
                res.add(pac.getElement());
            }
            return res;
        }

        public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
            return this.stored.offer(Packet.packetInstance((Element)msg, (JID)from, (JID)to));
        }

        public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException {
            return this.stored.stream().collect(Collectors.groupingBy(packet -> {
                switch (packet.getElemName()) {
                    case "message": {
                        return MsgRepository.MSG_TYPES.message;
                    }
                    case "presence": {
                        return MsgRepository.MSG_TYPES.presence;
                    }
                }
                return MsgRepository.MSG_TYPES.none;
            }, Collectors.counting()));
        }

        public List<Element> getMessagesList(JID to) throws UserNotFoundException {
            return null;
        }

        public int deleteMessagesToJID(List db_ids, XMPPResourceConnection session) throws UserNotFoundException {
            return 0;
        }

        public Queue<Element> loadMessagesToJID(List db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
            return null;
        }

        public Queue<Packet> getStored() {
            return this.stored;
        }

        public void setDataSource(DataSource dataSource) {
        }

        protected void loadExpiredQueue(int max) {
        }

        protected void loadExpiredQueue(Date expired) {
        }

        protected void deleteMessage(Object db_id) {
        }
    }
}

