/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.form.Field;
import tigase.form.Form;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqRegister;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class JabberIqRegisterTest
extends ProcessorTestCase {
    private JabberIqRegister jabberIqRegister = new JabberIqRegister();

    @Override
    @Before
    public void setUp() throws Exception {
        this.jabberIqRegister = new JabberIqRegister();
        this.jabberIqRegister.init(new HashMap());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.jabberIqRegister = null;
        super.tearDown();
    }

    @Test
    public void testRegistrationForm() throws TigaseStringprepException, XMPPException {
        Element iq = new Element("iq", new String[]{"type", "to", "id"}, new String[]{"set", "sure.im", "some-id"});
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:register"});
        Form form = new Form("submit", "Registration form", "Fill out the form");
        form.addField(Field.fieldTextSingle((String)"username", (String)"wojtektest", (String)"Username"));
        form.addField(Field.fieldTextPrivate((String)"password", (String)"wojtektestpass", (String)"Password"));
        form.addField(Field.fieldTextSingle((String)"email", (String)"wojtek@example.com ", (String)"Email (MUST BE VALID!)"));
        query.addChild((XMLNodeIfc)form.getElement());
        iq.addChild((XMLNodeIfc)query);
        Packet packet = Packet.packetInstance((Element)iq);
        JID connId = JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString()));
        packet.setPacketFrom(connId);
        BareJID userJid = BareJID.bareJIDInstance((String)"wojtektest@example.com");
        JID userResource = JID.jidInstance((BareJID)userJid, (String)"resource");
        XMPPResourceConnection session2 = this.getSession(connId, userResource);
        ArrayDeque results = new ArrayDeque();
        this.jabberIqRegister.process(packet, session2, null, results, null);
        Assert.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
        Packet response = (Packet)results.poll();
        Assert.assertTrue((boolean)StanzaType.result.equals((Object)response.getType()));
    }
}

