/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.TestLogger;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DomainFilter;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class DomainFilterTest
extends ProcessorTestCase {
    private static final Logger log = TestLogger.getLogger(DomainFilterTest.class);
    JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
    String domain = "domain";
    JID externalDomainUser = JID.jidInstanceNS((String)"user2", (String)(this.domain + "-ext"), (String)"resource2");
    JID localDomainUser = JID.jidInstanceNS((String)"user2", (String)(this.domain + 2), (String)"resource2");
    Packet p;
    JID recp1 = JID.jidInstanceNS((String)"user1", (String)(this.domain + 1), (String)"resource1");
    ArrayDeque<Packet> results;
    JID sameDomainUser = JID.jidInstanceNS((String)"user2", (String)(this.domain + 1), (String)"resource2");
    XMPPResourceConnection session;
    private DomainFilter domainFilter;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.domainFilter = new DomainFilter();
        this.domainFilter.init(new HashMap());
        this.results = new ArrayDeque();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.domainFilter = null;
    }

    @Test
    public void testPolicyHierarchy() throws NotAuthorizedException, TigaseStringprepException, TigaseDBException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.LIST, new String[]{this.domain + 1, this.domain + 2, this.domain + 3});
        Assert.assertEquals((String)"Reading DomainFilterPolicy from VHost", (Object)DomainFilterPolicy.LIST, (Object)this.domainFilter.getDomains(this.session));
        this.session.removeCommonSessionData("allowed-domains");
        this.session.setData(null, "allowed-domains", DomainFilterPolicy.ALL.name());
        Assert.assertEquals((String)"Reading DomainFilterPolicy from UserRepo, takes precendence over VHost", (Object)DomainFilterPolicy.ALL, (Object)this.domainFilter.getDomains(this.session));
        this.session.removeCommonSessionData("allowed-domains");
        this.session.putCommonSessionData("allowed-domains", (Object)DomainFilterPolicy.BLOCK);
        Assert.assertEquals((String)"Reading DomainFilterPolicy from user session, takes precendence over UserRepository", (Object)DomainFilterPolicy.BLOCK, (Object)this.domainFilter.getDomains(this.session));
        this.session.removeCommonSessionData("allowed-domains");
        String[] domainsList = this.domainFilter.getDomainsList(this.session);
        Assert.assertTrue((String)"Reading domain list from VHost", (boolean)Arrays.asList(domainsList).contains(this.domain + 1));
        Assert.assertFalse((String)"Reading domain list from VHost", (boolean)Arrays.asList(domainsList).contains(this.domain + 5));
        this.session.removeCommonSessionData("allowed-domains-list");
        this.session.setData(null, "allowed-domains-list", this.domain + 11 + ";" + this.domain + 12 + ";" + this.domain + 13);
        domainsList = this.domainFilter.getDomainsList(this.session);
        log.log(Level.FINE, Arrays.asList(domainsList).toString());
        Assert.assertTrue((String)"Reading domain list from repository", (boolean)Arrays.asList(domainsList).contains(this.domain + 11));
        Assert.assertFalse((String)"Reading domain list from repository", (boolean)Arrays.asList(domainsList).contains(this.domain + 15));
        this.session.removeCommonSessionData("allowed-domains-list");
        this.session.putCommonSessionData("allowed-domains-list", (Object)new String[]{this.domain + 21, this.domain + 22, this.domain + 23});
        domainsList = this.domainFilter.getDomainsList(this.session);
        log.log(Level.FINE, Arrays.asList(domainsList).toString());
        Assert.assertTrue((String)"Reading domain list from session", (boolean)Arrays.asList(domainsList).contains(this.domain + 21));
        Assert.assertFalse((String)"Reading domain list from session", (boolean)Arrays.asList(domainsList).contains(this.domain + 25));
        this.session.removeCommonSessionData("allowed-domains-list");
        this.session.logout();
    }

    @Test
    public void testFilterAllPolicy() throws NotAuthorizedException, TigaseStringprepException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.ALL, null);
        this.filterPacket(this.session, this.sameDomainUser);
        Assert.assertFalse((String)"ALL policy, message between same domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.localDomainUser);
        Assert.assertFalse((String)"ALL policy, message between different local domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.externalDomainUser);
        Assert.assertFalse((String)"ALL policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testFilterLocalPolicy() throws NotAuthorizedException, TigaseStringprepException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.LOCAL, null);
        this.filterPacket(this.session, this.sameDomainUser);
        Assert.assertFalse((String)"LOCAL policy, message between same domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.localDomainUser);
        Assert.assertFalse((String)"LOCAL policy, message between different local domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"LOCAL policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testFilterOwnPolicy() throws NotAuthorizedException, TigaseStringprepException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.OWN, null);
        this.filterPacket(this.session, this.sameDomainUser);
        Assert.assertFalse((String)"OWN policy, message between same domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"OWN policy, message between different local domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"OWN policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testFilterWhielistPolicy() throws NotAuthorizedException, TigaseStringprepException {
        String[] whitelistDomains = new String[]{"domain1", this.externalDomainUser.getDomain()};
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.LIST, whitelistDomains);
        this.filterPacket(this.session, this.sameDomainUser);
        Assert.assertFalse((String)"WHITELIST policy, message between same domains (both whitelist)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"WHITELIST policy, message between different local domains (only sender whitelist)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.externalDomainUser);
        Assert.assertFalse((String)"WHITELIST policy, message to external domain (whitelisted)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testFilterBlacklistPolicy() throws NotAuthorizedException, TigaseStringprepException {
        String[] blacklistedDomains = new String[]{this.localDomainUser.getDomain()};
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.BLACKLIST, blacklistedDomains);
        this.filterPacket(this.session, this.sameDomainUser);
        Assert.assertFalse((String)"BLACKLIST policy, message between same domains (not on blacklist)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"BLACKLIST policy, message between different local domains (receiver domain blacklisted)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.externalDomainUser);
        Assert.assertFalse((String)"BLACKLIST policy, message to external domain (not blacklisted)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testFilterBlockPolicy() throws NotAuthorizedException, TigaseStringprepException {
        String[] blacklistedDomains = new String[]{this.localDomainUser.getDomain()};
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.BLOCK, blacklistedDomains);
        this.filterPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"BLOCK policy, message between same domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"BLOCK policy, message between different local domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.filterPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"BLOCK policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testPreprocessorAllPolicy() throws NotAuthorizedException, TigaseStringprepException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.ALL, null);
        this.processPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"ALL policy, message between same domains", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"ALL policy, message between different local domains", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"ALL policy, message to external domain", (boolean)this.results.isEmpty());
        this.session.logout();
    }

    @Test
    public void testPreprocessorLocalPolicy() throws NotAuthorizedException, TigaseStringprepException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.LOCAL, null);
        this.processPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"LOCAL policy, message between same domains", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"LOCAL policy, message between different local domains", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"LOCAL policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testPreprocessorOwnPolicy() throws NotAuthorizedException, TigaseStringprepException {
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.OWN, null);
        this.processPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"OWN policy, message between same domains", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"OWN policy, message between different local domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.processPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"OWN policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    @Test
    public void testPreprocessorWhielistPolicy() throws NotAuthorizedException, TigaseStringprepException {
        String[] whitelistDomains = new String[]{"domain1", this.externalDomainUser.getDomain()};
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.LIST, whitelistDomains);
        this.processPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"WHITELIST policy, message between same domains (both whitelist)", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"WHITELIST policy, message between different local domains (only sender whitelist)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.processPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"WHITELIST policy, message to external domain (whitelisted)", (boolean)this.results.isEmpty());
        this.session.logout();
    }

    @Test
    public void testPreprocessorBlacklistPolicy() throws NotAuthorizedException, TigaseStringprepException {
        String[] blacklistedDomains = new String[]{this.localDomainUser.getDomain()};
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.BLACKLIST, blacklistedDomains);
        this.processPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"BLACKLIST policy, message between same domains (not on blacklist)", (boolean)this.results.isEmpty());
        this.processPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"BLACKLIST policy, message between different local domains (receiver domain blacklisted)", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.processPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"BLACKLIST policy, message to external domain (not blacklisted)", (boolean)this.results.isEmpty());
        this.session.logout();
    }

    @Test
    public void testPreprocessorBlockPolicy() throws NotAuthorizedException, TigaseStringprepException {
        String[] blacklistedDomains = new String[]{this.localDomainUser.getDomain()};
        this.session = this.getSession(this.connId1, this.recp1, DomainFilterPolicy.BLOCK, blacklistedDomains);
        this.processPacket(this.session, this.sameDomainUser);
        Assert.assertTrue((String)"BLOCK policy, message between same domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.processPacket(this.session, this.localDomainUser);
        Assert.assertTrue((String)"BLOCK policy, message between different local domains", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.processPacket(this.session, this.externalDomainUser);
        Assert.assertTrue((String)"BLOCK policy, message to external domain", (boolean)this.results.pop().getType().equals((Object)StanzaType.error));
        this.session.logout();
    }

    private void filterPacket(XMPPResourceConnection session, JID reciever) throws TigaseStringprepException {
        this.p = Packet.packetInstance((String)"message", (String)this.recp1.toString(), (String)reciever.toString(), (StanzaType)StanzaType.chat);
        this.p.setPacketFrom(this.connId1);
        this.results.offer(this.p);
        this.domainFilter.filter(this.p, session, null, this.results);
        log.log(Level.FINEST, "results: " + this.results);
    }

    private void processPacket(XMPPResourceConnection session, JID reciever) throws TigaseStringprepException {
        this.p = Packet.packetInstance((String)"message", (String)this.recp1.toString(), (String)reciever.toString(), (StanzaType)StanzaType.chat);
        this.p.setPacketFrom(this.connId1);
        this.domainFilter.preProcess(this.p, session, null, this.results, null);
        log.log(Level.FINEST, "results: " + this.results);
    }

    private XMPPResourceConnection getSession(JID connId, JID userJid, DomainFilterPolicy dfp, String[] domains) throws NotAuthorizedException, TigaseStringprepException {
        XMPPResourceConnection conn = super.getSession(connId, userJid);
        VHostItemImpl vhost = (VHostItemImpl)conn.getDomain();
        vhost.setDomainFilter(dfp);
        vhost.setDomainFilterDomains(domains);
        return conn;
    }
}

