/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.TimeZone;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class C2SDeliveryErrorProcessorTest
extends ProcessorTestCase {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private Message messageProcessor = new Message();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test() throws Exception {
        Element packetEl = null;
        Packet packet = null;
        JID from = JID.jidInstance((String)"from@example.com/res");
        JID to = JID.jidInstance((String)"to@example.com");
        packetEl = new Element("iq", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packet = Packet.packetInstance((Element)packetEl);
        Packet error = C2SDeliveryErrorProcessor.makeDeliveryError((Packet)packet, (Long)12L);
        Element deliveryError = C2SDeliveryErrorProcessor.getDeliveryError((Packet)error);
        Assert.assertNotNull((Object)deliveryError);
        Assert.assertEquals((Object)"12", (Object)deliveryError.getAttributeStaticStr("stamp"));
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packet = Packet.packetInstance((Element)packetEl);
        error = C2SDeliveryErrorProcessor.makeDeliveryError((Packet)packet, (Long)12L);
        deliveryError = C2SDeliveryErrorProcessor.getDeliveryError((Packet)error);
        Assert.assertNotNull((Object)deliveryError);
        Assert.assertEquals((Object)"12", (Object)deliveryError.getAttributeStaticStr("stamp"));
    }

    @Test
    public void testPreprocessingNotSupportedPackets() throws Exception {
        Element packetEl = null;
        Packet packet = null;
        JID from = JID.jidInstance((String)"from@example.com/res");
        JID to = JID.jidInstance((String)"to@example.com");
        packetEl = new Element("iq", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertFalse((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, null, null, null, null, (Message)this.messageProcessor));
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertFalse((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, null, null, null, null, (Message)this.messageProcessor));
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns"}, new String[]{"http://tigase.org/delivery-error"}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertFalse((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, null, null, null, null, (Message)this.messageProcessor));
    }

    @Test
    public void testPreprocessingWithDeliveryErrorForBareJID() throws Exception {
        Element packetEl = null;
        Packet packet = null;
        JID from = JID.jidInstance((String)"from@example.com/res");
        JID to = JID.jidInstance((String)"to@example.com");
        JID toRes1 = to.copyWithResource("res1");
        JID toRes2 = to.copyWithResource("res2");
        XMPPResourceConnection sessionToRes2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), toRes2);
        Thread.sleep(1L);
        String stampBefore = String.valueOf(System.currentTimeMillis());
        Thread.sleep(1L);
        XMPPResourceConnection sessionToRes1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), toRes1);
        Thread.sleep(1L);
        String stampAfter = String.valueOf(System.currentTimeMillis());
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns"}, new String[]{"http://tigase.org/delivery-error"}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertFalse((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, null, null, (Message)this.messageProcessor));
        sessionToRes1.setPriority(10);
        sessionToRes1.setPresence(new Element("presence"));
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns"}, new String[]{"http://tigase.org/delivery-error"}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertTrue((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, null, null, (Message)this.messageProcessor));
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns"}, new String[]{"http://tigase.org/delivery-error"}));
        packetEl.addChild((XMLNodeIfc)new Element("delay", new String[]{"xmlns"}, new String[]{"urn:xmpp:delay"}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertTrue((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, null, null, (Message)this.messageProcessor));
        ArrayDeque results = new ArrayDeque();
        results.clear();
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns", "stamp"}, new String[]{"http://tigase.org/delivery-error", stampBefore}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertTrue((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, results, null, (Message)this.messageProcessor));
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)sessionToRes1.getConnectionId(), (Object)result.getPacketTo());
        sessionToRes2.setPriority(10);
        sessionToRes2.setPresence(new Element("presence"));
        results.clear();
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns", "stamp"}, new String[]{"http://tigase.org/delivery-error", stampBefore}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertTrue((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, results, null, (Message)this.messageProcessor));
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.peek();
        Assert.assertEquals((Object)sessionToRes1.getConnectionId(), (Object)result.getPacketTo());
        C2SDeliveryErrorProcessor.filter((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.peek();
        Assert.assertFalse((boolean)C2SDeliveryErrorProcessor.isDeliveryError((Packet)result));
        results.clear();
        packetEl = new Element("message", new String[]{"id", "from", "to"}, new String[]{UUID.randomUUID().toString(), from.toString(), to.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("delivery-error", new String[]{"xmlns", "stamp"}, new String[]{"http://tigase.org/delivery-error", stampAfter}));
        packet = Packet.packetInstance((Element)packetEl);
        Assert.assertTrue((boolean)C2SDeliveryErrorProcessor.preProcess((Packet)packet, (XMPPResourceConnection)sessionToRes1, null, results, null, (Message)this.messageProcessor));
        Assert.assertEquals((long)0L, (long)results.size());
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

