/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import tigase.stats.MaxDailyCounterQueue;

public class MaxDailyCounterQueueTest {
    @Test
    public void getValueOfEmptyQueue() {
        MaxDailyCounterQueue lq = new MaxDailyCounterQueue(5);
        Assert.assertEquals(Optional.empty(), (Object)lq.getMaxValue());
        lq.add((Number)5);
        Assert.assertNotEquals(Optional.empty(), (Object)lq.getMaxValue());
    }

    @Test
    public void getMaxValueInRange() {
        int limit = 5;
        MaxDailyCounterQueueEveryXItems lq = new MaxDailyCounterQueueEveryXItems(5, 1);
        lq.add(1);
        Assert.assertEquals((long)1L, (long)((Integer)lq.getMaxValueInRange(5).get()).intValue());
        lq.add(2);
        Assert.assertEquals((long)2L, (long)((Integer)lq.getMaxValueInRange(5).get()).intValue());
        lq.add(4);
        Assert.assertEquals((long)4L, (long)((Integer)lq.getMaxValueInRange(5).get()).intValue());
        lq.add(5);
        Assert.assertEquals((long)5L, (long)((Integer)lq.getMaxValueInRange(5).get()).intValue());
        lq.add(6);
        Assert.assertEquals((long)6L, (long)((Integer)lq.getMaxValueInRange(5).get()).intValue());
        lq.add(1);
        Assert.assertEquals((long)6L, (long)((Integer)lq.getMaxValueInRange(3).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)lq.getMaxValueInRange(1).get()).intValue());
        lq.add(1);
        lq.add(1);
        Assert.assertEquals((long)1L, (long)((Integer)lq.getMaxValueInRange(3).get()).intValue());
        MaxDailyCounterQueueEveryXItems lq2 = new MaxDailyCounterQueueEveryXItems(1, 4);
        lq2.add(4);
        Assert.assertEquals((long)4L, (long)((Integer)lq2.peek()).intValue());
        lq2.add(3);
        Assert.assertEquals((long)4L, (long)((Integer)lq2.peek()).intValue());
        lq2.add(2);
        Assert.assertEquals((long)4L, (long)((Integer)lq2.peek()).intValue());
        lq2.add(1);
        Assert.assertEquals((long)4L, (long)((Integer)lq2.peek()).intValue());
        lq2.add(8);
        Assert.assertEquals((long)8L, (long)((Integer)lq2.peek()).intValue());
    }

    @Test
    public void isLimitSurpassed() {
        int collectionSize = 5;
        int limit = 5;
        MaxDailyCounterQueueEveryXItems lq = new MaxDailyCounterQueueEveryXItems(5, 1);
        lq.add(1);
        Assert.assertFalse((boolean)lq.isLimitSurpassed(3, 5));
        lq.add(6);
        Assert.assertTrue((boolean)lq.isLimitSurpassed(3, 5));
        lq.add(1);
        Assert.assertTrue((boolean)lq.isLimitSurpassed(3, 5));
        lq.add(1);
        Assert.assertTrue((boolean)lq.isLimitSurpassed(3, 5));
        lq.add(1);
        Assert.assertFalse((boolean)lq.isLimitSurpassed(3, 5));
        Assert.assertTrue((boolean)lq.isLimitSurpassed(4, 5));
    }

    @Test
    public void isLimitSurpassedAllItems() {
        int collectionSize = 5;
        int limit = 5;
        MaxDailyCounterQueueEveryXItems lq = new MaxDailyCounterQueueEveryXItems(5, 1);
        lq.add(1);
        Assert.assertFalse((boolean)lq.isLimitSurpassedAllItems(3, 5));
        lq.add(6);
        Assert.assertFalse((boolean)lq.isLimitSurpassedAllItems(3, 5));
        lq.add(6);
        Assert.assertFalse((boolean)lq.isLimitSurpassedAllItems(3, 5));
        lq.add(6);
        Assert.assertTrue((boolean)lq.isLimitSurpassedAllItems(3, 5));
        lq.add(1);
        Assert.assertFalse((boolean)lq.isLimitSurpassedAllItems(3, 5));
        lq.add(1);
        Assert.assertFalse((boolean)lq.isLimitSurpassedAllItems(3, 5));
    }

    @Test
    public void concurrentAddition() {
        int collectionSize = 500;
        int limit = 5;
        MaxDailyCounterQueueEveryXItems lq = new MaxDailyCounterQueueEveryXItems(500, 1);
        Random random = new Random();
        ((Stream)Stream.generate(random::nextInt).parallel()).limit(500L).forEach(arg_0 -> lq.add(arg_0));
        Assert.assertEquals((long)500L, (long)lq.size());
    }

    class MaxDailyCounterQueueEveryXItems<E extends Number>
    extends MaxDailyCounterQueue<E> {
        private final int modulo;
        int i;

        MaxDailyCounterQueueEveryXItems(int limit, int everyXItem) {
            super(limit);
            this.i = 0;
            this.modulo = everyXItem;
        }

        protected boolean isNextItem() {
            return this.i++ % this.modulo == 0;
        }
    }
}

