/*
 * Decompiled with CFR 0.152.
 */
package tigase.map;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventListener;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.map.ClusterMapFactory;
import tigase.map.DMap;
import tigase.map.MapCreatedEvent;
import tigase.map.MapDestroyedEvent;

public class ClusterMapFactoryTest {
    @Test
    public void testCreateMap() throws Exception {
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        final Object[] createdEvent = new Object[]{null};
        eventBus.addListener(ClusterMapFactory.NewMapCreatedEvent.class, (EventListener)new EventListener<ClusterMapFactory.NewMapCreatedEvent>(){

            public void onEvent(ClusterMapFactory.NewMapCreatedEvent event) {
                Assert.assertNull((Object)createdEvent[0]);
                createdEvent[0] = event;
            }
        });
        Map map = factory.createMap("test", String.class, String.class, new String[]{"1", "2", "3"});
        Thread.sleep(100L);
        Assert.assertNotNull((Object)createdEvent[0]);
    }

    @Test
    public void testDestroyMap() throws Exception {
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        final Object[] destroyedEvent = new Object[]{null};
        eventBus.addListener(ClusterMapFactory.MapDestroyEvent.class, (EventListener)new EventListener<ClusterMapFactory.MapDestroyEvent>(){

            public void onEvent(ClusterMapFactory.MapDestroyEvent event) {
                Assert.assertNull((Object)destroyedEvent[0]);
                destroyedEvent[0] = event;
            }
        });
        Map map = factory.createMap("test2", String.class, String.class, new String[]{"1", "2", "3"});
        factory.destroyMap(map);
        Thread.sleep(100L);
        Assert.assertNotNull((Object)destroyedEvent[0]);
    }

    @Test
    public void testPutToMap() throws Exception {
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        final boolean[] received = new boolean[]{false};
        final Map map = factory.createMap("test", String.class, String.class, new String[0]);
        eventBus.addListener(ClusterMapFactory.ElementAddEvent.class, (EventListener)new EventListener<ClusterMapFactory.ElementAddEvent>(){

            public void onEvent(ClusterMapFactory.ElementAddEvent event) {
                received[0] = true;
                Assert.assertEquals((Object)"kluczyk", (Object)event.getKey());
                Assert.assertEquals((Object)"wartosc", (Object)event.getValue());
                Assert.assertEquals((Object)((DMap)map).getUid(), (Object)event.getUid());
            }
        });
        map.put("kluczyk", "wartosc");
        Thread.sleep(100L);
        Assert.assertTrue((boolean)received[0]);
    }

    @Test
    public void testRemoteCreatedMap() throws Exception {
        ClusterMapFactory.NewMapCreatedEvent eventCreate = new ClusterMapFactory.NewMapCreatedEvent();
        eventCreate.setUid("test");
        eventCreate.setKeyClass(String.class);
        eventCreate.setValueClass(String.class);
        eventCreate.setParams(new String[]{"1", "2"});
        ClusterMapFactory factory = new ClusterMapFactory();
        factory.setEventBus((EventBus)new EventBusImplementation());
        EventBus eventBus = factory.getEventBus();
        final Map[] maps = new Map[]{null};
        eventBus.addListener(MapCreatedEvent.class, (EventListener)new EventListener<MapCreatedEvent>(){

            public void onEvent(MapCreatedEvent e) {
                maps[0] = e.getMap();
                Assert.assertEquals((Object)"test", (Object)e.getUid());
                Assert.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])e.getParameters());
            }
        });
        factory.onNewMapCreated(eventCreate);
        Thread.sleep(100L);
        Assert.assertNotNull((String)"It seems map was not created", (Object)maps[0]);
        Assert.assertEquals((Object)"test", (Object)((DMap)maps[0]).uid);
        ClusterMapFactory.ElementAddEvent eventAdd = new ClusterMapFactory.ElementAddEvent();
        eventAdd.setUid("test");
        eventAdd.setKey("xKEY");
        eventAdd.setValue("xVALUE");
        factory.onMapElementAdd(eventAdd);
        eventAdd = new ClusterMapFactory.ElementAddEvent();
        eventAdd.setUid("test");
        eventAdd.setKey("yKEY");
        eventAdd.setValue("yVALUE");
        factory.onMapElementAdd(eventAdd);
        Assert.assertEquals((Object)"xVALUE", maps[0].get("xKEY"));
        Assert.assertEquals((Object)"yVALUE", maps[0].get("yKEY"));
        Assert.assertEquals((long)2L, (long)maps[0].size());
        ClusterMapFactory.ElementRemoveEvent eventDel = new ClusterMapFactory.ElementRemoveEvent();
        eventDel.setUid("test");
        eventDel.setKey("xKEY");
        factory.onMapElementRemove(eventDel);
        Assert.assertNull(maps[0].get("xKEY"));
        Assert.assertEquals((long)1L, (long)maps[0].size());
        ClusterMapFactory.MapClearEvent eventClear = new ClusterMapFactory.MapClearEvent();
        eventClear.setUid("test");
        factory.onMapClear(eventClear);
        Assert.assertEquals((long)0L, (long)maps[0].size());
        final boolean[] received = new boolean[]{false};
        eventBus.addListener(MapDestroyedEvent.class, (EventListener)new EventListener<MapDestroyedEvent>(){

            public void onEvent(MapDestroyedEvent event) {
                Assert.assertEquals((Object)maps[0], (Object)event.getMap());
                received[0] = true;
            }
        });
        Assert.assertNotNull((Object)factory.getMap("test"));
        ClusterMapFactory.MapDestroyEvent eventDestroy = new ClusterMapFactory.MapDestroyEvent();
        eventDestroy.setUid("test");
        factory.onMapDestroyed(eventDestroy);
        Assert.assertNull((Object)factory.getMap("test"));
        Thread.sleep(100L);
        Assert.assertTrue((boolean)received[0]);
    }
}

