/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import tigase.server.xmppclient.StreamErrorCounterIOProcessor;
import tigase.stats.StatisticsProvider;
import tigase.xmpp.impl.ErrorCounter;

public class ErrorsStatisticsProvider
implements DynamicMBean {
    private static final String ERRORS_NUMBER = "ErrorsNumber";
    private static final String PER_SECOND = "PerSecond";
    private static final String TOTAL = "Total";
    private static final String TYPE_FLOAT = "java.lang.Float";
    private static final String TYPE_LONG = "java.lang.Long";
    private final Map<String, String> attrToKey = new HashMap<String, String>();
    private final String dClassName = this.getClass().getName();
    private final MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[0];
    private final String dDescription = "Error statistics MBean";
    private final MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private final Map<String, Holder> stats = new ConcurrentHashMap<String, Holder>();
    private final Map<String, String> statsKeyToKey = new HashMap<String, String>();
    private MBeanAttributeInfo[] dAttributes;
    private MBeanInfo dMBeanInfo = null;
    private String[] statsKeys;

    public ErrorsStatisticsProvider() {
        this.buildDynamicMBeanInfo();
    }

    public void update(StatisticsProvider sp) {
        Map<String, Object> data = sp.getCurStats(this.statsKeys);
        for (String statKey : this.statsKeys) {
            String key = this.statsKeyToKey.get(statKey);
            long value = (Long)data.getOrDefault(statKey, 0);
            Holder holder = this.stats.get(key);
            if (holder == null) {
                holder = new Holder();
                this.stats.put(key, holder);
            }
            holder.updateTotal(value);
        }
        for (String errorName : StreamErrorCounterIOProcessor.ErrorStatisticsHolder.getErrorNames()) {
            long total = 0L;
            for (String compName : sp.getCompNames()) {
                String key = "StreamErrorStats/" + errorName + ERRORS_NUMBER;
                total += sp.getStats(compName, key, 0L);
            }
            Holder holder = this.stats.get(errorName);
            if (holder == null) {
                holder = new Holder();
                this.stats.put(errorName, holder);
            }
            holder.updateTotal(total);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        boolean total = attribute.endsWith(TOTAL);
        boolean perSec = attribute.endsWith(PER_SECOND);
        Holder holder = this.stats.get(attribute = this.attrToKey.get(attribute));
        if (holder != null) {
            if (total) {
                return holder.getTotal();
            }
            if (perSec) {
                return Float.valueOf(holder.getPerSecond());
            }
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Unknown attribute name " + attribute), "Cannot invoke a getter of " + this.dClassName);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (String attributeName : attributeNames) {
            try {
                Object value = this.getAttribute(attributeName);
                resultList.add(new Attribute(attributeName, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        switch (actionName) {
            case "getAllStats": {
                return this.getAllStats();
            }
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("Unknown method " + actionName), "Cannot invoke a method " + actionName);
    }

    public Map<String, String> getAllStats() throws MBeanException, ReflectionException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String attr : this.attrToKey.keySet()) {
            try {
                Object value = this.getAttribute(attr);
                if (value == null) continue;
                result.put(attr, String.valueOf(value));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {}
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    private void buildDynamicMBeanInfo() {
        String attrName;
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
        for (String errorName : ErrorCounter.ErrorStatisticsHolder.getErrorNames()) {
            attrName = errorName + ERRORS_NUMBER + PER_SECOND;
            attrs.add(new MBeanAttributeInfo(attrName, TYPE_FLOAT, "Number of errors " + errorName + " per second", true, false, false));
            this.attrToKey.put(attrName, errorName);
            attrName = errorName + ERRORS_NUMBER + TOTAL;
            attrs.add(new MBeanAttributeInfo(attrName, TYPE_LONG, "Total number of errors " + errorName, true, false, false));
            this.attrToKey.put(attrName, errorName);
        }
        for (String errorName : StreamErrorCounterIOProcessor.ErrorStatisticsHolder.getErrorNames()) {
            attrName = errorName + ERRORS_NUMBER + PER_SECOND;
            attrs.add(new MBeanAttributeInfo(attrName, TYPE_FLOAT, "Number of errors " + errorName + " per second", true, false, false));
            this.attrToKey.put(attrName, errorName);
            attrName = errorName + ERRORS_NUMBER + TOTAL;
            attrs.add(new MBeanAttributeInfo(attrName, TYPE_LONG, "Total number of errors " + errorName, true, false, false));
            this.attrToKey.put(attrName, errorName);
        }
        this.dAttributes = attrs.toArray(new MBeanAttributeInfo[attrs.size()]);
        this.dOperations[0] = new MBeanOperationInfo("getAllStats", "Provides errors statistics", new MBeanParameterInfo[0], "java.util.Map", 0);
        this.dMBeanInfo = new MBeanInfo(this.dClassName, "Error statistics MBean", this.dAttributes, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
        String[] errorNames = ErrorCounter.ErrorStatisticsHolder.getErrorNames();
        this.statsKeys = new String[errorNames.length];
        for (int i = 0; i < errorNames.length; ++i) {
            String key;
            this.statsKeys[i] = key = "sess-man/ErrorStats/" + errorNames[i] + "ErrorsNumber[L]";
            this.statsKeyToKey.put(key, errorNames[i]);
        }
    }

    private static class Holder {
        private float perSec = 0.0f;
        private float prevPerSec = 0.0f;
        private long total = 0L;

        private Holder() {
        }

        public void updateTotal(long newValue) {
            float temp = this.perSec;
            long prevTotal = this.total;
            this.total = newValue;
            this.perSec = (this.prevPerSec + temp * 2.0f + (float)(this.total - prevTotal)) / 4.0f;
            this.prevPerSec = temp;
        }

        public long getTotal() {
            return this.total;
        }

        public float getPerSecond() {
            return this.perSec;
        }
    }
}

