/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.Kernel;
import tigase.util.reflection.ReflectionHelper;

public class DependencyManager {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<String, BeanConfig> beanConfigs = new ConcurrentHashMap<String, BeanConfig>();
    private DependencyManager parent;
    private boolean throwExceptionIfCannotCreate = false;

    public static Field[] getAllFields(Class<?> klass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(klass.getDeclaredFields()));
        if (klass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(DependencyManager.getAllFields(klass.getSuperclass())));
        }
        return fields.toArray(new Field[0]);
    }

    public static boolean match(Dependency dependency, BeanConfig beanConfig) {
        if (dependency.getBeanName() != null) {
            return beanConfig.getBeanName().equals(dependency.getBeanName());
        }
        if (dependency.getType() != null) {
            Class<?> type = dependency.getType();
            if (Collection.class.isAssignableFrom(type)) {
                Map<TypeVariable<?>, Type> expectedTypes = ReflectionHelper.createGenericsTypeMap(dependency.getBeanConfig().getClazz());
                return ReflectionHelper.compareTypes(ReflectionHelper.getCollectionParamter(dependency.getGenericType(), dependency.getBeanConfig().getClazz()), beanConfig.getClazz(), expectedTypes, null);
            }
            return type.isAssignableFrom(beanConfig.getClazz());
        }
        throw new RuntimeException("Unsupported dependecy type.");
    }

    public BeanConfig[] getBeanConfig(Dependency dependency) {
        ArrayList<BeanConfig> bcs = new ArrayList<BeanConfig>();
        if (this.parent != null && this.parent != this) {
            BeanConfig[] pds;
            for (BeanConfig beanConfig : pds = this.parent.getBeanConfig(dependency)) {
                if (beanConfig == null || !beanConfig.isExportable() || beanConfig.getState() == BeanConfig.State.inactive) continue;
                bcs.add(beanConfig);
            }
        }
        if (dependency.getBeanName() != null) {
            BeanConfig b = this.beanConfigs.get(dependency.getBeanName());
            if (b != null && b.getState() != BeanConfig.State.inactive) {
                bcs.clear();
                bcs.add(b);
            }
            if (bcs.isEmpty()) {
                bcs.add(null);
            }
        } else if (dependency.getType() != null) {
            Class type = dependency.getType();
            if (Collection.class.isAssignableFrom(type)) {
                ParameterizedType pt;
                Type fieldGenericType = dependency.getGenericType();
                if (fieldGenericType instanceof ParameterizedType && (pt = (ParameterizedType)fieldGenericType).getActualTypeArguments().length == 1) {
                    fieldGenericType = pt.getActualTypeArguments()[0];
                }
                if (fieldGenericType instanceof Class) {
                    type = (Class)fieldGenericType;
                } else if (fieldGenericType instanceof ParameterizedType) {
                    type = (Class)((ParameterizedType)fieldGenericType).getRawType();
                } else if (fieldGenericType instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)fieldGenericType;
                    type = tv.getBounds().length == 1 ? (Class)tv.getBounds()[0] : Object.class;
                }
                bcs.addAll(this.getBeanConfigs(type, fieldGenericType, dependency.getBeanConfig().getClazz()));
            } else {
                bcs.addAll(this.getBeanConfigs(type, dependency.getGenericType(), dependency.getBeanConfig().getClazz()));
            }
        } else {
            throw new RuntimeException("Unsupported dependecy type.");
        }
        return bcs.toArray(new BeanConfig[0]);
    }

    public BeanConfig getBeanConfig(String beanName) {
        return this.beanConfigs.get(beanName);
    }

    public Collection<BeanConfig> getBeanConfigs() {
        return Collections.unmodifiableCollection(this.beanConfigs.values());
    }

    public List<BeanConfig> getBeanConfigs(Class<?> type, Type genericType, Class<?> ownerClass) {
        return this.getBeanConfigs(type, genericType, ownerClass, true);
    }

    public List<BeanConfig> getBeanConfigs(Class<?> type, Type genericType, Class<?> ownerClass, boolean allowNonExportable) {
        ArrayList<BeanConfig> result = new ArrayList<BeanConfig>();
        for (BeanConfig bc : this.beanConfigs.values()) {
            if (bc.getState() == BeanConfig.State.inactive || !type.isAssignableFrom(bc.getClazz()) || !allowNonExportable && !bc.isExportable()) continue;
            if (genericType == null) {
                result.add(bc);
                continue;
            }
            Map<TypeVariable<?>, Type> map = ReflectionHelper.createGenericsTypeMap(ownerClass);
            if (!ReflectionHelper.compareTypes(genericType, bc.getClazz(), map, null)) continue;
            result.add(bc);
        }
        return result;
    }

    public Collection<Dependency> getDependenciesTo(BeanConfig destination) {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (BeanConfig candidate : this.beanConfigs.values()) {
            for (Dependency dp : candidate.getFieldDependencies().values()) {
                List<BeanConfig> bcs = Arrays.asList(this.getBeanConfig(dp));
                if (!bcs.contains(destination)) continue;
                result.add(dp);
            }
        }
        return result;
    }

    public HashSet<BeanConfig> getDependentBeans(BeanConfig beanConfig) {
        HashSet<BeanConfig> result = new HashSet<BeanConfig>();
        for (BeanConfig candidate : this.beanConfigs.values()) {
            if (candidate.getState() == BeanConfig.State.inactive) continue;
            for (Dependency dp : candidate.getFieldDependencies().values()) {
                List<BeanConfig> bcs = Arrays.asList(this.getBeanConfig(dp));
                if (!bcs.contains(beanConfig)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    public boolean isBeanClassRegistered(String beanName) {
        return this.beanConfigs.containsKey(beanName);
    }

    public boolean isThrowExceptionIfCannotCreate() {
        return this.throwExceptionIfCannotCreate;
    }

    public void setThrowExceptionIfCannotCreate(boolean throwExceptionIfCannotCreate) {
        this.throwExceptionIfCannotCreate = throwExceptionIfCannotCreate;
    }

    public BeanConfig unregister(String beanName) {
        return this.beanConfigs.remove(beanName);
    }

    BeanConfig[] findDelegationTo(BeanConfig beanConfig) {
        return (BeanConfig[])this.beanConfigs.values().stream().filter(beanConfig1 -> beanConfig1 instanceof Kernel.DelegatedBeanConfig && ((Kernel.DelegatedBeanConfig)beanConfig1).getOriginal().equals(beanConfig)).toArray(BeanConfig[]::new);
    }

    DependencyManager getParent() {
        return this.parent;
    }

    void setParent(DependencyManager parent) {
        this.parent = parent;
    }

    void register(BeanConfig beanConfig) {
        this.beanConfigs.put(beanConfig.getBeanName(), beanConfig);
        if (beanConfig.getState() != BeanConfig.State.inactive) {
            beanConfig.setState(BeanConfig.State.registered);
        }
    }

    protected BeanConfig createBeanConfig(Kernel kernel, String beanName, Class<?> beanClass) {
        try {
            BeanConfig result = new BeanConfig(beanName, beanClass);
            result.setKernel(kernel);
            this.prepareDependencies(result);
            return result;
        }
        catch (NoClassDefFoundError e) {
            this.log.log(Level.WARNING, "Cannot create bean config '" + beanName + "', type=" + beanClass.getName() + ". Bean requires unknown class " + e.getMessage());
            if (this.throwExceptionIfCannotCreate) {
                throw e;
            }
            return null;
        }
    }

    protected void prepareDependencies(BeanConfig beanConfig) {
        String id = beanConfig.getBeanName();
        Class<?> cls = beanConfig.getClazz();
        Map<Field, Inject> deps = this.createFieldsDependencyList(cls);
        for (Map.Entry<Field, Inject> e : deps.entrySet()) {
            Field f = e.getKey();
            Dependency d = new Dependency(beanConfig);
            d.setField(f);
            d.setNullAllowed(e.getValue().nullAllowed());
            if (!e.getValue().bean().isEmpty()) {
                d.setBeanName(e.getValue().bean());
            } else if (e.getValue().type() != Inject.EMPTY.class) {
                d.setType(e.getValue().type());
            } else if (f.getType().isArray()) {
                d.setType(f.getType().getComponentType());
            } else {
                Class<?> type = f.getType();
                d.setType(type);
                d.setGenericType(f.getGenericType());
            }
            beanConfig.getFieldDependencies().put(e.getKey(), d);
        }
    }

    private Map<Field, Inject> createFieldsDependencyList(Class<?> cls) {
        HashMap<Field, Inject> deps = new HashMap<Field, Inject>();
        for (Field field : DependencyManager.getAllFields(cls)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            deps.put(field, injectAnnotation);
        }
        return deps;
    }
}

