/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import tigase.TestLogger;
import tigase.xmpp.impl.TokenBucketPool;

public class TokenBucketPoolTest {
    private static final Logger log = TestLogger.getLogger(TokenBucketPoolTest.class);

    private static final double makeTest(TokenBucketPool t, long testTime) throws InterruptedException {
        long endTime;
        long registrations = 0L;
        long startTime = System.currentTimeMillis();
        while ((endTime = System.currentTimeMillis()) - startTime < testTime) {
            boolean b = t.consume("default");
            if (b) {
                ++registrations;
            }
            Thread.sleep(3L);
        }
        log.log(Level.FINE, "Received " + registrations + " events in " + (double)(endTime - startTime) / 1000.0 + " seconds (" + (double)registrations / ((double)(endTime - startTime) / 1000.0) + " eps).");
        return (double)registrations / ((double)(endTime - startTime) / 1000.0);
    }

    @Test
    public void testItem02() {
        TokenBucketPool.TokenBucket it = new TokenBucketPool.TokenBucket(0L, 10.0f, (float)TimeUnit.MILLISECONDS.toNanos(1000L));
        Assert.assertEquals((float)1.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1000L));
        Assert.assertEquals((float)10.0f, (float)it.getAllowance(), (float)0.0f);
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertEquals((float)0.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1001L));
        Assert.assertEquals((double)0.01f, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1002L));
        Assert.assertEquals((double)0.02f, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1500L));
        Assert.assertEquals((double)5.0, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1501L));
        Assert.assertEquals((double)5.01f, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1503L));
        Assert.assertEquals((double)5.03f, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(1601L));
        Assert.assertEquals((double)6.01f, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(2000L));
        Assert.assertEquals((double)10.0, (double)it.getAllowance(), (double)0.001);
        it.updateAllowance(TimeUnit.MILLISECONDS.toNanos(102000L));
        Assert.assertEquals((double)10.0, (double)it.getAllowance(), (double)0.001);
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertEquals((float)9.0f, (float)it.getAllowance(), (float)0.0f);
    }

    @Test
    public void testItem01() {
        TokenBucketPool.TokenBucket it = new TokenBucketPool.TokenBucket(0L, 10.0f, 2.0f);
        Assert.assertEquals((float)1.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(1L);
        Assert.assertEquals((float)6.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(1L);
        Assert.assertEquals((float)6.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(2L);
        Assert.assertEquals((float)10.0f, (float)it.getAllowance(), (float)0.0f);
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertEquals((float)9.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(3L);
        Assert.assertEquals((float)10.0f, (float)it.getAllowance(), (float)0.0f);
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertEquals((float)1.0f, (float)it.getAllowance(), (float)0.0f);
        it.updateAllowance(4L);
        Assert.assertEquals((float)6.0f, (float)it.getAllowance(), (float)0.0f);
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertTrue((boolean)it.consumeNoUpdate());
        Assert.assertFalse((boolean)it.consumeNoUpdate());
        Assert.assertEquals((float)0.0f, (float)it.getAllowance(), (float)0.0f);
    }

    @Test
    public void testPurge() throws InterruptedException {
        TokenBucketPool t = new TokenBucketPool(1L, 1L, TimeUnit.NANOSECONDS);
        t.setAutoPurgeEnabled(false);
        t.consume("jeden");
        Assert.assertEquals((long)1L, (long)t.size());
        t.consume("jeden");
        Assert.assertEquals((long)1L, (long)t.size());
        t.consume("dwa");
        Assert.assertEquals((long)2L, (long)t.size());
        t.consume("trzy");
        Assert.assertEquals((long)3L, (long)t.size());
        Thread.sleep(3L);
        Assert.assertEquals((long)3L, (long)t.size());
        t.purge();
        Assert.assertEquals((long)0L, (long)t.size());
    }

    public void testConsume() throws Exception {
        this.assertInRange(2.0, 0.06, TokenBucketPoolTest.makeTest(new TokenBucketPool(2L, 1L, TimeUnit.SECONDS), TimeUnit.SECONDS.toMillis(60L)));
    }

    private void assertInRange(double expectedValue, double devPercent, double value) {
        if (Math.abs(value - expectedValue) > devPercent * expectedValue) {
            Assert.fail((String)("Value not in range: expected " + expectedValue + " +/- " + devPercent * expectedValue + ", but received " + value));
        }
    }
}

