/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.TestLogger;
import tigase.db.TigaseDBException;
import tigase.eventbus.EventBusFactory;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqPrivacy;
import tigase.xmpp.impl.PrivacyList;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.JID;

public class JabberIqPrivacyTest
extends ProcessorTestCase {
    private static final Logger log = TestLogger.getLogger(JabberIqPrivacyTest.class);
    private JabberIqPrivacy privacyFilter;
    private ArrayDeque<Packet> results;

    @Override
    @Before
    public void setUp() throws Exception {
        block2: {
            try {
                this.getKernel().registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
                this.getKernel().registerBean(RosterFactory.Bean.class).setActive(true).exec();
                this.getKernel().getInstance(RosterFactory.Bean.class);
                this.getKernel().registerBean(JabberIqPrivacy.class).exec();
                this.privacyFilter = this.getInstance(JabberIqPrivacy.class);
                this.getKernel().getDependencyManager().getBeanConfig("jabber:iq:privacy").getKernel().setBeanActive("privacyListOfflineCache", true);
                this.results = new ArrayDeque();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.privacyFilter = null;
    }

    @Test
    public void testValidateListGood() {
        ArrayList<Element> items = new ArrayList<Element>();
        Authorization result = null;
        items.add(new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"subscription", "both", "allow", "10"}));
        items.add(new Element("item", new String[]{"action", "order"}, new String[]{"deny", "15"}));
        result = JabberIqPrivacy.validateList(null, items);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testValidateListBadAction() {
        ArrayList<Element> items = new ArrayList<Element>();
        Authorization result = null;
        items.add(new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"subscription", "both", "ignore", "10"}));
        items.add(new Element("item", new String[]{"action", "order"}, new String[]{"deny", "15"}));
        result = JabberIqPrivacy.validateList(null, items);
        Assert.assertEquals((Object)Authorization.BAD_REQUEST, (Object)result);
    }

    @Test
    public void testValidateListBadSubscription() {
        ArrayList<Element> items = new ArrayList<Element>();
        Authorization result = null;
        items.add(new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"subscription", "or", "allow", "10"}));
        items.add(new Element("item", new String[]{"action", "order"}, new String[]{"deny", "15"}));
        result = JabberIqPrivacy.validateList(null, items);
        Assert.assertEquals((Object)Authorization.BAD_REQUEST, (Object)result);
    }

    @Test
    public void testValidateListBadType() {
        ArrayList<Element> items = new ArrayList<Element>();
        Authorization result = null;
        items.add(new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"other", "both", "allow", "10"}));
        items.add(new Element("item", new String[]{"action", "order"}, new String[]{"deny", "15"}));
        result = JabberIqPrivacy.validateList(null, items);
        Assert.assertEquals((Object)Authorization.BAD_REQUEST, (Object)result);
    }

    @Test
    public void testValidateListOrderUnsignedInt() {
        ArrayList<Element> items = new ArrayList<Element>();
        Authorization result = null;
        items.add(new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"subscription", "both", "allow", "-10"}));
        items.add(new Element("item", new String[]{"action", "order"}, new String[]{"deny", "15"}));
        result = JabberIqPrivacy.validateList(null, items);
        Assert.assertEquals((Object)Authorization.BAD_REQUEST, (Object)result);
    }

    @Test
    public void testValidateListOrderAttributeDuplicate() {
        ArrayList<Element> items = new ArrayList<Element>();
        Authorization result = null;
        items.add(new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"subscription", "both", "allow", "10"}));
        items.add(new Element("item", new String[]{"action", "order"}, new String[]{"deny", "10"}));
        result = JabberIqPrivacy.validateList(null, items);
        Assert.assertEquals((Object)Authorization.BAD_REQUEST, (Object)result);
    }

    @Test
    public void testFilterPresenceOut() throws Exception {
        JID jid = JID.jidInstance((String)"test@example/res-1");
        JID connId = JID.jidInstance((String)"c2s@example.com/asdasd");
        XMPPResourceConnection session = this.getSession(connId, jid);
        Element list = new Element("list", new String[]{"name"}, new String[]{"default"});
        Element item = new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"jid", "test1.example.com", "deny", "100"});
        item.addChild((XMLNodeIfc)new Element("presence-out"));
        list.addChild((XMLNodeIfc)item);
        list.addChild((XMLNodeIfc)new Element("item", new String[]{"action", "order"}, new String[]{"allow", "110"}));
        session.putSessionData("active-list", (Object)PrivacyList.create(null, (Element)list));
        Packet presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{"test@example/res-1", "test1.example.com"}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(presence, session));
        presence = Packet.packetInstance((Element)new Element("presence", new String[]{"to", "from"}, new String[]{"test@example/res-1", "test1.example.com"}));
        Assert.assertTrue((boolean)this.privacyFilter.allowed(presence, session));
    }

    @Test
    public void testGroupSubscriptionTypeFiltering() throws Exception {
        JID jid = JID.jidInstance((String)"test@example/res-1");
        JID connId = JID.jidInstance((String)"c2s@example.com/asdasd");
        XMPPResourceConnection session = this.getSession(connId, jid);
        session.putCommonSessionData("roster", new ConcurrentHashMap());
        Element list = new Element("list", new String[]{"name"}, new String[]{"default"});
        Element item = new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"subscription", "none", "deny", "100"});
        item.addChild((XMLNodeIfc)new Element("presence-out"));
        item.addChild((XMLNodeIfc)new Element("presence-in"));
        item.addChild((XMLNodeIfc)new Element("message"));
        list.addChild((XMLNodeIfc)item);
        list.addChild((XMLNodeIfc)new Element("item", new String[]{"action", "order"}, new String[]{"allow", "110"}));
        session.putSessionData("active-list", (Object)PrivacyList.create((Map)((Map)session.getCommonSessionData("roster")), (Element)list));
        Packet presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{"test@example/res-1", "test1.example.com"}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(presence, session));
        Packet message = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{"test1.example.com", "test@example.com/res-1"}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(message, session));
        Packet iq = Packet.packetInstance((Element)new Element("iq", new String[]{"from", "to"}, new String[]{"test1.example.com", "test@example.com/res-1"}));
        Assert.assertTrue((boolean)this.privacyFilter.allowed(iq, session));
    }

    @Test
    public void testStanzaType() throws Exception {
        JID jid = JID.jidInstance((String)"test@example/res-1");
        JID connId = JID.jidInstance((String)"c2s@example.com/asdasd");
        XMPPResourceConnection session = this.getSession(connId, jid);
        this.checkStanzaType(session, "get", null, 1, StanzaType.result);
        this.checkStanzaType(session, "set", new Element("active"), 1, StanzaType.result);
        this.checkStanzaType(session, "error", null, 0, null);
        this.checkStanzaType(session, "result", null, 0, null);
        this.checkStanzaType(session, "probe", null, 1, StanzaType.error);
        this.checkStanzaType(session, null, null, 1, StanzaType.error);
    }

    @Test
    public void testFilterJidCase() throws Exception {
        JID jid = JID.jidInstance((String)"test@example/res-1");
        JID connId = JID.jidInstance((String)"c2s@example.com/asdasd");
        XMPPResourceConnection session = this.getSession(connId, jid);
        String blockedJID = "CapitalisedJID@test.domain.com";
        Element list = new Element("list", new String[]{"name"}, new String[]{"default"});
        list.addChild((XMLNodeIfc)new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"jid", blockedJID.toLowerCase(), "deny", "100"}));
        list.addChild((XMLNodeIfc)new Element("item", new String[]{"action", "order"}, new String[]{"allow", "110"}));
        session.putSessionData("active-list", (Object)PrivacyList.create(null, (Element)list));
        Packet presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{blockedJID, jid.toString()}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(presence, session));
        presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{blockedJID.toLowerCase(), jid.toString()}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(presence, session));
        presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{jid.toString(), blockedJID}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(presence, session));
        presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{jid.toString(), blockedJID.toLowerCase()}));
        Assert.assertFalse((boolean)this.privacyFilter.allowed(presence, session));
    }

    @Test
    public void testPartialJidMatching() throws Exception {
        JID jid = JID.jidInstance((String)"test@example/res-1");
        JID connId = JID.jidInstance((String)"c2s@example.com/resource");
        XMPPResourceConnection session = this.getSession(connId, jid);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test.domain.com/resource", false);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test2.domain.com/resource", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test.domain.com/resource2", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked2@test.domain.com/resource", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "test.domain.com/true", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "test.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked@test.domain.com/resource", false);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked@test.domain.com", false);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked2@test.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked@test2.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com", "test.domain.com/true", true);
        this.testList(session, "partial_blocked@test.domain.com", "test.domain.com", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test.domain.com/resource", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test.domain.com", true);
        this.testList(session, "test.domain.com/true", "test.domain.com/true", false);
        this.testList(session, "test.domain.com/true", "test.domain.com", true);
        this.testList(session, "test.domain.com/true", "test.domain.com/true2", true);
        this.testList(session, "test.domain.com/true", "test.2domain.com", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test2.domain.com/resource", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test2.domain.com", true);
        this.testList(session, "test.domain.com/true", "test2.domain.com/true", true);
        this.testList(session, "test.domain.com/true", "test.domain.com/true2", true);
        this.testList(session, "test.domain.com/true", "test2.domain.com", true);
        this.testList(session, "test.domain.com", "partial_blocked@test.domain.com/resource", false);
        this.testList(session, "test.domain.com", "partial_blocked@test.domain.com", false);
        this.testList(session, "test.domain.com", "test.domain.com/true", false);
        this.testList(session, "test.domain.com", "test.domain.com", false);
        this.testList(session, "test.domain.com", "partial_blocked@test2.domain.com/resource", true);
        this.testList(session, "test.domain.com", "partial_blocked@test2.domain.com", true);
        this.testList(session, "test.domain.com", "test2.domain.com/true", true);
        this.testList(session, "test.domain.com", "test2.domain.com", true);
    }

    @Test
    public void testPartialJidMatchingOffline() throws Exception {
        XMPPResourceConnection session = null;
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test.domain.com/resource", false);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test2.domain.com/resource", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test.domain.com/resource2", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked2@test.domain.com/resource", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "partial_blocked@test.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "test.domain.com/true", true);
        this.testList(session, "partial_blocked@test.domain.com/resource", "test.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked@test.domain.com/resource", false);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked@test.domain.com", false);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked2@test.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com", "partial_blocked@test2.domain.com", true);
        this.testList(session, "partial_blocked@test.domain.com", "test.domain.com/true", true);
        this.testList(session, "partial_blocked@test.domain.com", "test.domain.com", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test.domain.com/resource", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test.domain.com", true);
        this.testList(session, "test.domain.com/true", "test.domain.com/true", false);
        this.testList(session, "test.domain.com/true", "test.domain.com", true);
        this.testList(session, "test.domain.com/true", "test.domain.com/true2", true);
        this.testList(session, "test.domain.com/true", "test.2domain.com", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test2.domain.com/resource", true);
        this.testList(session, "test.domain.com/true", "partial_blocked@test2.domain.com", true);
        this.testList(session, "test.domain.com/true", "test2.domain.com/true", true);
        this.testList(session, "test.domain.com/true", "test.domain.com/true2", true);
        this.testList(session, "test.domain.com/true", "test2.domain.com", true);
        this.testList(session, "test.domain.com", "partial_blocked@test.domain.com/resource", false);
        this.testList(session, "test.domain.com", "partial_blocked@test.domain.com", false);
        this.testList(session, "test.domain.com", "test.domain.com/true", false);
        this.testList(session, "test.domain.com", "test.domain.com", false);
        this.testList(session, "test.domain.com", "partial_blocked@test2.domain.com/resource", true);
        this.testList(session, "test.domain.com", "partial_blocked@test2.domain.com", true);
        this.testList(session, "test.domain.com", "test2.domain.com/true", true);
        this.testList(session, "test.domain.com", "test2.domain.com", true);
    }

    private void checkStanzaType(XMPPResourceConnection session, String type, Element additionalChild, int expectedResultSize, StanzaType expectedStanzaType) throws TigaseStringprepException, XMPPException {
        Element iq = new Element("iq");
        if (type != null) {
            iq.setAttribute("type", type);
        }
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:privacy"});
        if (null != additionalChild) {
            query.addChild((XMLNodeIfc)additionalChild);
        }
        iq.addChild((XMLNodeIfc)query);
        Packet p = Packet.packetInstance((Element)iq);
        this.privacyFilter.process(p, session, null, this.results, null);
        Assert.assertEquals((long)expectedResultSize, (long)this.results.size());
        if (expectedResultSize > 0) {
            Packet result = this.results.poll();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"iq", (Object)result.getElemName());
            Assert.assertEquals((Object)expectedStanzaType, (Object)result.getType());
        }
    }

    private void testList(XMPPResourceConnection session, String listJID, String testJID, boolean shouldBeAllowed) throws TigaseStringprepException, NotAuthorizedException, TigaseDBException {
        JID jid = JID.jidInstance((String)"test@example/res-1");
        JID blockedJID = JID.jidInstance((String)listJID);
        Element list = new Element("list", new String[]{"name"}, new String[]{"default"});
        list.addChild((XMLNodeIfc)new Element("item", new String[]{"type", "value", "action", "order"}, new String[]{"jid", blockedJID.toString(), "deny", "100"}));
        list.addChild((XMLNodeIfc)new Element("item", new String[]{"action", "order"}, new String[]{"allow", "110"}));
        if (session != null) {
            session.putSessionData("active-list", (Object)PrivacyList.create(null, (Element)list));
        } else {
            this.getUserRepository().setData(jid.getBareJID(), "privacy", "default-list", "default");
            this.getUserRepository().setData(jid.getBareJID(), "privacy/default", "privacy-list", list.toString());
            this.privacyFilter.cache.clear();
        }
        Packet presence = Packet.packetInstance((Element)new Element("presence", new String[]{"from", "to"}, new String[]{testJID, jid.toString()}));
        boolean isAllowed = this.privacyFilter.allowed(presence, session);
        log.log(Level.FINE, "Privacy item: " + listJID + ", tested item: " + testJID + ", result: " + isAllowed);
        if (shouldBeAllowed) {
            Assert.assertTrue((boolean)isAllowed);
        } else {
            Assert.assertFalse((boolean)isAllowed);
        }
    }
}

