/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import tigase.server.websocket.WebSocketHybi;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;
import tigase.util.Base64;

public class WebSocketHybiTest
extends TestCase {
    private WebSocketHybi impl;

    @Test
    public void testCalculateWsAcceptKey() throws Exception {
        WebSocketHybiTest.assertEquals((String)"s3pPLMBiTxaQ9kYGzzhZRbK+xOo=", (String)WebSocketHybi.calculateWsAcceptKey((String)"dGhlIHNhbXBsZSBub25jZQ=="));
        WebSocketHybiTest.assertEquals((String)"3YUhy9uOn3SwgBgA9kDld2AH2r8=", (String)WebSocketHybi.calculateWsAcceptKey((String)"Ox0pU/Y2qstxzCqKHwtJcQ=="));
        WebSocketHybiTest.assertEquals((String)"4vvUf3Izc4cQeL8fr4oZX5qxxFs=", (String)WebSocketHybi.calculateWsAcceptKey((String)"tsmEcS/j84lYkxw4SyfCYg=="));
    }

    @Test
    public void testFrameEncodingDecoding() throws IOException {
        String input = "<test-data><subdata/></test-data>";
        ByteBuffer buf = ByteBuffer.wrap(input.getBytes());
        final ByteBuffer tmp = ByteBuffer.allocate(1024);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHybi()}){

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }
        };
        io.maskingKey = new byte[4];
        this.impl.encodeFrameAndWrite((WebSocketXMPPIOService)io, buf);
        tmp.flip();
        ByteBuffer tmp1 = this.maskFrame(tmp);
        ByteBuffer decoded = this.impl.decodeFrame((WebSocketXMPPIOService)io, tmp1);
        Assert.assertArrayEquals((String)"Data before encoding do not match data after decoding", (byte[])input.getBytes(), (byte[])decoded.array());
    }

    @Test
    public void testHandshakeFail() throws NoSuchAlgorithmException, IOException {
        final ByteBuffer tmp = ByteBuffer.allocate(2048);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHybi()}){

            public int getLocalPort() {
                return 80;
            }

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sec-WebSocket-Key1".toUpperCase(), "1C2J899_05  6  !  M 9    ^4");
        params.put("Sec-WebSocket-Key2".toUpperCase(), "23 2ff0M_E0#.454X23");
        params.put("Sec-WebSocket-Protocol".toUpperCase(), "xmpp");
        byte[] bytes = new byte[10];
        bytes[0] = 13;
        bytes[1] = 10;
        Assert.assertFalse((String)"Handshake succeeded", (boolean)this.impl.handshake((WebSocketXMPPIOService)io, params, bytes));
    }

    @Test
    public void testHandshakeOK() throws NoSuchAlgorithmException, IOException {
        final ByteBuffer tmp = ByteBuffer.allocate(2048);
        final StringBuilder sb = new StringBuilder();
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHybi()}){

            public int getLocalPort() {
                return 80;
            }

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }

            protected void writeData(String data) {
                sb.append(data);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Sec-WebSocket-Version".toUpperCase(), "13");
        params.put("Sec-WebSocket-Key".toUpperCase(), "some random data as a key");
        params.put("Sec-WebSocket-Protocol".toUpperCase(), "xmpp");
        byte[] bytes = new byte[10];
        bytes[0] = 13;
        bytes[1] = 10;
        Assert.assertTrue((String)"Handshake failed", (boolean)this.impl.handshake((WebSocketXMPPIOService)io, params, bytes));
        tmp.flip();
        byte[] read = new byte[tmp.remaining()];
        Optional<String> secWebSocketAccept = Arrays.stream(sb.toString().split("\n")).map(line -> line.split(":")).filter(line -> "Sec-WebSocket-Accept".equalsIgnoreCase(line[0].trim())).map(line -> line[1]).map(String::trim).findFirst();
        String expSecWebSocketAccept = Base64.encode((byte[])MessageDigest.getInstance("SHA-1").digest("some random data as a key258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(Charset.forName("UTF-8"))));
        WebSocketHybiTest.assertEquals((String)expSecWebSocketAccept, (String)secWebSocketAccept.get());
    }

    @Test
    public void testTwoWebSocketTextFramesInSingleTcpFrame() throws Exception {
        String input1 = "<test-data><subdata/></test-data>";
        String input2 = "<test2/>";
        ByteBuffer frame1 = this.generateIncomingFrame(input1);
        ByteBuffer frame2 = this.generateIncomingFrame(input2);
        ByteBuffer tmp = ByteBuffer.allocate(frame1.remaining() + frame2.remaining());
        tmp.put(frame1);
        tmp.put(frame2);
        tmp.flip();
        WebSocketXMPPIOService io = new WebSocketXMPPIOService(new WebSocketProtocolIfc[]{new WebSocketHybi()});
        io.maskingKey = new byte[4];
        ByteBuffer decoded = this.impl.decodeFrame(io, tmp);
        Assert.assertArrayEquals((String)"Data of first frame before encoding do not match data after decoding", (byte[])input1.getBytes(), (byte[])decoded.array());
        decoded = this.impl.decodeFrame(io, tmp);
        Assert.assertArrayEquals((String)"Data of second frame before encoding do not match data after decoding", (byte[])input2.getBytes(), (byte[])decoded.array());
    }

    @Test
    public void testTwoWebSocketFramesPingAndTextFrameInSingleTcpFrame() throws Exception {
        String input2 = "<test-data><subdata/></test-data>";
        ByteBuffer frame1 = ByteBuffer.allocate(20);
        frame1.put((byte)-119);
        frame1.put((byte)4);
        frame1.put(new byte[]{0, 0, 0, 0});
        frame1.flip();
        frame1 = this.maskFrame(frame1);
        ByteBuffer frame2 = this.generateIncomingFrame(input2);
        ByteBuffer tmp = ByteBuffer.allocate(frame1.remaining() + frame2.remaining());
        tmp.put(frame1);
        tmp.put(frame2);
        tmp.flip();
        final ByteBuffer tmp2 = ByteBuffer.allocate(1024);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHybi()}){

            protected void writeBytes(ByteBuffer data) {
                tmp2.put(data);
            }
        };
        io.maskingKey = new byte[4];
        ByteBuffer decoded = this.impl.decodeFrame((WebSocketXMPPIOService)io, tmp);
        Assert.assertNotNull((Object)decoded);
        Assert.assertArrayEquals((String)"Data of first frame before encoding do not match data after decoding", (byte[])new byte[0], (byte[])decoded.array());
        tmp2.flip();
        Assert.assertNotEquals((String)"PONG frame not sent!", (long)0L, (long)tmp2.remaining());
        WebSocketHybiTest.assertEquals((String)"PONG frame not sent!", (byte)-118, (byte)tmp2.get(0));
        decoded = this.impl.decodeFrame((WebSocketXMPPIOService)io, tmp);
        Assert.assertArrayEquals((String)"Data of second frame before encoding do not match data after decoding", (byte[])input2.getBytes(), (byte[])decoded.array());
    }

    protected void setUp() throws Exception {
        this.impl = new WebSocketHybi();
    }

    protected void tearDown() throws Exception {
        this.impl = null;
    }

    private ByteBuffer maskFrame(ByteBuffer data) {
        ByteBuffer tmp = ByteBuffer.allocate(1024);
        byte[] header = new byte[2];
        data.get(header);
        header[header.length - 1] = (byte)(header[header.length - 1] | 0x80);
        tmp.put(header);
        byte[] mask = new byte[]{0, 0, 0, 0};
        tmp.put(mask);
        while (data.hasRemaining()) {
            byte b = data.get();
            b = (byte)(b ^ 0);
            tmp.put(b);
        }
        tmp.flip();
        return tmp;
    }

    private ByteBuffer generateIncomingFrame(String input) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(input.getBytes());
        final ByteBuffer tmp = ByteBuffer.allocate(1024);
        WebSocketXMPPIOService<Object> io = new WebSocketXMPPIOService<Object>(new WebSocketProtocolIfc[]{new WebSocketHybi()}){

            protected void writeBytes(ByteBuffer data) {
                tmp.put(data);
            }
        };
        io.maskingKey = new byte[4];
        this.impl.encodeFrameAndWrite((WebSocketXMPPIOService)io, buf);
        tmp.flip();
        return this.maskFrame(tmp);
    }
}

