/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import tigase.eventbus.impl.EventsNameMap;

public class EventsNameMapTest {
    @Test
    public void test01() throws Exception {
        EventsNameMap map = new EventsNameMap();
        map.put(null, null, (Object)"null-null");
        map.put(null, null, (Object)"null-null2");
        map.put("2", null, (Object)"null-2");
        map.put(null, "1", (Object)"1-null");
        map.put("2", "1", (Object)"1-2");
        map.put("2", "1", (Object)"1-2_2");
        map.put("b0", "a0", (Object)"U");
        map.put("b0", "a1", (Object)"U");
        map.put("b1", "a0", (Object)"U");
        map.put("b1", "a1", (Object)"U");
        Assert.assertEquals((long)7L, (long)map.getAllData().size());
        Assert.assertEquals((long)8L, (long)map.getAllListenedEvents().size());
        Assert.assertEquals((long)2L, (long)map.get("2", "1").size());
        Assert.assertThat((Object)map.get("2", "1"), (Matcher)CoreMatchers.hasItem((Object)"1-2"));
        Assert.assertThat((Object)map.get("2", "1"), (Matcher)CoreMatchers.hasItem((Object)"1-2_2"));
        Assert.assertThat((Object)map.get(null, "1"), (Matcher)CoreMatchers.hasItem((Object)"1-null"));
        Assert.assertThat((Object)map.get("2", null), (Matcher)CoreMatchers.hasItem((Object)"null-2"));
        Assert.assertThat((Object)map.get(null, null), (Matcher)CoreMatchers.hasItem((Object)"null-null"));
        Assert.assertEquals((long)2L, (long)map.get(null, null).size());
        map.delete("2", "1", (Object)"1-2_2");
        Assert.assertEquals((long)1L, (long)map.get("2", "1").size());
        Assert.assertThat((Object)map.get("2", "1"), (Matcher)CoreMatchers.hasItem((Object)"1-2"));
        Assert.assertThat((Object)map.get("2", "1"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"1-2_2")));
        Assert.assertEquals((long)6L, (long)map.getAllData().size());
        Assert.assertEquals((long)8L, (long)map.getAllListenedEvents().size());
        map.delete((Object)"U");
        Assert.assertEquals((long)5L, (long)map.getAllData().size());
        Assert.assertEquals((long)4L, (long)map.getAllListenedEvents().size());
    }
}

